/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.enums.ModifyStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.request.OrgHotCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseGroupRelateServiceImpl
implements OrgCourseGroupRelateService {
    private static final Logger logger = LoggerFactory.getLogger(OrgCourseGroupRelateServiceImpl.class);
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TeacherClassCourseDao teacherClassCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeHotCourse(Long orgId, Long courseId, Integer courseGroupId, Integer courseType) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (account != null) {
            OrgCourse orgCourse;
            if (courseType.intValue() == CourseType.CLASS.getCode()) {
                TeacherClassCourse classCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)courseId, new String[0]);
                if (classCourse != null && account.getNumber() == classCourse.getOrganizationNumber()) {
                    this.update(orgId, courseId, courseGroupId, courseType);
                }
            } else if (courseType.intValue() == CourseType.ORG_COURSE.getCode() && (orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null && orgCourse.getOrgNumber().intValue() == account.getNumber().intValue()) {
                this.update(orgId, courseId, courseGroupId, courseType);
            }
        }
    }

    private void update(Long orgId, Long courseId, Integer courseGroupId, Integer courseType) {
        OrgCourseGroupRelate orgCourseGroupRelate = this.orgCourseGroupRelateDao.getCourseGroupByCourseId(courseGroupId, courseType, courseId);
        if (orgCourseGroupRelate != null) {
            orgCourseGroupRelate.setIsDeleted(Integer.valueOf(DeleteStatus.DELETED.getValue()));
            orgCourseGroupRelate.setUpdateTime(new Date());
            this.orgCourseGroupRelateDao.update((Object)orgCourseGroupRelate, new String[]{"isDeleted", "updateTime"});
        }
    }

    @Override
    public void batchEdit(List<OrgHotCourseRequestDto> params, Integer orgId) {
        logger.info("batchEdit.params:{}, orgId:{}", params, (Object)orgId);
        for (OrgHotCourseRequestDto dto : params) {
            Integer groupId = dto.getGroupId();
            if (!this.validateParams(orgId, groupId)) continue;
            List<OrgRecommendCourseRequestDto> hotCourses = dto.getList();
            this.declare(hotCourses, orgId, groupId);
        }
    }

    private void declare(List<OrgRecommendCourseRequestDto> hotCourses, Integer orgId, Integer courseGroupId) throws BussinessException {
        if (hotCourses != null && !hotCourses.isEmpty()) {
            int minDisplayOrder = this.getMaxDisplayOrder(hotCourses, courseGroupId);
            HashSet includeCourseIds = Sets.newHashSet();
            for (OrgRecommendCourseRequestDto hotCourse : hotCourses) {
                OrgCourseGroupRelate courseGroupRelate = this.orgCourseGroupRelateDao.getCourseGroupByCourseId(courseGroupId, hotCourse.getCourseType(), hotCourse.getCourseId());
                int modifyStatus = hotCourse.getModifyStatus();
                logger.info("hotCourse:{}, courseGroupRelate:{}", (Object)hotCourse, (Object)courseGroupRelate);
                if (!ModifyStatus.containsKey((int)modifyStatus)) continue;
                ModifyStatus enumVal = ModifyStatus.get((int)modifyStatus);
                switch (enumVal) {
                    case NORMAL: {
                        if (courseGroupRelate == null) break;
                        includeCourseIds.add(hotCourse.getCourseId());
                        this.updateOrDonothingForNormalCourse(hotCourse, courseGroupRelate, minDisplayOrder--);
                        break;
                    }
                    case UPDATE: {
                        if (courseGroupRelate == null || includeCourseIds.contains(hotCourse.getCourseId())) break;
                        this.updateCourseDisplayOrderToZero(courseGroupRelate);
                        break;
                    }
                    case ADDED: {
                        includeCourseIds.add(hotCourse.getCourseId());
                        if (courseGroupRelate != null) {
                            this.update(courseGroupRelate, minDisplayOrder--);
                            break;
                        }
                        this.addCourse(courseGroupId, hotCourse, minDisplayOrder--);
                        break;
                    }
                    case DELETE: {
                        if (courseGroupRelate == null) break;
                        this.deleteCourse(courseGroupRelate);
                        break;
                    }
                }
            }
        }
    }

    private int getMaxDisplayOrder(List<OrgRecommendCourseRequestDto> hotCourses, Integer courseGroupId) {
        List excludeIds = BaseUtils.getListFilter(hotCourses, (String)"courseId");
        int maxDisplayOrder = this.orgCourseGroupRelateDao.getMaxDisplayOrderByExcludeIds(courseGroupId, (Collection)excludeIds);
        maxDisplayOrder = maxDisplayOrder == 0 ? hotCourses.size() + 1 : (maxDisplayOrder += hotCourses.size() + 1);
        return maxDisplayOrder;
    }

    private void deleteCourse(OrgCourseGroupRelate courseGroupRelate) {
        courseGroupRelate.setDisplayOrder(Integer.valueOf(0));
        courseGroupRelate.setIsDeleted(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        courseGroupRelate.setUpdateTime(new Date());
        logger.info("deleteCourse.DELETE:{}", (Object)courseGroupRelate);
        this.orgCourseGroupRelateDao.update((Object)courseGroupRelate, new String[]{"displayOrder", "isDeleted", "updateTime"});
    }

    private void addCourse(int courseGroupId, OrgRecommendCourseRequestDto hotCourse, int minDisplayOrder) {
        OrgCourseGroupRelate courseGroupRelate = new OrgCourseGroupRelate();
        courseGroupRelate.setCourseGroupId(Integer.valueOf(courseGroupId));
        courseGroupRelate.setCourseId(hotCourse.getCourseId());
        courseGroupRelate.setCourseType(hotCourse.getCourseType());
        courseGroupRelate.setCreateTime(new Date());
        courseGroupRelate.setDisplayOrder(Integer.valueOf(minDisplayOrder));
        courseGroupRelate.setIsDeleted(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        logger.info("addCourse.courseGroupRelate.ADD:{}", (Object)courseGroupRelate);
        this.orgCourseGroupRelateDao.save((Object)courseGroupRelate, new String[0]);
    }

    private void updateCourseDisplayOrderToZero(OrgCourseGroupRelate courseGroupRelate) {
        courseGroupRelate.setUpdateTime(new Date());
        courseGroupRelate.setDisplayOrder(Integer.valueOf(0));
        logger.info("updateCourseDisplayOrderToZero.UPDATE.courseGroupRelate:{}", (Object)courseGroupRelate);
        this.orgCourseGroupRelateDao.update((Object)courseGroupRelate, new String[]{"displayOrder", "updateTime"});
    }

    private void updateOrDonothingForNormalCourse(OrgRecommendCourseRequestDto hotCourse, OrgCourseGroupRelate courseGroupRelate, int minDisplayOrder) {
        int displayOrder = courseGroupRelate.getDisplayOrder();
        if (displayOrder < minDisplayOrder) {
            courseGroupRelate.setUpdateTime(new Date());
            courseGroupRelate.setDisplayOrder(Integer.valueOf(minDisplayOrder));
            logger.info("updateOrDonothingForNormalCourse.NORMAL.courseGroupRelate:{}", (Object)courseGroupRelate);
            this.orgCourseGroupRelateDao.update((Object)courseGroupRelate, new String[]{"displayOrder", "updateTime"});
        }
    }

    private void update(OrgCourseGroupRelate courseGroupRelate, int minDisplayOrder) {
        courseGroupRelate.setDisplayOrder(Integer.valueOf(minDisplayOrder));
        courseGroupRelate.setUpdateTime(new Date());
        this.orgCourseGroupRelateDao.update((Object)courseGroupRelate, new String[]{"displayOrder", "updateTime"});
    }

    private boolean validateCourse(Integer orgNumber, Long courseId, Integer courseType) {
        if (courseType.intValue() == CourseType.CLASS.getCode()) {
            TeacherClassCourse classCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)courseId, new String[0]);
            return classCourse != null && classCourse.getOrganizationNumber() == orgNumber;
        }
        if (courseType.intValue() == CourseType.ORG_COURSE.getCode()) {
            OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
            return orgCourse != null && orgCourse.getOrgNumber().longValue() == orgNumber.longValue();
        }
        return false;
    }

    private boolean validateParams(Integer orgId, Integer groupId) {
        OrgCourseGroup courseGroup = (OrgCourseGroup)this.orgCourseGroupDao.getById((Serializable)groupId, new String[0]);
        boolean ret = courseGroup != null && orgId.intValue() == courseGroup.getOrgId().intValue() && courseGroup.getIsDeleted().intValue() == DeleteStatus.NORMAL.getValue();
        logger.info("validateParams.courseGroup:{}, ret:{}", (Object)courseGroup, (Object)ret);
        return ret;
    }
}

