/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.util;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherClassHourDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherCourseDto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportService.class);
    private static String HEADER_FORMAT = "@";
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String UNIT_LESSON_MONEY_FORMULA = "IF(I%d>0,I%d*C%d,0)";
    public static final String UNIT_HOUR_MONEY_FORMULA = "IF(K%d>0,K%d*D%d/60,0)";
    public static final String UNIT_STUDENTSIGN_MONEY_FORMULA = "IF(M%d>0,M%d*F%d,0)";
    public static final String LESSON_MONEY_FORMULA = "SUM(J%d:J%d,L%d:L%d,N%d:N%d)";
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    private static CellStyle createCellStyle(Workbook workBook, String format) {
        CellStyle cellStyle = workBook.createCellStyle();
        DataFormat dataFormat = workBook.createDataFormat();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(dataFormat.getFormat(format));
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        return cellStyle;
    }

    public static Sheet createSheet(Workbook workbook, String sheetName, List<Map<String, Object>> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<TeacherClassHourDto> datas, boolean showLesson) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        ExcelExportService.createTitleRow(sheet, cellStyleMap, titles, columnSize);
        int row = 0;
        if (!CollectionUtils.isEmpty(titles)) {
            row = (Integer)titles.get(titles.size() - 1).get("row");
        }
        ExcelExportService.createHeaderRow(sheet, cellStyleMap, exportFields, ++row);
        ++row;
        for (TeacherClassHourDto tch : datas) {
            Row dataRow = sheet.createRow(row);
            ExcelExportService.createCell(dataRow, 0, tch.getTeacherName(), cellStyleMap, exportFields.get(0));
            int totalLessonCount = 0;
            for (int j = 0; j < tch.getCourses().size(); ++j) {
                TeacherCourseDto course = tch.getCourses().get(j);
                int index = 1;
                int rowNum = row;
                rowNum = totalLessonCount > 0 ? (rowNum += totalLessonCount) : (rowNum += j);
                Row courseRow = null;
                courseRow = j == 0 ? dataRow : sheet.createRow(rowNum);
                ExcelExportService.createCell(courseRow, index, course.getCourseName(), cellStyleMap, exportFields.get(index));
                if (!showLesson) {
                    ExcelExportService.createCell(courseRow, ++index, course.getLessonCount(), cellStyleMap, exportFields.get(index));
                    ExcelExportService.createCell(courseRow, ++index, course.getMinutes(), cellStyleMap, exportFields.get(index));
                    ExcelExportService.createCell(courseRow, ++index, course.getStudentCount(), cellStyleMap, exportFields.get(index));
                    ExcelExportService.createCell(courseRow, ++index, course.getSignCount(), cellStyleMap, exportFields.get(index));
                    ExcelExportService.createCell(courseRow, ++index, course.getLeaveCount(), cellStyleMap, exportFields.get(index));
                    ExcelExportService.createCell(courseRow, ++index, course.getAbsentCount(), cellStyleMap, exportFields.get(index));
                    Cell cell = null;
                    while (index < exportFields.size() - 1) {
                        cell = ExcelExportService.createCell(courseRow, ++index, null, cellStyleMap, exportFields.get(index));
                        if (index == 9) {
                            cell.setCellFormula(String.format(UNIT_LESSON_MONEY_FORMULA, rowNum + 1, rowNum + 1, rowNum + 1));
                        }
                        if (index == 11) {
                            cell.setCellFormula(String.format(UNIT_HOUR_MONEY_FORMULA, rowNum + 1, rowNum + 1, rowNum + 1));
                        }
                        if (index != 13) continue;
                        cell.setCellFormula(String.format(UNIT_STUDENTSIGN_MONEY_FORMULA, rowNum + 1, rowNum + 1, rowNum + 1));
                    }
                    continue;
                }
                if (course.getLessons().size() > 1) {
                    ExcelExportService.mergeCell(sheet, rowNum, rowNum + course.getLessons().size() - 1, index, index);
                }
                for (int k = 0; k < course.getLessons().size(); ++k) {
                    OrgTeacherLessonInfoDto lessonInfo = course.getLessons().get(k);
                    Row lessonRow = null;
                    lessonRow = k == 0 ? courseRow : sheet.createRow(rowNum + k);
                    ExcelExportService.createLessonRow(lessonRow, index, lessonInfo, exportFields, cellStyleMap);
                }
                totalLessonCount += course.getLessons().size();
            }
            if (!showLesson) {
                ExcelExportService.mergeCell(sheet, row, row + tch.getCourses().size() - 1, 0, 0);
                Cell cell = sheet.getRow(row).getCell(exportFields.size() - 1);
                cell.setCellFormula(String.format(LESSON_MONEY_FORMULA, row + 1, row + tch.getCourses().size(), row + 1, row + tch.getCourses().size(), row + 1, row + tch.getCourses().size()));
                ExcelExportService.mergeCell(sheet, row, row + tch.getCourses().size() - 1, exportFields.size() - 1, exportFields.size() - 1);
                row += tch.getCourses().size();
                continue;
            }
            if (totalLessonCount <= 1) {
                totalLessonCount = 1;
            }
            log.debug("merge teacher cell:{},{}", (Object)row, (Object)(row + totalLessonCount - 1));
            ExcelExportService.mergeCell(sheet, row, row + totalLessonCount - 1, 0, 0);
            row += totalLessonCount;
        }
        return sheet;
    }

    private static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        CellRangeAddress rangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        sheet.addMergedRegion(rangeAddress);
        RegionUtil.setBorderBottom((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderTop((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderLeft((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderRight((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
    }

    private static void createLessonRow(Row lessonRow, int baseColumn, OrgTeacherLessonInfoDto lessonInfo, List<ExportField> exportFields, Map<String, CellStyle> cellStyleMap) {
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonNumberInfo(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getRoomName(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStartTime(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonTime(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getMinutes(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStudentCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLeaveCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getAbsentCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getUnsignCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignRate(), cellStyleMap, exportFields.get(baseColumn));
    }

    private static Cell createCell(Row row, int column, Object value, Map<String, CellStyle> cellStyleMap, ExportField exportField) {
        Cell cell = row.createCell(column);
        String localFormat = null;
        Object object = value = value != null ? value : exportField.getDefaultVal();
        if (value != null) {
            if (value instanceof Date) {
                row.getSheet().setColumnWidth(cell.getColumnIndex(), 5120);
                localFormat = EXPORT_DATE_FORMAT;
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                cell.setCellType(0);
                if (value instanceof Double) {
                    localFormat = "0.00";
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    localFormat = "0";
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellType(1);
                cell.setCellValue(value.toString());
                localFormat = "@";
            }
        } else {
            cell.setCellValue("");
        }
        cell.setCellStyle(ExcelExportService.getCellStyle(row.getSheet().getWorkbook(), cellStyleMap, exportField.getFormat() != null ? exportField.getFormat() : localFormat));
        return cell;
    }

    private static CellStyle getCellStyle(Workbook workbook, Map<String, CellStyle> cellStyleMap, String format) {
        if (!cellStyleMap.containsKey(format)) {
            cellStyleMap.put(format, ExcelExportService.createCellStyle(workbook, format));
        }
        return cellStyleMap.get(format);
    }

    private static void createHeaderRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, int row) {
        Row headerRow = sheet.createRow(row);
        int column = 0;
        CellStyle style = ExcelExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT);
        for (ExportField field : exportFields) {
            column = ExcelExportService.createHeaderCell(headerRow, style, field, column);
        }
    }

    private static int createHeaderCell(Row row, CellStyle style, ExportField field, int column) {
        if (CollectionUtils.isEmpty((Collection)field.getChildren())) {
            row.getSheet().setColumnWidth(column, field.getWidth());
            Cell cell = row.createCell(column++);
            cell.setCellStyle(style);
            cell.setCellValue(field.getName());
        } else {
            for (ExportField child : field.getChildren()) {
                column = ExcelExportService.createHeaderCell(row, style, child, column);
            }
        }
        return column;
    }

    private static void createTitleRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<Map<String, Object>> titles, int headerSize) {
        Integer tempRow = null;
        Row titleRow = null;
        if (CollectionUtils.isNotEmpty(titles)) {
            for (Map<String, Object> title : titles) {
                Integer row = (Integer)title.get("row");
                String titleName = (String)title.get("titleName");
                int startCell = (Integer)title.get("startCell");
                int endCell = (Integer)title.get("endCell");
                if (tempRow == null || tempRow.intValue() != row.intValue()) {
                    titleRow = sheet.createRow(row.intValue());
                    tempRow = (int)row;
                }
                Cell cell = titleRow.createCell(startCell);
                cell.setCellValue(titleName);
                cell.setCellStyle(ExcelExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT));
                ExcelExportService.mergeCell(sheet, row, row, startCell, endCell);
            }
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) throws IOException {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workBook.write((OutputStream)os);
            response.setContentLength(os.size());
            os.writeTo((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }
}

