/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.util;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CourseSmsTokenUtil {
    public static String encodeToken(OrgCourseSms sms) throws Exception {
        Preconditions.checkArgument((sms != null ? 1 : 0) != 0, (Object)"smsCourse is null");
        HashMap<String, Object> token = new HashMap<String, Object>();
        token.put("orgId", sms.getOrgId());
        token.put("courseId", sms.getCourseId());
        token.put("id", sms.getId());
        if (UserRole.STUDENT.getRole() == sms.getUserRole().intValue()) {
            token.put("studentId", sms.getStudentId());
        } else if (UserRole.TEACHER.getRole() == sms.getUserRole().intValue()) {
            token.put("teacherId", sms.getUserId());
        }
        return CourseSmsTokenUtil.encodeToken(token);
    }

    public static String encodeToken(Map<String, Object> params) throws Exception {
        Preconditions.checkArgument((params != null && !params.isEmpty() ? 1 : 0) != 0, (Object)"params is null");
        SmsToken token = new SmsToken();
        token.setOrgId((Long)params.get("orgId"));
        token.getParams().putAll(params);
        return EncryptUtils.base64EncodeStrWithFactor((Object)token);
    }

    public static String encodeToken(Map<String, Object> params, Long orgId) throws Exception {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        SmsToken token = new SmsToken();
        token.setOrgId(orgId);
        token.getParams().putAll(params);
        return EncryptUtils.base64EncodeStrWithFactor((Object)token);
    }

    public static SmsToken decodeToken(String token) throws Exception {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String jsonStr = EncryptUtils.strDecode((String)token);
        return (SmsToken)JacksonUtil.str2Obj((String)jsonStr, SmsToken.class);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CourseSmsTokenUtil.encodeToken(Maps.newHashMap(), 3618L));
        String token = "A34ld3cmPjY5Ojg7PTk6Ojs9Pzw1K3l8cVRvLUY_QEBCOTB-b4FwfIMySowzgIR5W3c1TUdIR0pBN4mKi3t8hYxhfDtTTE5NT5iY";
        SmsToken t = CourseSmsTokenUtil.decodeToken(token);
        System.out.println(t.getParams().toString());
    }

    public static class SmsToken {
        private Date ts;
        private Long orgId;
        private Map<String, Object> params = new HashMap<String, Object>();

        public SmsToken() {
            this.ts = new Date();
        }

        public void put(String key, Object value) {
            this.params.put(key, value);
        }

        public Date getTs() {
            return this.ts;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setTs(Date ts) {
            this.ts = ts;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmsToken)) {
                return false;
            }
            SmsToken other = (SmsToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$ts = this.getTs();
            Date other$ts = other.getTs();
            if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
                return false;
            }
            Long this$orgId = this.getOrgId();
            Long other$orgId = other.getOrgId();
            if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmsToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $ts = this.getTs();
            result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
            Long $orgId = this.getOrgId();
            result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        public String toString() {
            return "CourseSmsTokenUtil.SmsToken(ts=" + this.getTs() + ", orgId=" + this.getOrgId() + ", params=" + this.getParams() + ")";
        }
    }
}

