/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgLessonSignServiceImpl
implements OrgLessonSignService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSignServiceImpl.class);
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public void orgStudentLessonBatchSign(Long orgId, Long courseId, Long lessonId, List<Long> studentIds, Integer status) {
        if (CollectionUtils.isEmpty(studentIds) || lessonId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u548c\u5b66\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Map map = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        log.info("update studentIds:{} in lesson:{} to signStatus:{}", new Object[]{map.values(), lessonId, status});
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonId, map.values(), status);
        List signStudents = this.orgLessonSignDao.getLessonStudentIds(orgId, lessonId, map.values(), status, new String[]{"userId"});
        HashSet userIds = Sets.newHashSet(map.values());
        if (CollectionUtils.isNotEmpty((Collection)signStudents)) {
            for (OrgLessonSign signStudent : signStudents) {
                userIds.remove(signStudent.getUserId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"orgId", "courseId"});
            Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
            List newSignStudents = Lists.newArrayList();
            for (Long studentId : userIds) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(lesson.getCourseId());
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                newSignStudents.add(lessonSign);
            }
            log.info("save sign students:{}", (Object)newSignStudents);
            this.orgLessonSignDao.saveAll(newSignStudents, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole"});
        }
    }

    @Override
    public void orgStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId, Integer status) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((lessonId != null && lessonId >= 0L ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((orgId != null && orgId >= 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((studentId != null && studentId >= 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId >= 0L ? 1 : 0) != 0, (Object)("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5b66\u751fID:" + studentId));
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null && status != null && !status.equals(obj.getStatus())) {
            obj.setStatus(status);
            this.orgLessonSignDao.update((Object)obj, new String[]{"status"});
        } else if (obj == null && status != null) {
            OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
            if (lesson == null || !lesson.getOrgId().equals(orgId)) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u9519\u8bef");
            }
            obj = new OrgLessonSign();
            obj.setCourseId(lesson.getCourseId());
            obj.setCreateTime(new Date());
            obj.setLessonId(lessonId);
            obj.setOrgId(orgId);
            obj.setStatus(status);
            obj.setUpdateTime(new Date());
            obj.setUserId(userId);
            obj.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            this.orgLessonSignDao.save((Object)obj, new String[0]);
        }
    }

    @Override
    public OrgStudentLessonSignDto getStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null) {
            OrgStudentLessonSignDto dto = new OrgStudentLessonSignDto();
            dto.setCourseId(obj.getCourseId());
            dto.setCreateTime(obj.getCreateTime());
            dto.setId(obj.getId());
            dto.setLessonId(obj.getLessonId());
            dto.setSignStatusEnum(SignStatus.getSignStatusByCode((Integer)obj.getStatus()));
            dto.setUpdateTime(obj.getUpdateTime());
            return dto;
        }
        return null;
    }

    @Override
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        List signs = this.orgLessonSignDao.getStudentLessonSign(orgId, lessonIds, new String[0]);
        HashMap signUserIdMap = Maps.newHashMap();
        for (OrgLessonSign sign : signs) {
            if (!signUserIdMap.containsKey(String.valueOf(sign.getUserId()))) {
                HashMap map = Maps.newHashMap();
                signUserIdMap.put(String.valueOf(sign.getUserId()), map);
            }
            ((Map)signUserIdMap.get(String.valueOf(sign.getUserId()))).put(String.valueOf(sign.getLessonId()), sign.getStatus());
        }
        HashMap signStudentIdMap = Maps.newHashMap();
        for (String userId : signUserIdMap.keySet()) {
            signStudentIdMap.put(String.valueOf(userIdMap.get(Long.parseLong(userId))), signUserIdMap.get(userId));
        }
        return signStudentIdMap;
    }

    @Override
    public Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        Map userIdCountMap = this.orgLessonSignDao.getOrgLessonSignCount(lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()));
        log.debug("getLessonStudentSignCount result={}", (Object)userIdCountMap);
        log.debug("getLessonStudentSignCount userIdMap={}", userIdMap);
        HashMap studentIdCountMap = Maps.newHashMap();
        for (Long userId : userIdCountMap.keySet()) {
            studentIdCountMap.put(userIdMap.get(userId), userIdCountMap.get(userId));
        }
        log.debug("getLessonStudentSignCount result={}", (Object)studentIdCountMap);
        return studentIdCountMap;
    }
}

