/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTimeSpanDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTimeSpan;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.OrgCourseDetailResponseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTimeSpanDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgCourseServiceImpl
implements OrgCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgTimeSpanDao orgTimeSpanDao;
    @Resource
    private UserDao userDao;
    private static final int TOTAL_COURSE_COLOR_COUNT = 35;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<OrgCourseQueryResponseDto> getOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumber(orgNumber, key, Integer.valueOf(OrgCourseStatus.IN_PROGRESS.getCode()), pageDto, new String[0]);
        HashSet<Long> courseIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
                if (!StringUtils.isEmpty((String)orgCourse.getColor())) continue;
                orgCourse.setColor(this.getNextRandomColor());
                this.orgCourseDao.save((Object)orgCourse, new String[0]);
            }
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    private void fillCourseQueryResponseDto(Map<Long, List<String>> courseIdTeacherIdMap, OrgCourse orgCourse, OrgCourseQueryResponseDto courseQueryResponseDto) {
        courseQueryResponseDto.setCourseName(orgCourse.getName());
        courseQueryResponseDto.setOrgCourseId(orgCourse.getId());
        courseQueryResponseDto.setColor(orgCourse.getColor());
        courseQueryResponseDto.setOrgCourseNumber(orgCourse.getNumber());
        courseQueryResponseDto.setOriginPrice(orgCourse.getPrice());
        List<String> teacherNames = courseIdTeacherIdMap.get(orgCourse.getId());
        if (CollectionUtils.isNotEmpty(teacherNames)) {
            courseQueryResponseDto.setTeacherName(StringUtils.join((Object[])teacherNames.toArray(), (char)','));
        }
    }

    @Override
    public Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds);
        if (CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                ((List)result.get(courseId)).add(teacherNames.get(orgCourseTeacher.getUserId()));
            }
            log.debug("courseIds:{}, teacherNames:{}", courseIds, (Object)teacherNames);
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto) {
        log.info("getOrgLatestCourses-->orgId {}", (Object)orgId);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List courseIds = this.coursePurchaseDao.getLatestdPurchaseCourseIdsList(orgId);
        if (CollectionUtils.isEmpty((Collection)courseIds)) {
            log.info("get no courses id");
            return Collections.emptyList();
        }
        List orgCourses = this.orgCourseDao.getByIdsOrderByIn((Collection)courseIds, pageDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)orgCourses)) {
            log.info("get no courses ids={}", (Object)courseIds);
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    @Override
    public List<String> getCourseColors() {
        String colors = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        Object[] colorsArray = colors.split(",");
        if (colorsArray.length != 35) {
            log.warn("course colors count = {}", (Object)colorsArray.length);
        }
        return Lists.newArrayList((Object[])colorsArray);
    }

    private String getNextRandomColor() {
        List<String> colors = this.getCourseColors();
        Random rand = new Random();
        return colors.get(rand.nextInt(colors.size() - 1));
    }

    @Override
    public void changeCourseColor(@NonNull Long orgId, @NonNull Long courseId, @NonNull String color) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (color == null) {
            throw new NullPointerException("color");
        }
        if (!color.startsWith("#") || color.length() != 7) {
            log.error("color = {} \u683c\u5f0f\u4e0d\u5bf9 ", (Object)color);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "wrong color format.");
        }
        this.orgCourseDao.changeCourseColor(Integer.valueOf(this.getOrgNumber(orgId).intValue()), courseId, color);
    }

    @Override
    public List<OrgCourseDetailResponseDto> getOrgCourseList(Long orgId, int status, PageDto pageDto) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        ArrayList data = Lists.newArrayList();
        if (account == null) {
            return data;
        }
        List courses = this.orgCourseDao.getAndFilterOrgCourse(account.getNumber(), null, pageDto);
        log.debug("orgId:{}, status:{}, courses:{}", new Object[]{orgId, status, courses});
        if (courses != null && !courses.isEmpty()) {
            Map<Long, Storage> storageCache = this.getAndCacheStorage(courses);
            List courseIds = BaseUtils.getListFilter((List)courses, (String)"id");
            Map<Long, List<String>> teacherCache = this.getCourseIdTeacherNamesMap(courseIds);
            OrgCourseDetailResponseDto dto = null;
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            for (OrgCourse course : courses) {
                dto = new OrgCourseDetailResponseDto();
                dto.setCourseType(CourseType.ORG_COURSE.getCode());
                dto.setName(course.getName());
                dto.setNumber(course.getNumber());
                dto.setPrice(course.getPrice() + "");
                dto.setCourseId(course.getId());
                if (teacherCache.containsKey(course.getId())) {
                    dto.setTeacherName(teacherCache.get(course.getId()).get(0));
                } else {
                    dto.setTeacherName("\u5f85\u5b9a");
                }
                dto.setPreface(this.getImgUrl(course.getCover().longValue(), storageCache, imgServer));
                dto.setLink("{host}/org_class_course/detail/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
                data.add(dto);
            }
        }
        log.info("getOrgCourseList.orgId:{}, status:{}, pageDto:{}, data:{}", new Object[]{orgId, status, pageDto, data});
        return data;
    }

    private Map<Long, Storage> getAndCacheStorage(List<OrgCourse> courses) {
        List storageIds = BaseUtils.getListFilter(courses, (String)"cover");
        Map cache = this.storageDao.getStorageMapByIds((Collection)storageIds);
        log.debug("storageIds:{}, cache:{}", (Object)storageIds, (Object)cache);
        return cache;
    }

    private String getImgUrl(Long storageId, Map<Long, Storage> cache, String imgServer) {
        Storage storage;
        String url = "";
        if (cache.containsKey(storageId) && (storage = cache.get(storageId)) != null) {
            url = this.constructUrl(storage, imgServer);
        }
        return url;
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (StringUtils.isNotBlank((String)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public OrgCourseDetailResponseDto getOrgCourseDetail(Long orgId, Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        OrgCourseDetailResponseDto dto = null;
        if (course != null) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            ArrayList ids = Lists.newArrayList((Object[])new Long[]{course.getId()});
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);
            dto = new OrgCourseDetailResponseDto();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice(course.getPrice() + "");
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("\u5f85\u5b9a");
            }
            Storage storage = (Storage)this.storageDao.getById((Serializable)course.getCover(), new String[0]);
            dto.setPreface(this.constructUrl(storage, imgServer));
            dto.setLink("{host}/org/course/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
        }
        return dto;
    }

    private static boolean checkTime(String start, String end) {
        TimeStamp startTime = TimeStamp.parse((String)start);
        TimeStamp endTime = TimeStamp.parse((String)end);
        if (startTime.getHour() > endTime.getHour()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f00\u59cb\u65f6\u95f4 \u5927\u4e8e \u7ed3\u675f\u65f6\u95f4");
        }
        if (startTime.getMinute() % 5 != 0 || endTime.getMinute() % 5 != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u949f\u4e0d\u662f5\u7684\u6574\u6570\u500d");
        }
        if (startTime.getSecond() != 0 || endTime.getSecond() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u79d2\u5fc5\u987b\u4e3a0");
        }
        return true;
    }

    @Override
    public void addOrEditOrgTimeSpan(Long orgId, List<OrgTimeSpanDto> timeSpanList) {
        log.info("timeSpanList = {}", timeSpanList);
        for (OrgTimeSpanDto dto : timeSpanList) {
            if (!OrgCourseServiceImpl.checkTime(dto.getStartTime(), dto.getEndTime())) {
                return;
            }
            OrgTimeSpan orgTimeSpan = new OrgTimeSpan();
            Time endTime = Time.valueOf(dto.getEndTime());
            Time startTime = Time.valueOf(dto.getStartTime());
            orgTimeSpan.setStartTime(startTime);
            orgTimeSpan.setEndTime(endTime);
            orgTimeSpan.setOrgId(orgId);
            if (dto.getId() == null || dto.getId() == 0L) {
                orgTimeSpan.setId(null);
            } else {
                orgTimeSpan.setId(dto.getId());
            }
            this.orgTimeSpanDao.saveOrUpdate((Object)orgTimeSpan, new String[0]);
        }
    }

    @Override
    public List<OrgTimeSpanDto> listOrgTimeSpan(Long orgId) {
        List list = this.orgTimeSpanDao.listOrgTimeSpan(orgId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgTimeSpan span : list) {
            OrgTimeSpanDto dto = new OrgTimeSpanDto();
            dto.setId(span.getId());
            dto.setStartTime(this.buildTimeStr(span.getStartTime()));
            dto.setEndTime(this.buildTimeStr(span.getEndTime()));
            dtos.add(dto);
        }
        return dtos;
    }

    private String buildTimeStr(Date time) {
        String str = DateUtil.getStrByDateFormate((Date)time, (String)"HH:mm:ss");
        if (str.equals("00:00:00")) {
            str = "24:00:00";
        }
        return str;
    }

    @Override
    public void deleteOrgTimeSpan(@NonNull Collection<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        this.orgTimeSpanDao.delByIds(ids);
    }

    @Override
    public CourseListReponseDto getOrgBasicCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is not null!");
        Preconditions.checkArgument((courseId != null ? 1 : 0) != 0, (Object)"courseId is not null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(course.getId());
        dto.setOrgCourseNumber(course.getNumber());
        dto.setCoverUrl(this.getCoverUrl(courseId));
        return dto;
    }

    private String getCoverUrl(Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course == null) {
            return "";
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)course.getCover(), new String[0]);
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
    }

    @Override
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"student not exists!");
        log.debug("orgId = {}, lessonId{}, studentId ={}, userId={}", new Object[]{orgId, lessonId, studentId, userId});
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Preconditions.checkArgument((lesson != null ? 1 : 0) != 0, (Object)"lesson not exist!");
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[0]);
        HashMap map = Maps.newHashMap();
        map.put("index", lesson.getNumber());
        map.put("startTime", lesson.getStartTime());
        map.put("endTime", lesson.getEndTime());
        map.put("courseName", course.getName());
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{lessonId}));
        log.debug("lessonTeacherMap = {}", (Object)lessonTeacherMap);
        Long teacherId = (Long)lessonTeacherMap.get(lessonId);
        if (teacherId == null) {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            map.put("teacherName", "");
            map.put("avatarUrl", "");
            map.put("teacherId", 0);
            return map;
        }
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        if (teacher != null) {
            map.put("teacherName", teacher.getRealName() != null ? teacher.getRealName() : teacher.getNickName());
            map.put("teacherId", teacher.getUserId());
            if (teacher.getAvatar() != null) {
                Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
                if (storage != null) {
                    map.put("avatarUrl", StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            } else {
                log.warn("\u8001\u5e08\u5934\u50cf\u4e0d\u5b58\u5728!");
            }
        } else {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8001\u5e08\u4e0d\u5b58\u5728");
        }
        return map;
    }
}

