/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.ViewStatus;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class OrgCourseListServiceImpl
implements OrgCourseListService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseListServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private Environment environment;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Override
    public List<CourseListReponseDto> getCourseList(List<OrgCourse> courses, Long orgId, boolean needLesson, boolean needSms, boolean needTeacher, Boolean needStudent, boolean needRoom, boolean needCover, boolean needUrl) {
        return this.getCourseList(courses, null, null, orgId, needLesson, needSms, needTeacher, needStudent, needRoom, needCover, needUrl);
    }

    private void batchUpdateColor(Set<Long> courseIds, List<OrgCourse> courses) {
        ArrayList courseList = Lists.newArrayList();
        String colorsStr = "";
        try {
            colorsStr = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] colors = null;
        if (StringUtils.isNotBlank((String)colorsStr)) {
            colors = colorsStr.split(",");
        }
        Random rd = new Random();
        for (OrgCourse orgCourse : courses) {
            if (StringUtils.isBlank((String)orgCourse.getColor())) {
                if (colors != null) {
                    orgCourse.setColor(colors[rd.nextInt(colors.length - 1)]);
                }
                courseList.add(orgCourse);
            }
            courseIds.add(orgCourse.getId());
        }
        if (colors != null) {
            this.orgCourseDao.changeCourseColor((Collection)courseList);
        }
    }

    private void getSmsCount(Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView, List<OrgCourseSms> courseSms, Map<Long, List<Long>> courseStudentMap, Map<Long, List<Long>> courseTeacherMap) {
        for (OrgCourseSms orgCourseSms : courseSms) {
            if (!studentSms.containsKey(orgCourseSms.getCourseId())) {
                studentSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherSms.containsKey(orgCourseSms.getCourseId())) {
                teacherSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!studentView.containsKey(orgCourseSms.getCourseId())) {
                studentView.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherView.containsKey(orgCourseSms.getCourseId())) {
                teacherView.put(orgCourseSms.getCourseId(), 0);
            }
            if (orgCourseSms.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
                List<Long> studentIds = courseStudentMap.get(orgCourseSms.getCourseId());
                if (studentIds == null || !studentIds.contains(orgCourseSms.getCourseId())) continue;
                if (orgCourseSms.getSend() > 0) {
                    studentSms.put(orgCourseSms.getCourseId(), studentSms.get(orgCourseSms.getCourseId()) + 1);
                }
                if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
                studentView.put(orgCourseSms.getCourseId(), studentView.get(orgCourseSms.getCourseId()) + 1);
                continue;
            }
            List<Long> teacherIds = courseTeacherMap.get(orgCourseSms.getCourseId());
            if (teacherIds == null || !teacherIds.contains(orgCourseSms.getCourseId())) continue;
            if (orgCourseSms.getSend() > 0) {
                teacherSms.put(orgCourseSms.getCourseId(), teacherSms.get(orgCourseSms.getCourseId()) + 1);
            }
            if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
            teacherView.put(orgCourseSms.getCourseId(), teacherView.get(orgCourseSms.getCourseId()) + 1);
        }
    }

    private Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection coverList = CollectorUtil.collect(courses, (Function)new Function<OrgCourse, Integer>(){

            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List storages = this.storageDao.getByIds(coverList, new String[0]);
        return CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Integer>(){

            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, (Function)new Function<Storage, String>(){

            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank((String)arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl((Long)arg0.getFid(), (String)arg0.getMimetype(), (String)arg0.getSn());
            }
        });
    }

    private void buildCourseListResponseDto(OrgCourse po, CourseListReponseDto dto) {
        dto.setOrgCourseId(po.getId());
        dto.setOrgCourseNumber(po.getOrgNumber());
        dto.setColor(po.getColor());
        dto.setCourseName(po.getName());
        dto.setMaxStudent(po.getMaxStudent());
        dto.setFreq(po.getFreq());
        dto.setStartTime(po.getBeginTime());
        dto.setEndTime(po.getEndTime());
    }

    private void buildLessonCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> arrangeMap, Map<Long, Integer> finishMap) {
        if (arrangeMap.containsKey(po.getId())) {
            dto.setLessonCount(arrangeMap.get(po.getId()));
        } else {
            dto.setLessonCount(0);
        }
        if (finishMap.containsKey(po.getId())) {
            dto.setLessonFinish(finishMap.get(po.getId()));
        } else {
            dto.setLessonFinish(0);
        }
        if (dto.getLessonCount() != null && dto.getLessonFinish() != null && dto.getLessonCount() > dto.getLessonFinish() && dto.getLessonFinish() > 0) {
            dto.setArrageStatus(ArrangeStatus.BEGIN.getCode());
        } else if (dto.getLessonCount() != null && dto.getLessonCount() > 0) {
            dto.setArrageStatus(ArrangeStatus.ARRANGEED.getCode());
        } else {
            dto.setArrageStatus(ArrangeStatus.UNARRANGE.getCode());
        }
    }

    private void buildTeacher(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> teacherMap) {
        Integer count = teacherMap.get(po.getId());
        if (count != null) {
            dto.setTeacherCount(count);
        } else {
            dto.setTeacherCount(0);
        }
    }

    private void buildStudent(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentMap) {
        Integer count = studentMap.get(po.getId());
        if (count != null) {
            dto.setStudentCount(count);
        } else {
            dto.setStudentCount(0);
        }
    }

    private void buildRoom(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> roomMap) {
        Integer count = roomMap.get(po.getId());
        if (count != null) {
            dto.setRoomCount(count);
        } else {
            dto.setRoomCount(0);
        }
    }

    private void buildSmsCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView) {
        int studentSmsCount = 0;
        int teacherSmsCount = 0;
        int studentViewCount = 0;
        int teacherViewCount = 0;
        if (studentSms.get(po.getId()) != null) {
            studentSmsCount = studentSms.get(po.getId());
        }
        if (teacherSms.get(po.getId()) != null) {
            teacherSmsCount = teacherSms.get(po.getId());
        }
        if (studentView.get(po.getId()) != null) {
            studentViewCount = studentView.get(po.getId());
        }
        if (teacherView.get(po.getId()) != null) {
            teacherViewCount = teacherView.get(po.getId());
        }
        log.debug("studentSmsCount={}, teacherSmsCount={}", (Object)studentSmsCount, (Object)teacherSmsCount);
        dto.setSmsStudent(dto.getStudentCount() - studentSmsCount);
        dto.setViewStudent(dto.getStudentCount() - studentViewCount);
        dto.setSmsTeacher(dto.getTeacherCount() - teacherSmsCount);
        dto.setViewTeacher(dto.getTeacherCount() - teacherViewCount);
    }

    @Override
    public List<CourseListReponseDto> getCourseList(@NonNull Long orgId, @NonNull Long studentId, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        List stuCourses = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, pageDto);
        if (CollectionUtils.isEmpty((Collection)stuCourses)) {
            return Collections.emptyList();
        }
        HashMap idCourseMap = Maps.newHashMap();
        for (OrgStudentCourse course : stuCourses) {
            idCourseMap.put(course.getCourseId(), course);
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        Long orgNumber = orgAccount.getNumber().longValue();
        List courses = this.orgCourseDao.getCourseList(idCourseMap.keySet(), orgNumber, null, new String[0]);
        log.debug("OrgStudentCourses = {}, courses = {}, page = {}", new Object[]{stuCourses, courses, pageDto});
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyList();
        }
        List<CourseListReponseDto> list = this.getCourseList(courses, orgId, true, false, false, false, false, true, false);
        if (CollectionUtils.isNotEmpty(list)) {
            Map lessonCountMap = this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, idCourseMap.keySet());
            log.debug("list={},lessonCountMap={}", list, (Object)lessonCountMap);
            for (CourseListReponseDto dto : list) {
                Integer lessonCount = (Integer)lessonCountMap.get(dto.getOrgCourseId());
                if (lessonCount == null) {
                    lessonCount = 0;
                }
                dto.setLessonCount(lessonCount);
                dto.setStatus(((OrgStudentCourse)idCourseMap.get(dto.getOrgCourseId())).getStatus());
            }
        }
        return list;
    }

    @Override
    public CourseListReponseDto getCourseDetail(Long orgId, Long orgCourseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((orgCourseId != null ? 1 : 0) != 0, (Object)"orgCourseId is null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(orgCourseId, new String[0]);
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (course == null || account == null || course.getOrgNumber().longValue() != account.getNumber().longValue()) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_NOT_EXIST);
        }
        Integer lessonCount = this.orgClassLessonDao.getLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Integer finishCount = this.orgClassLessonDao.getFinishLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(orgCourseId);
        dto.setOrgCourseNumber(course.getNumber());
        dto.setFreq(course.getFreq());
        dto.setLessonCount(lessonCount);
        dto.setLessonFinish(finishCount);
        return dto;
    }

    @Override
    public List<CourseListReponseDto> getCourseList(List<OrgCourse> courses, Long studentId, Long teacherId, Long orgId, boolean needLesson, boolean needSms, boolean needTeacher, Boolean needStudent, boolean needRoom, boolean needCover, boolean needUrl) {
        log.debug("needLesson={},needSms={},needTeacher={},needStudent={},needRoom={},needCover={},needUrl={}", new Object[]{needLesson, needSms, needTeacher, needStudent, needRoom, needCover, needUrl});
        ArrayList response = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(courses)) {
            HashSet courseIds = Sets.newHashSet();
            this.batchUpdateColor(courseIds, courses);
            log.debug("courseIds={}", (Object)courseIds);
            Map<Integer, String> coverMap = null;
            if (needCover) {
                coverMap = this.getCoverMap(courses);
            }
            Map arrangeMap = null;
            Map finishMap = null;
            if (needLesson) {
                arrangeMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, null);
                finishMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, new Date());
            }
            Map teacherMap = null;
            if (needTeacher) {
                teacherMap = this.orgCourseTeacherDao.getTeacherCount((Collection)courseIds);
            }
            Map studentMap = null;
            if (needStudent.booleanValue()) {
                studentMap = this.orgStudentCourseDao.getStudentCount(orgId, (Collection)courseIds);
                log.debug("studentMap = {}", (Object)studentMap);
            }
            Map roomMap = null;
            if (needRoom) {
                roomMap = this.orgCourseRoomDao.getCourseRoomCount(orgId, (Collection)courseIds);
            }
            HashMap studentSms = Maps.newHashMap();
            HashMap teacherSms = Maps.newHashMap();
            HashMap studentView = Maps.newHashMap();
            HashMap teacherView = Maps.newHashMap();
            if (needSms) {
                Map courseStudentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
                Map courseTeacherMap = this.orgCourseTeacherDao.getTeacherMap((Collection)courseIds);
                List courseSms = this.orgCourseSmsDao.getOrgCourseSmsList(orgId, (Collection)courseIds, null, new String[0]);
                this.getSmsCount(studentSms, teacherSms, studentView, teacherView, courseSms, courseStudentIdMap, courseTeacherMap);
                log.debug("student sms count ={},teacher sms count ={}", (Object)studentSms, (Object)teacherSms);
            }
            String url = this.environment.getProperty("org_class_course.url");
            for (OrgCourse course : courses) {
                CourseListReponseDto responseDto = new CourseListReponseDto();
                this.buildCourseListResponseDto(course, responseDto);
                if (needCover) {
                    responseDto.setCoverUrl(coverMap.get(course.getCover()));
                }
                if (needUrl) {
                    responseDto.setCourseUrl(url + course.getNumber());
                }
                if (needLesson) {
                    this.buildLessonCount(course, responseDto, arrangeMap, finishMap);
                }
                if (needTeacher) {
                    this.buildTeacher(course, responseDto, teacherMap);
                }
                if (needStudent.booleanValue()) {
                    this.buildStudent(course, responseDto, studentMap);
                }
                if (needRoom) {
                    this.buildRoom(course, responseDto, roomMap);
                }
                if (needSms) {
                    this.buildSmsCount(course, responseDto, studentSms, teacherSms, studentView, teacherView);
                }
                response.add(responseDto);
            }
        }
        return response;
    }
}

