/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherBranchDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherBranch;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CourseTeacherServiceImpl
implements CourseTeacherService {
    private static final Logger log = LoggerFactory.getLogger(CourseTeacherServiceImpl.class);
    public static final String ANONYMOUS_TEACHER_NAME = "\u533f\u540d\u8001\u5e08";
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgTeacherBranchDao orgTeacherBranchDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgTeacherDao orgTeacherDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;

    @Override
    public List<TeacherResponseDto> listOrgTeacher(String key, Long orgId, Long branchId, Long courseId, PageDto page) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet teacherIds = Sets.newHashSet((Iterable)this.orgTeacherDao.getTeacherIds(orgId, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())));
        List courseTeacherIds = null;
        if (branchId != null) {
            List branchTeachers = this.orgTeacherBranchDao.getBranchTeacher(orgId, branchId, null, (Collection)teacherIds, new String[]{"userId"});
            if (CollectionUtils.isEmpty((Collection)branchTeachers)) {
                return Collections.emptyList();
            }
            teacherIds.clear();
            for (OrgTeacherBranch teacherBranch : branchTeachers) {
                teacherIds.add(teacherBranch.getUserId());
            }
        }
        if (courseId != null && courseId > 0L) {
            courseTeacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
            if (CollectionUtils.isNotEmpty((Collection)teacherIds) && CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
                teacherIds.removeAll(courseTeacherIds);
            }
        }
        List teacherList = this.teacherDao.getTeachers(orgId, (Collection)teacherIds, key, null, null, page);
        if (CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
            Iterator iterator = teacherList.iterator();
            while (iterator.hasNext()) {
                Teacher teacher = (Teacher)iterator.next();
                if (!courseTeacherIds.contains(teacher.getUserId())) continue;
                iterator.remove();
            }
        }
        return this.buildDtoList(teacherList);
    }

    @Override
    public List<TeacherResponseDto> listCourseTeacher(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            List teacherList = this.teacherDao.getTeachers(orgId, (Collection)userIds, null, null, null, null);
            return this.buildDtoList(teacherList);
        }
        return Collections.emptyList();
    }

    @Override
    public void addTeacherToCourse(Long orgId, Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("add teacher ids is empty");
            return;
        }
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        for (OrgCourseTeacher t : courseTeachers) {
            teacherIds.remove(t.getUserId());
        }
        List teacherList = this.teacherDao.getByTeacherIds(teacherIds, new String[]{"userId", "orgId"});
        List saveCourseTeacher = Lists.newArrayList();
        OrgCourseTeacher po = null;
        for (Teacher teacher : teacherList) {
            if (!orgId.equals(teacher.getOrgId())) {
                log.warn("teacher id:{} is not current org teacher", (Object)teacher.getUserId());
                continue;
            }
            po = new OrgCourseTeacher();
            po.setOrgCourseId(courseId);
            po.setUserId(teacher.getUserId());
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            saveCourseTeacher.add(po);
        }
        log.info("save teachers :{} to courseId:{}", (Object)saveCourseTeacher, (Object)courseId);
        this.orgCourseTeacherDao.saveAll(saveCourseTeacher, new String[]{"orgCourseId", "userId", "createTime", "updateTime"});
    }

    @Override
    public int delTeacherFromCourse(Long orgId, Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("clear all teacher from courseId:{}", (Object)courseId);
        }
        this.orgCourseTeacherDao.delTeachersFromCourse(courseId, teacherIds);
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, courseId, Integer.valueOf(UserRole.TEACHER.getRole()), teacherIds);
        List lessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            HashMap<String, List> delCondition = new HashMap<String, List>();
            delCondition.put("lessonId", lessonIds);
            int result = this.orgTeacherLessonDao.delByCondition(delCondition);
            log.info("del from org teacher lesson by lessonId:{},result:{}", (Object)lessonIds, (Object)result);
            return result;
        }
        return 0;
    }

    @Override
    public List<TeacherResponseDto> getLessonTeacher(@NonNull Long orgId, @NonNull Long lessonId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        List userIdList = this.orgTeacherLessonDao.getUserIds(lessonId, orgId);
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return Collections.emptyList();
        }
        List teachers = this.teacherDao.getTeachers(orgId, (Collection)userIdList, null, null, null, null);
        return this.buildDtoList(teachers);
    }

    private List<TeacherResponseDto> buildDtoList(List<Teacher> teacherList) {
        if (CollectionUtils.isNotEmpty(teacherList)) {
            List result = Lists.newArrayList();
            HashSet avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherList) {
                if (teacher.getAvatar() == null || teacher.getAvatar() <= 0L) continue;
                avatarIds.add(teacher.getAvatar());
            }
            List storageList = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
            Map<Long, String> avatarMap = this.getAvatarMap(storageList);
            for (Teacher teacher : teacherList) {
                TeacherResponseDto dto = this.buildDto(teacher, false);
                dto.setAvatar(avatarMap.get(teacher.getAvatar()));
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private TeacherResponseDto buildDto(Teacher teacher, boolean needAvatar) {
        TeacherResponseDto dto = new TeacherResponseDto();
        if (needAvatar && teacher.getAvatar() != null) {
            Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
            dto.setAvatar(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        dto.setTeacherId(teacher.getUserId());
        dto.setTeacherName(this.getTeacherName(teacher));
        dto.setMobile(teacher.getMobile());
        return dto;
    }

    private String getTeacherName(Teacher teacher) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getRealName()})) {
            return teacher.getRealName();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getNickName()})) {
            return teacher.getNickName();
        }
        return ANONYMOUS_TEACHER_NAME;
    }

    private Map<Long, String> getAvatarMap(List<Storage> storageList) {
        if (CollectionUtils.isNotEmpty(storageList)) {
            Map result = Maps.newHashMap();
            for (Storage storage : storageList) {
                result.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<TeacherResponseDto> getTeachers(Collection<Long> teacherIds, Long orgId) {
        List teacherList = this.teacherDao.getTeachers(orgId, teacherIds, null, null, null, null);
        return this.buildDtoList(teacherList);
    }

    @Override
    public TeacherResponseDto getTeacher(Long teacherId, Long orgId) {
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        return this.buildDto(teacher, true);
    }

    @Override
    public void addTeacherToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("add teacher ids is empty");
            return;
        }
        List courseTeacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
        if (CollectionUtils.isNotEmpty(teacherIds) && !courseTeacherIds.containsAll(teacherIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", teacherIds, (Object)courseTeacherIds);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u8001\u5e08\u4e2d\u9009\u62e9\u8bfe\u8282\u8001\u5e08");
        }
        List saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long teacherId : teacherIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", (Object)saveLessonTeachers, (Object)lessonId);
        this.orgTeacherLessonDao.saveAll(saveLessonTeachers, new String[]{"createTime", "lessonId", "orgId", "teacherId"});
    }

    @Override
    public int delTeacherFromLesson(Long orgId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"startTime", "endTime"});
        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", (Object)lessonId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        Map condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            condition.put("teacherId", teacherIds);
        }
        return this.orgTeacherLessonDao.delByCondition(condition);
    }

    @Override
    public void resetLessonTeacher(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        this.delTeacherFromLesson(orgId, lessonId, null);
        this.addTeacherToLesson(orgId, courseId, lessonId, teacherIds);
    }
}

