/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.consult.service;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;



/**   
 * @title       : ConsultSourceService 
 * @description : 线索来源
 * @author      : zhenyujian
 * @date        : 2016年7月23日 下午5:26:46 
 */
public interface ConsultSourceService {

	List<ConsultCustomSourceDto> listConsultSystemSource(Boolean selection);
	
	String getConsultSourceStr(Long sourceId);
	
	Map<Long,ConsultCustomSourceDto> mapConsultSourceDto(Long orgId, Boolean selection);
	
	ConsultCustomSourceDto getByLabel(Long orgId, String label);
	
	/**
     * @Description  : scope      0-自定义的选项 1-返回系统内置的选项 其它- 返回全部
     *                 isPaused   0- 启用中的选项 1-停用的选项 其它- 返回全部
     * @Author       : zhenyujian
     * @Date         : 2016年8月6日 下午4:36:29 
     *
     * @Return       : List<ConsultCustomSourceDto>
     */
    List<ConsultCustomSourceDto> selection(Long orgId, TXSaleClueRule txSaleClueRule, Integer scope, Integer isPaused);
	
	boolean isSystemSource(Long sourceId);
	
}

