/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.consult.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;

import lombok.extern.slf4j.Slf4j;

/**
 * @title : ConsultCustomSourceServiceImpl
 * @description :
 * @author : zhenyujian
 * @date : 2016年7月26日 上午12:09:22
 */
@Slf4j
@Service
public class ConsultSourceServiceImpl implements ConsultSourceService {

    @Autowired
    private ConsultCustomSourceDao customSourceDao;

    @Override
    public List<ConsultCustomSourceDto> listConsultSystemSource(Boolean selection) {
        List<MessageSource> list = MessageSource.listConsultSource(selection);

        List<ConsultCustomSourceDto> result = new ArrayList<ConsultCustomSourceDto>();
        ConsultCustomSourceDto dto = null;
        for (MessageSource source : list) {
            dto = new ConsultCustomSourceDto();
            dto.setId(Long.parseLong(source.getValue() + ""));
            dto.setIsPaused(Flag.FALSE.getInt());
            dto.setLabel(source.getDesc());
            dto.setSystemId(source.getValue());
            result.add(dto);
        }
        return result;
    }

    /*
     * 线索来源 - 获取名称
     */
    @Transactional(readOnly = true)
    @Override
    public String getConsultSourceStr(Long sourceId) {
        String str = null;
        MessageSource source = MessageSource.getByType(sourceId.intValue());
        if (source != null && source.isConsultSource()) {
            str = source.getDesc();
        } else {
            ConsultCustomSource csource = customSourceDao.getById(sourceId);
            if (csource != null) {
                str = csource.getLabel();
            }
        }
        return str;
    }

    @Transactional(readOnly = true)
    @Override
    public Map<Long, ConsultCustomSourceDto> mapConsultSourceDto(Long orgId, Boolean selection) {
        Map<Long, ConsultCustomSourceDto> map = new HashMap<Long, ConsultCustomSourceDto>();

        List<ConsultCustomSource> customSourcelist = customSourceDao.list(orgId, null);
        List<ConsultCustomSourceDto> systemSourcelist = listConsultSystemSource(selection);

        if (CollectionUtils.isNotEmpty(customSourcelist)) {
            for (ConsultCustomSource source : customSourcelist) {
                map.put(source.getId(), ConsultCustomSourceDto.buildBy(source));
            }
        }

        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                map.put(dto.getId(), dto);
            }
        }

        return map;
    }

    @Transactional(readOnly = true)
    @Override
    public ConsultCustomSourceDto getByLabel(Long orgId, String label) {
        List<ConsultCustomSourceDto> systemSourcelist = listConsultSystemSource(null);

        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                if (dto.getLabel().equals(label)) {
                    return dto;
                }
            }
        }

        List<ConsultCustomSource> customSourcelist = customSourceDao.list(orgId, null);
        if (CollectionUtils.isNotEmpty(customSourcelist)) {
            for (ConsultCustomSource source : customSourcelist) {
                if (source.getLabel().equals(label)) {
                    return ConsultCustomSourceDto.buildBy(source);
                }
            }
        }

        return null;
    }

    @Override
    public boolean isSystemSource(Long sourceId) {
        if (sourceId != null) {
            MessageSource source = MessageSource.getByType(sourceId.intValue());
            if (source != null && source.isConsultSource()) {
                return true;
            }
        }
        return false;
    }

    public List<ConsultCustomSourceDto> selection(Long orgId, TXSaleClueRule rule, Integer scope, Integer isPaused) {
        List<ConsultCustomSourceDto> dtos = new ArrayList<ConsultCustomSourceDto>();

        if (isPaused != null && !isPaused.equals(Flag.TRUE.getInt()) && !isPaused.equals(Flag.FALSE.getInt())) {
            isPaused = null;
        }

        // 查询 (scope 请看接口文档吧吧吧吧。。)
        if (scope != null && scope == 0) {
            dtos.addAll(this.listConsultSystemSource(true));

        } else if (scope != null && scope == 1) {
            List<ConsultCustomSource> list = customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy(ccSource));
            }

        } else {
            List<ConsultCustomSource> list = customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy(ccSource));
            }

            dtos.addAll(this.listConsultSystemSource(true));
        }

        // 排序
        if (CollectionUtils.isNotEmpty(dtos)) {
            Map<Long, ConsultCustomSourceDto> dtosMap = new LinkedHashMap<Long, ConsultCustomSourceDto>();
            for (ConsultCustomSourceDto dto : dtos) {
                dtosMap.put(dto.getId(), dto);
            }

            String sort = rule.getConsultSourceSort();
            if (StringUtils.isNotBlank(sort)) {
                int i = 1;
                Long sourceId = null;
                ConsultCustomSourceDto dto = null;
                for (String s : sort.split(TXSaleClueRule.CONSULT_SOURCE_SORT_SPLIT)) {
                    sourceId = Long.parseLong(s);
                    dto = dtosMap.get(sourceId.longValue());
                    if (dto != null && !Flag.getBoolean(dto.getIsPaused())) {
                        dto.setSort(i);
                        i++;
                    }
                }
            }

            // 排序
            sortConsultCustomSource(dtos);
        }

        return dtos;
    }

    // 线索来源列表排序
    void sortConsultCustomSource(List<ConsultCustomSourceDto> dtos) {

        for (ConsultCustomSourceDto dto : dtos) {
            if (dto.getSort() == null) {
                dto.setSort(Flag.NULL.getInt());
            }
        }

        Comparator<ConsultCustomSourceDto> comparator = new Comparator<ConsultCustomSourceDto>() {
            @Override
            public int compare(ConsultCustomSourceDto o1, ConsultCustomSourceDto o2) {
                if (Flag.getBoolean(o1.getIsPaused()) && Flag.getBoolean(o2.getIsPaused())) {// 冻结vs冻结
                    if (o1.getUpdateTime().getTime() > o2.getUpdateTime().getTime()) {
                        return 1;
                    } else {
                        return -1;
                    }

                } else if (Flag.getBoolean(o1.getIsPaused())) {
                    return 1;

                } else if (Flag.getBoolean(o2.getIsPaused())) {
                    return -1;

                } else {
                    if (o1.getSort() != null && o2.getSort() != null) {
                        if (o1.getSort().equals(o2.getSort())) {
                            return o1.getId().longValue() > o2.getId().longValue() ? -1 : 1;
                        }
                        return o1.getSort().intValue() > o2.getSort().intValue() ? 1 : -1;
                    } else if (o1.getSort() != null) {
                        return 1;

                    } else if (o2.getSort() != null) {
                        return -1;

                    } else {
                        return o1.getId().longValue() > o2.getId().longValue() ? -1 : 1;
                    }

                }
            }

        };
        Collections.sort(dtos, comparator);
    }

}
