/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.consult.service.impl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;

import lombok.extern.slf4j.Slf4j;

/**   
 * @title       : ConsultCustomSourceServiceImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年7月26日 上午12:09:22 
 */
@Slf4j
@Service
public class ConsultSourceServiceImpl implements ConsultSourceService {
	
	@Autowired
	private ConsultCustomSourceDao customSourceDao;
	
	
	
	@Override
	public List<ConsultCustomSourceDto> listConsultSystemSource(Boolean selection) {
		List<MessageSource> list = MessageSource.listConsultSource(selection);	
		
		List<ConsultCustomSourceDto> result = new ArrayList<ConsultCustomSourceDto>();
		ConsultCustomSourceDto dto = null;
		for(MessageSource source : list){
			dto = new ConsultCustomSourceDto();
			dto.setId( Long.parseLong(source.getValue()+"") );
			dto.setIsPaused( Flag.FALSE.getInt() );
			dto.setLabel( source.getDesc() );
			dto.setSystemId( source.getValue() );
			result.add(dto);
		}
		return result;
	}
	
	
	
	/*
	 *  线索来源 - 获取名称 
	 */
	@Transactional(readOnly=true)
	@Override
	public String getConsultSourceStr(Long sourceId) {
		String str = null;
		MessageSource source = MessageSource.getByType(sourceId.intValue());
		if(source.isConsultSource()){
			str = source.getDesc();
		}else{
			ConsultCustomSource csource = customSourceDao.getById(sourceId);
			if(csource!=null){
				str = csource.getLabel();
			}
		}
		return str;
	}

	

	@Transactional(readOnly=true)
	@Override
	public Map<Long, ConsultCustomSourceDto> mapConsultSourceDto(Long orgId, Boolean selection) {
		Map<Long,ConsultCustomSourceDto> map = new HashMap<Long,ConsultCustomSourceDto>();
		
		List<ConsultCustomSource> customSourcelist = customSourceDao.list(orgId, null);
		List<ConsultCustomSourceDto> systemSourcelist = listConsultSystemSource(selection);
		
		if(CollectionUtils.isNotEmpty(customSourcelist)){
			for(ConsultCustomSource source:customSourcelist){
				map.put(source.getId(), ConsultCustomSourceDto.buildBy(source));
			}
		}
		
		if(CollectionUtils.isNotEmpty(systemSourcelist)){
			for(ConsultCustomSourceDto dto:systemSourcelist){
				map.put(dto.getId(), dto);
			}
		}
		
		return map;
	}


	
	@Transactional(readOnly=true)
	@Override
	public ConsultCustomSourceDto getByLabel(Long orgId, String label) {
		List<ConsultCustomSourceDto> systemSourcelist = listConsultSystemSource(null);
		
		if(CollectionUtils.isNotEmpty(systemSourcelist)){
			for(ConsultCustomSourceDto dto : systemSourcelist){
				if(dto.getLabel().equals(label)){
					return dto;
				}
			}
		}
		
		List<ConsultCustomSource> customSourcelist = customSourceDao.list(orgId, null);
		if(CollectionUtils.isNotEmpty(customSourcelist)){
			for(ConsultCustomSource source:customSourcelist){
				if(source.getLabel().equals(label)){
					return ConsultCustomSourceDto.buildBy(source);
				}
			}
		}
		
		return null;
	}



	@Override
	public boolean isSystemSource(Long sourceId) {
		if(sourceId!=null){
			MessageSource source = MessageSource.getByType(sourceId.intValue());
			if(source!=null && source.isConsultSource()){
				return true;
			}
		}
		return false;
	}
	
}
