/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.consult.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultSourceServiceImpl
implements ConsultSourceService {
    private static final Logger log = LoggerFactory.getLogger(ConsultSourceServiceImpl.class);
    @Autowired
    private ConsultCustomSourceDao customSourceDao;

    @Override
    public List<ConsultCustomSourceDto> listConsultSystemSource(Boolean selection) {
        List list = MessageSource.listConsultSource((Boolean)selection);
        ArrayList<ConsultCustomSourceDto> result = new ArrayList<ConsultCustomSourceDto>();
        ConsultCustomSourceDto dto = null;
        for (MessageSource source : list) {
            dto = new ConsultCustomSourceDto();
            dto.setId(Long.parseLong(source.getValue() + ""));
            dto.setIsPaused(Flag.FALSE.getInt());
            dto.setLabel(source.getDesc());
            dto.setSystemId(source.getValue());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public String getConsultSourceStr(Long sourceId) {
        String str = null;
        MessageSource source = MessageSource.getByType((Integer)sourceId.intValue());
        if (source.isConsultSource()) {
            str = source.getDesc();
        } else {
            ConsultCustomSource csource = (ConsultCustomSource)this.customSourceDao.getById((Serializable)sourceId, new String[0]);
            if (csource != null) {
                str = csource.getLabel();
            }
        }
        return str;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, ConsultCustomSourceDto> mapConsultSourceDto(Long orgId, Boolean selection) {
        HashMap<Long, ConsultCustomSourceDto> map = new HashMap<Long, ConsultCustomSourceDto>();
        List customSourcelist = this.customSourceDao.list(orgId, null);
        List<ConsultCustomSourceDto> systemSourcelist = this.listConsultSystemSource(selection);
        if (CollectionUtils.isNotEmpty((Collection)customSourcelist)) {
            for (ConsultCustomSource source : customSourcelist) {
                map.put(source.getId(), ConsultCustomSourceDto.buildBy(source));
            }
        }
        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                map.put(dto.getId(), dto);
            }
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public ConsultCustomSourceDto getByLabel(Long orgId, String label) {
        List customSourcelist;
        List<ConsultCustomSourceDto> systemSourcelist = this.listConsultSystemSource(null);
        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                if (!dto.getLabel().equals(label)) continue;
                return dto;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(customSourcelist = this.customSourceDao.list(orgId, null)))) {
            for (ConsultCustomSource source : customSourcelist) {
                if (!source.getLabel().equals(label)) continue;
                return ConsultCustomSourceDto.buildBy(source);
            }
        }
        return null;
    }

    @Override
    public boolean isSystemSource(Long sourceId) {
        MessageSource source;
        return sourceId != null && (source = MessageSource.getByType((Integer)sourceId.intValue())) != null && source.isConsultSource();
    }
}

