/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.common.api;

import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;


public interface TXStudentCommentAPIService {

	TxStudentComment saveTxStudentComment(TxStudentComment comment);
	
	
	//活动报名、抽奖
	TxStudentComment saveByOrgActivitySignUp(TxConsultUser consultUser, String activityName, String userName, String mobile, String award);
	
	//400电话
	TxStudentComment saveByOrgCall400(TxConsultUser consultUser, OrgPushCallInfo callInfo, boolean isNewConsultUser);
	
	//预约留单
	TxStudentComment saveByAdvisory(TxConsultUser consultUser, Long userId, String advisoryWords , boolean isNewConsultUser);
	
	//线索 - 手动添加
	TxStudentComment saveByConsultUserManualAdd(TxConsultUser consultUser);
	
	//线索 - 分配
	TxStudentComment saveByConsultUserAssign(TxConsultUser consultUser, String ownerName);
	
	//线索 - 领取
	TxStudentComment saveByConsultUserPull(TxConsultUser consultUser, String operatorName);
	
	//线索 - 释放
	TxStudentComment saveByConsultUserPush(TxConsultUser consultUser, String operatorName);
	
	//线索 - 自动释放
	void batchSaveByRelease(List<Long> consulterIds);
	
	//线索 - 置为有效、无效
	TxStudentComment saveByConsultUserChangeStatus(TxConsultUser consultUser, String operatorName, String reason);
	
	//线索 - 转交
	TxStudentComment saveByConsultUserPassTo(TxConsultUser consultUser, String from, String to);
	
	//线索 - 手机号修改
	TxStudentComment saveByMobileChange(TxConsultUser consultUser, String oldMobile, String newMobile);
	
	//线索 - 名称修改
	TxStudentComment saveByNameChange(TxConsultUser consultUser, String oldName, String newName);
	
	//学员合并
	TxStudentComment saveByStudentMerge(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId);
	
	//报名订单
	TxStudentComment saveBySignUpPurchase(OrgSignupInfo orgSignupInfo, String courseNames);
	
	//报班订单
	TxStudentComment saveByCoursePurchase(Long orgId, Long userId, Date createTime, String courseName, Double price);
	
	//添加学生
	TxStudentComment saveByAddStudent(OrgStudent student);

	//学员转交
	public TxStudentComment saveByStudentPassTo(OrgStudent student, String from, String to);
}

