/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentApiServiceImpl
implements OrgStudentApiService {
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public Map<Long, String> batchGetStudentAvatarUrl(Collection<OrgStudent> students) {
        if (students == null || students.size() < 1) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        HashMap<Long, OrgStorage> orgStorageMap = new HashMap();
        HashMap<String, Fans> fansMap = new HashMap();
        HashSet<Long> orgAvatarIds = new HashSet<Long>();
        ArrayList<String> openIds = new ArrayList<String>();
        for (OrgStudent orgStudent : students) {
            Long avatarId = orgStudent.getAvatar();
            String openId = orgStudent.getWeixin();
            if (openId != null && !openId.equals("") && !openId.equals("0")) {
                openIds.add(openId);
            }
            if (!GenericsUtils.notNullAndEmpty((Object)avatarId)) continue;
            orgAvatarIds.add(avatarId);
        }
        if (GenericsUtils.notNullAndEmpty(orgAvatarIds)) {
            orgStorageMap = this.orgStorageDao.getOrgStorageMapByIds(orgAvatarIds);
        }
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }
        for (OrgStudent orgStudent : students) {
            String avatar = this.buildAvatarUrl(orgStudent, orgStorageMap, fansMap);
            map.put(orgStudent.getId(), avatar);
        }
        return map;
    }

    private String buildAvatarUrl(OrgStudent orgStudent, Map<Long, OrgStorage> orgStorageMap, Map<String, Fans> fansMap) {
        Fans fan;
        String avatarUrl = null;
        Long avatarId = orgStudent.getAvatar();
        OrgStorage orgStorage = orgStorageMap.get(avatarId);
        if (GenericsUtils.notNullAndEmpty((Object)orgStorage)) {
            avatarUrl = StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType());
        }
        String openId = orgStudent.getWeixin();
        if (GenericsUtils.isNullOrEmpty(avatarUrl) && GenericsUtils.notNullAndEmpty((Object)openId) && GenericsUtils.notNullAndEmpty((Object)(fan = fansMap.get(openId)))) {
            avatarUrl = fan.getHeadImgUrl();
        }
        if (GenericsUtils.isNullOrEmpty((Object)avatarUrl)) {
            avatarUrl = AvatarUtil.getUserAvatar((long)orgStudent.getId());
        }
        return avatarUrl;
    }
}

