/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonMsgServiceImpl
implements CommonMsgService {
    private static final Logger log = LoggerFactory.getLogger(CommonMsgServiceImpl.class);
    @Autowired(required=false)
    private WechatMsgRenderService wechatMsgSenderService;
    @Resource
    private TxSmsDao txSmsDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    final ExecutorService exec = Executors.newFixedThreadPool(5);

    @Override
    public boolean sendMsg(final SendMsgRequest request) throws MsgSendException {
        log.info("try to send msg by request1:{}", (Object)request);
        Preconditions.checkNotNull((Object)((Object)request));
        Preconditions.checkArgument((request.getSenderId() != null ? 1 : 0) != 0, (Object)"sender id is null");
        Preconditions.checkArgument((request.getReceiverId() != null ? 1 : 0) != 0, (Object)"receiver id is null");
        Preconditions.checkArgument((request.getOrgId() != null ? 1 : 0) != 0, (Object)"orgId id is null");
        Preconditions.checkArgument((request.getSenderRole() != null ? 1 : 0) != 0, (Object)"senderRole id is null");
        Preconditions.checkArgument((request.getReceiverRole() != null ? 1 : 0) != 0, (Object)"receiverRole id is null");
        boolean sendResult = false;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getWeixinOpenId()}) && request.getWechatTemplateId() != null) {
            log.info("try to send msg by wechat:{}", request.getWechatParams());
            try {
                request.getWechatParams().put("touser", request.getWeixinOpenId());
                Callable<Boolean> call = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return CommonMsgServiceImpl.this.wechatMsgSenderService.sendMsg(request.getOrgId(), CommonMsgServiceImpl.this.wechatMsgSenderService.render(request.getWechatTemplateId(), request.getWechatParams()));
                    }
                };
                Future<Boolean> future = this.exec.submit(call);
                sendResult = future.get(20000L, TimeUnit.MILLISECONDS);
                log.info("send msg result:{} by wechat:{}", (Object)sendResult, request.getWechatParams());
                if (sendResult) {
                    return true;
                }
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
                log.warn("send by wechat catch error,receiver id is:{},error is:{} ", (Object)request.getReceiverId(), (Object)e);
            }
        }
        if (!sendResult && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getSmsContent()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getMobile()})) {
            log.info("try to send msg by sms requet={},mobile:{},content:{}", new Object[]{request, request.getMobile(), request.getSmsContent()});
            sendResult = this.sendTxSms(request.getSenderId(), request.getSenderId(), request.getSenderRole().getCode(), request.getReceiverId(), request.getReceiverRole().getCode(), request.getSmsCodeType(), request.getSendSmsKey(), request.getMobile(), request.getSmsContent());
            log.info("send sms msg receiver id is:{},result:{}", (Object)request.getReceiverId(), (Object)sendResult);
        }
        return sendResult;
    }

    @Override
    public boolean sendTxSms(Long orgId, Long sender, Integer senderRole, Long receiver, Integer receiverRole, TxSmsCodeType smsCodeType, Long sendSmsKey, String mobile, String smsContent) {
        if (!ParamValidateUtils.validateMobile((String)mobile) || StringUtils.isBlank((CharSequence)smsContent)) {
            log.warn("send sms error,mobile:{},content:{}", (Object)mobile, (Object)smsContent);
            return false;
        }
        sender = sender == null ? 0L : sender;
        senderRole = senderRole == null ? 0 : senderRole;
        receiver = receiver == null ? 0L : receiver;
        receiverRole = receiverRole == null ? 0 : receiverRole;
        TxSms sms = new TxSms();
        sms.setOrgId(orgId);
        sms.setCreateTime(new Date());
        sms.setMessageType(Integer.valueOf(SmsMessageType.TIANXIAO_NOTIFY.getCode()));
        sms.setMobile(mobile);
        sms.setReceiverId(receiver);
        sms.setReceiverRole(receiverRole);
        sms.setSenderId(sender);
        sms.setSenderRole(senderRole);
        sms.setContent(smsContent);
        sms.setSmsCode(smsCodeType.getCode());
        sms.setSendSmsKey(Long.valueOf(sendSmsKey == null ? 0L : sendSmsKey));
        sms.setSmsCount(Integer.valueOf(SmsContentHelper.countChargeSmsNum((String)smsContent, (String)SmsContentHelper.DEFAULT_SMS_SIGN_CONTENT)));
        boolean sendResult = false;
        try {
            sendResult = SmsSendUtil.sendTxSms((String)mobile, (String)smsContent, (Integer)sender.intValue(), (Integer)UserRole.ORGANIZATION.getRole(), (Integer)this.getTxAccountSmsGate(sender.intValue()));
            sms.setSendResult(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue());
            this.txSmsDao.save((Object)sms, new String[0]);
            return sendResult;
        }
        catch (Exception e) {
            log.warn("save sms record catch error:", (Throwable)e);
            return false;
        }
    }

    private TXAccount getTXAccountByOrgId(Integer orgId) {
        OrgSubAccount subAcc = this.orgSubAccountDao.getByOrgId(orgId, new String[0]);
        if (subAcc == null) {
            return null;
        }
        TXAccount superAcc = null;
        superAcc = 0 == subAcc.getPid() ? this.txAccountDao.getByOrgId(orgId, Integer.valueOf(TXAccountStatus.VALID.getCode()), new String[0]) : this.txAccountDao.getByOrgId(subAcc.getPid(), Integer.valueOf(TXAccountStatus.VALID.getCode()), new String[0]);
        return superAcc;
    }

    private Integer getTxAccountSmsGate(Integer orgId) {
        TXAccount txAccount = this.getTXAccountByOrgId((int)orgId);
        if (txAccount == null) {
            return SmsSendUtil.DEFAULT_SMS_GATE;
        }
        return txAccount.getSmsGate();
    }
}

