package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/12/28.
 */
@Service
@Slf4j
public class StudentCourseApiImpl implements StudentCourseApi {

    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgStudentLessonDao lessonDao;
    @Autowired
    private OrgStudentKexiaoRecordDao kexiaoRecordDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;

    @Override
    public Map<Long, StudentCourseBase> getBuyData(List<Long> userIds, Long courseId, Long orgId) {
        if(userIds==null || userIds.size()<1){
            return Collections.EMPTY_MAP;
        }
        List<OrgStudentCourse> courses = studentCourseDao.getByCourseIdsStudentId(orgId, Arrays.asList(courseId), userIds, null, DeleteStatus.NORMAL.getValue());
        //List<OrgSignupCourse> courses = signupCourseDao.searchByUserIdsAndClassId(userIds, courseId, orgId, SignupCourseStatus.inClassStatus);
        Map<Long, StudentCourseBase> retMap = new HashMap<>();
        for (OrgStudentCourse course : courses) {
            StudentCourseBase base = new StudentCourseBase();
            ChargeUnit unit = ChargeUnit.getByCode(course.getChargeUnit());
            base.setChargeUnit(unit);
            if(ChargeUnit.isByTime(course.getChargeUnit())){
                base.setBuyTime(course.getLessonCount());
            } else {
                base.setBuyCount(course.getLessonCount());

            }
            retMap.put(course.getUserId(), base);
        }
        return retMap;
    }

    private int getDuration(int lessonCount, ChargeUnit unit) {
        switch (unit) {
            case BY_HOUR:
                return lessonCount * 60;
            case BY_HALF_HOUR:
                return lessonCount * 30;
            case BY_MINUTE:
                return lessonCount;
            default:
                return 0;
        }
    }

    @Override
    public Map<Long, StudentCourseBase> getLessonData(List<Long> userIds, Long classId, Long orgId) {
        if(userIds==null || userIds.size()<1){
            return Collections.EMPTY_MAP;
        }
        OrgCourse course = courseDao.getByCourseId(classId, "id", "chargeUnit");
        List<OrgStudentLesson> lessons = lessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(classId), userIds,"userId","id","lessonDuration","lessonType");
        Map<Long, StudentCourseBase> retMap = new HashMap<>();
        for (OrgStudentLesson lesson : lessons) {
            StudentCourseBase base = retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(),base);
            }
            base.setLessonCount(base.getLessonCount() + 1);
            base.setLessonTime(base.getLessonTime() + lesson.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode(course.getChargeUnit()));
        }
        return retMap;
    }

    @Override
    public Map<Long, StudentCourseBase> getNormalData(List<Long> userIds, Long classId, Long orgId) {
        Map<Long, OrgSignupCourseLesson> normalLesson = signupCourseLessonDao.selectLessonInfoByClassId(orgId, classId, userIds, LessonType.NORMAL.getCode());
        Map<Long, StudentCourseBase> retMap = new HashMap<>();
        setNormalLesson(retMap,normalLesson);
        return retMap;
    }

    private void setNormalLesson(Map<Long, StudentCourseBase> studentCourseMap,Map<Long, OrgSignupCourseLesson> normalLessons){
        for (OrgSignupCourseLesson lesson : normalLessons.values()) {
            StudentCourseBase base = studentCourseMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                studentCourseMap.put(lesson.getUserId(),base);
            }
            base.setLessonNormalCount(base.getLessonNormalCount() + lesson.getLessonCount());
            base.setLessonNormalTime(base.getLessonNormalTime() + lesson.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode(lesson.getChargeUnit()));
        }
    }

    @Override
    public Map<Long, StudentCourseBase> getFinishData(List<Long> userIds, Long classId, Long orgId) {
        if(userIds==null || userIds.size()<1){
            return Collections.EMPTY_MAP;
        }
        List<OrgStudentKexiaoRecord> records =
            kexiaoRecordDao.getByCourseIdsAndUserIds(orgId, Arrays.asList(classId), userIds,"userId","id","lessonDuration","chargeUnit","lessonType");
        Map<Long, StudentCourseBase> retMap = new HashMap<>();
        for (OrgStudentKexiaoRecord record : records) {
            StudentCourseBase base = retMap.get(record.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(record.getUserId(),base);
            }
            base.setFinishCount(base.getFinishTime() + 1);
            base.setFinishTime(base.getFinishCount() + record.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode(record.getChargeUnit()));
        }
        return retMap;
    }

    @Override
    public Map<Long, StudentCourseBase> getAllData(List<Long> userIds, Long classId, Long orgId) {
        if(userIds==null || userIds.size()<1){
            return Collections.EMPTY_MAP;
        }
        List<OrgStudentLesson> lessons = lessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(classId), userIds, "userId", "id", "lessonDuration","kexiaoStatus");
        //List<OrgStudentKexiaoRecord> records = kexiaoRecordDao.getByCourseIdsAndUserIds(orgId, Arrays.asList(classId), userIds, "userId", "id", "lessonDuration", "chargeUnit");
        Map<Long, OrgSignupCourseLesson> normalLesson = signupCourseLessonDao.selectLessonInfoByClassId(orgId, classId, userIds, LessonType.NORMAL.getCode());
        OrgCourse orgCourse = courseDao.getById(classId, "isClass", "isCourse","parentId","chargeUnit");
        Map<Long, StudentCourseBase> retMap = getBuyData(userIds, classId, orgId);

        for (OrgStudentLesson lesson : lessons) {
            StudentCourseBase base = retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(),base);
            }
            base.setLessonCount(base.getLessonCount() + 1);
            base.setLessonTime(base.getLessonTime() + lesson.getLessonDuration());
            if(lesson.getKexiaoStatus()==1){
                base.setFinishCount(base.getFinishCount() + 1);
                base.setFinishTime(base.getFinishTime() + lesson.getLessonDuration());
            }
            base.setChargeUnit(ChargeUnit.getByCode(orgCourse.getChargeUnit()));
        }

        setNormalLesson(retMap,normalLesson);
        return retMap;
    }
}
