package com.baijia.tianxiao.sal.common.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.common.dto.PointsExchangeRecordDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Properties;

/**
 * Created by wengshengli on 2017/8/24.
 */
@Service
@Slf4j
public class PointsMsgServiceImpl implements PointsMsgService, InitializingBean {

    private CloudQueue pointMsgQueue;

    @Autowired
    private OrgStudentDao orgStudentDao;


    @Override
    public void pointsMessage(ProducePointType producePointType, Long keyId, Long orgId, Long userId, Long money, Integer pointsType) {
        OrgStudent orgStudent = orgStudentDao.getStudent(orgId, userId, DataStatus.NORMAL.getValue());
        if (orgStudent != null) {
            PointsExchangeRecordDto object = new PointsExchangeRecordDto();
            object.setUniqRemark(producePointType.getTableName() + "_" + keyId);
            object.setOrgId(orgId);
            object.setStudentId(orgStudent.getId());
            object.setStudentName(orgStudent.getName());
            object.setMobile(orgStudent.getMobile());
            object.setMoney(money.doubleValue() / 100);
            object.setPointsType(pointsType);
            object.setRemark(producePointType.getLabel());
            try {
                Message message = pointMsgQueue.putMessage(new Message(JacksonUtil.obj2Str(object)));
                log.info("potint message result = {},{}", message, JacksonUtil.obj2Str(object));
            } catch (Exception e) {
                log.warn("point message error ={}", e.getMessage());
            }
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties("mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"),
                    mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            pointMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("points.msg.queue"));
        } catch (Exception e) {
            log.warn("init cloud account :" + e);
        }
    }
}
