package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.*;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by lxp on 2017/2/22.
 */
@Service
@Slf4j
public class KexiaoApiServiceImpl implements KexiaoApiService {

    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgSignupRefundDao refundDao;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private TxTransferClassRecordDao transferClassRecordDao;
    @Autowired
    private TxTransferClassInfoDao transferClassInfoDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentcourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    private static final Date SUPPORT_TIME = DateUtil.getStrToDate("yyyy-MM-dd mm:HH:ss", "2017-06-01 00:00:00");

    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        // 1，签到；2，请假；3，旷课
        if (sign.getStatus() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        } else {
            return LessonStatus.UN_START;
        }
    }

    @Override
    public String getLeftAmountStr(KexiaoStatistics stat) {
        String remainTuition = "0.00";
        if (stat != null) {
            if (stat.getCompleteStatus() != 0) {
                remainTuition = "--";
            } else {
                remainTuition = NumberUtil.convertFenToYuan(stat.getLeftAmount());
            }
        }
        return remainTuition;
    }

    @Override
    public void setStudentLessonKexiaoStatus(Collection<OrgStudentLesson> studentLessons) {
        Set<Long> classIds = new HashSet<>();
        for (OrgStudentLesson lesson : studentLessons) {
            classIds.add(lesson.getCourseId());
        }
        Set<OrgStudentLesson> signKexiaoLessons = new HashSet<>();
        Set<OrgStudentLesson> timeKexiaoLessons = new HashSet<>();
        Map<Long, OrgCourseConsumeRule> consumeRuleMap = courseApiService.getClassRule(classIds);
        for (OrgStudentLesson lesson : studentLessons) {
            OrgCourseConsumeRule rule = consumeRuleMap.get(lesson.getCourseId());
            if (rule == null || rule.getRuleValue() == 0) {
                timeKexiaoLessons.add(lesson);
            } else {
                signKexiaoLessons.add(lesson);
            }
        }
        //// TODO: 2017/4/27
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED;
    }

    public KexiaoApiServiceImpl() {
    }

    @Override
    public Map<Long, KexiaoStudentStat> queryUserKexiaoStat(Long orgId, Collection<Long> userIds){
        Map<Long, KexiaoStudentStat> ret = new HashMap<>();

        if(userIds!=null && userIds.size()>0){
            int start = 0;
            List<Long> userIdList = new ArrayList<>(userIds);
            while (start<userIdList.size()){
                int end = Math.min(userIdList.size(),start+500);//每次500条数据
                ret.putAll(queryUserKexiaoByUserIds(orgId,userIdList.subList(start,end)));
                start = start+500;
            }
        }
        return ret;
    }

    private Map<Long, KexiaoStudentStat> queryUserKexiaoByUserIds(Long orgId, Collection<Long> userIds) {
        Map<Long, KexiaoStudentStat> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }

        List<OrgStudentCourse> studentCourseList = studentcourseDao.listByUserIds(orgId,userIds,null);

        //1.总金额:报名记录
        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, SignupCourseStatus.PAY_SUCCESS);
        if(signupCourseList==null || signupCourseList.isEmpty()){
            signupCourseList = new ArrayList<>();
        }

        Set<String> userCourseSet = new HashSet<>();
        for (OrgSignupCourse signupCourse:signupCourseList){
            userCourseSet.add(signupCourse.getUserId()+"_"+signupCourse.getClassId());
        }
        for (OrgStudentCourse studentCourse:studentCourseList){
            //有进班记录但没有订单,只有历史班级已退班的可能出现这种情况
            int index = 0;
            if(!userCourseSet.contains(studentCourse.getUserId()+"_"+studentCourse.getCourseId())){
                if(studentCourse.getStatus()!=0){
                    OrgSignupCourse signupCourse = new OrgSignupCourse();
                    signupCourse.setLessonCount(0);
                    signupCourse.setSignupPurchaseId(generatePurchaseId(index++));
                    signupCourse.setOrgCourseId(studentCourse.getRealCourseId());
                    signupCourse.setClassId(studentCourse.getCourseId());
                    signupCourse.setUserId(studentCourse.getUserId());
                    signupCourse.setChargeUnit(studentCourse.getChargeUnit());
                    signupCourse.setOrgId(orgId);
                    signupCourse.setUpdateTime(studentCourse.getCreateTime());
                    signupCourse.setStatus(6);
                    signupCourseList.add(signupCourse);
                    log.info("[Kexiao] create signupCourse={}",signupCourse);
                }else {
                    log.warn("[Kexiao] student course not exist order.studentCourse={}",studentCourse);
                }
            }
        }
        Map<String,OrgSignupCourse> signupCourseMap = new HashMap<>();
        for (OrgSignupCourse signupCourse:signupCourseList){
            String key = getUniqueId(signupCourse);
            signupCourseMap.put(key,signupCourse);
        }
        Map<String,Integer> userCourseCompleteStatusMap = new HashMap<>();

        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = getKey(signupCourse.getUserId(),signupCourse.getClassId());
            Integer status = userCourseCompleteStatusMap.get(key);
            if (status==null){
                if(isComputable(signupCourse)) {
                    status = 0;
                }else {
                    status = 1;
                }
                userCourseCompleteStatusMap.put(key,status);
            }else if(!isComputable(signupCourse)){
                userCourseCompleteStatusMap.put(key,1);
            }
        }

        for (OrgSignupCourse signupCourse : signupCourseList) {
            KexiaoStudentStat stat = ret.get(signupCourse.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(signupCourse.getUserId());
                stat.setCompleteStatus(0);//初始化
                ret.put(signupCourse.getUserId(), stat);
            }
            String key=getKey(signupCourse.getUserId(),signupCourse.getClassId());
            stat.setCompleteStatus(userCourseCompleteStatusMap.get(key));
            addBuyData(signupCourse, stat);
            stat.splitContractNumber(signupCourse);
        }

        Set<String> keySet = userCourseCompleteStatusMap.keySet();
        if(keySet!=null) {
            Set<Long> unCompleteUsers = new HashSet<>();
            for (String key : keySet) {

                long userId = Long.parseLong(key.split("_")[0]);
                if (userCourseCompleteStatusMap.get(key) != 0) {
                    unCompleteUsers.add(userId);
                }
            }
            for (KexiaoStudentStat stat:ret.values()){
                if(unCompleteUsers.contains(stat.getUserId())){
                    stat.setCompleteStatus(1);
                }else {
                    stat.setCompleteStatus(0);
                }
            }
        }

        log.info("[Kexiao] result={},userCourseCompleteStatusMap={}",ret,userCourseCompleteStatusMap);
        //2.课消金额
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, null);
        Map<Long,List<OrgSignupCourseLesson>> lessonMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : courseLessons) {
            KexiaoStudentStat stat = ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(lesson.getUserId());
                ret.put(lesson.getUserId(), stat);
            }
            List<OrgSignupCourseLesson> list = lessonMap.get(lesson.getSignupCourseId());
            if(list==null){
                list = new ArrayList<>();
                lessonMap.put(lesson.getSignupCourseId(),list);
            }
            list.add(lesson);
            addKexiaoData(lesson, stat);
            if(stat.getCompleteStatus()==0) {
                stat.splitKexiaoNumber(lesson);
            }
        }
        log.info("[Kexiao] result={}",ret);
        //3.退款(班)金额
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIds(orgId, userIds);
        if(log.isDebugEnabled()) {
            log.debug("[Kexiao] Refund list={}", refundList);
        }
        //已退班,但是没有退班记录
        Map<Long,OrgSignupRefund> refundMap = createRefundRecord(orgId,signupCourseList,refundList);
        if(refundMap!=null && refundMap.size()>0){
            if(refundList==null || refundList.isEmpty()){
                refundList = new ArrayList<>();
            }
            refundList.addAll(refundMap.values());
        }
        refundList = mergeRefund(refundList);
        log.info("[Kexiao] Refund list={}",refundList);
        for (OrgSignupRefund refund : refundList) {
            OrgSignupCourse signupCourse = signupCourseMap.get(getUniqueId(refund));
            List<OrgSignupCourseLesson> lessons = null;
            log.info("[Kexiao] Refund signupCourse={}",signupCourse);
            if(signupCourse!=null && signupCourse.getId()!=null && signupCourse.getId()>0){
                lessons = lessonMap.get(signupCourse.getId());
            }
            if(signupCourse!=null
                    && isHistoryRefund(refund)
                    && isRefunded(signupCourse.getStatus())) {
                handleHistoryRefundData(refund, signupCourse, lessons);
            }else {
                log.info("No need handle.signupCourse={}",signupCourse);
            }
        }

        for (OrgSignupRefund refund : refundList) {
            KexiaoStudentStat stat = ret.get(refund.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(refund.getUserId());
                ret.put(refund.getUserId(), stat);
            }
            OrgSignupCourse signupCourse = signupCourseMap.get(getUniqueId(refund));
            log.info("[Kexiao] Refund purchaseId={}",refund.getSignupPurchaseId());
            if(signupCourse!=null) {
                String key = getKey(signupCourse.getUserId(), signupCourse.getClassId());
                addRefundData(refund, stat, userCourseCompleteStatusMap.get(key));
                if(stat.getCompleteStatus()==0) {
                    stat.splitRefundNumber(refund);
                }
            }

        }
        log.info("[Kexiao] result={}",ret);
        //4.转班金额
        Map<Long, List<TxTransferClassRecord>> recordListMap = getTxTransferClassRecordList(userIds);

        Set<Long> userIdSet = recordListMap.keySet();
        for (Long userId : userIdSet) {
            KexiaoStudentStat stat = ret.get(userId);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(userId);
                ret.put(userId, stat);
            }
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list != null && list.size() > 0) {
                for (TxTransferClassRecord record : list) {
                    addTransferData(record, stat);
                    if(stat.getCompleteStatus()==0) {
                        stat.splitTransferNumber(record);
                    }
                }
            }
        }
        log.info("[Kexiao] result={}",ret);
        //处理未补充数据
        List<OrgStudentLesson> lessons = studentLessonDao.listByUserIdsAndLessonType(orgId,userIds,Arrays.asList(-1),"id","userId","courseId","kexiaoStatus");
        for (OrgStudentLesson lesson:lessons){
            KexiaoStudentStat stat = ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(lesson.getUserId());
                ret.put(lesson.getUserId(), stat);
            }
            if(lesson.getKexiaoStatus()==1){
                stat.setKexiaoNormalCount(stat.getKexiaoNormalCount()+1);
            }
            stat.setArrangeNormalCount(stat.getArrangeNormalCount()+1);
        }
        log.info("[Kexiao] result={}",ret);
        return ret;
    }

    //2017/6/1 日以前,并且没有记录refund_lesson_count
    private boolean isHistoryRefund(OrgSignupRefund refund){
        return refund.getCreateTime().compareTo(SUPPORT_TIME)<0 && refund.getRefundLessonCount()<1;
    }

    private String getUniqueId(OrgSignupCourse signupCourse){
        return  signupCourse.getSignupPurchaseId()+"_"+signupCourse.getClassId();
    }

    private String getUniqueId(OrgSignupRefund refund){
        return  refund.getSignupPurchaseId()+"_"+refund.getClassId();
    }

    private long generatePurchaseId(int index){
        return System.currentTimeMillis()*10+index;
    }

    private boolean isComputable(OrgSignupCourse signupCourse){
        return signupCourse.getLessonCount() > 0 ||
                signupCourse.getStatus()==SignupCourseStatus.QUIT_CLASS.getCode() ||
                signupCourse.getStatus()==SignupCourseStatus.QUIT_PURCHASE.getCode();
    }

    public Map<Long,OrgSignupRefund>  createRefundRecord(long orgId,List<OrgSignupCourse> signupCourseList,List<OrgSignupRefund> refundList){
        log.debug("[Kexiao] Create refund record.signupCourseList={}",signupCourseList);
        Map<Long,OrgSignupRefund> ret = new HashMap<>();
        if(signupCourseList==null || signupCourseList.size()<1){
            return ret;
        }

        Set<Long> classIds = new HashSet<>();
        Set<Long> userIds = new HashSet<>();
        Set<String> keySet = new HashSet<>();
        for (OrgSignupCourse course:signupCourseList){
            classIds.add(course.getClassId());
            userIds.add(course.getUserId());
            keySet.add(course.getUserId()+"_"+course.getClassId());
        }
        log.info("[Kexiao] create refund record.classIds={},userIds={},keySet={}",classIds,userIds,keySet);
        if(classIds.isEmpty()){
            log.info("[Kexiao] not need to handle");
            return ret;
        }
        //List<OrgStudentCourse> studentCourseList = studentcourseDao.getByCourseIdsStudentId(orgId,classIds,userIds,null,0);

        Set<String> refundPurchaseIds = new HashSet<>();
        for (OrgSignupRefund refund:refundList){
            refundPurchaseIds.add(getUniqueId(refund));
        }

        for (OrgSignupCourse course:signupCourseList){
            if(isRefunded(course.getStatus()) && !refundPurchaseIds.contains(getUniqueId(course))){//订单已退,但没有退班记录
                OrgSignupRefund refund = new OrgSignupRefund();
                refund.setCreateTime(course.getUpdateTime()==null?course.getCreateTime():course.getUpdateTime());
                refund.setSignupPurchaseId(course.getSignupPurchaseId());
                refund.setRefundLessonCount(0L);
                refund.setRefundFee(course.getTotalPayPrice());
                refund.setClassId(course.getClassId());
                refund.setCourseId(course.getOrgCourseId());
                refund.setChargeUnit(course.getChargeUnit());
                refund.setUserId(course.getUserId());
                refund.setOrgId(course.getOrgId());
                refund.setKexiaoMoney(0L);
                refund.setKexiaoCount(0L);
                ret.put(course.getId(),refund);
            }
        }
        return ret;
    }

    @Override
    public Map<String, KexiaoStatistics> queryClassKexiaoStatByUserIds(Long orgId, Collection<Long> userIds) {
        Map<String, KexiaoStatistics> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        //1.总金额:报名记录
        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, SignupCourseStatus.PAY_SUCCESS);
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = getKey(signupCourse.getUserId(),signupCourse.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStatistics();
                stat.setCompleteStatus(0);//初始化
                ret.put(key, stat);
            }
            if (!isComputable(signupCourse)) {
                stat.setCompleteStatus(1);
            }
            addBuyData(signupCourse, stat);
        }

        Map<String,OrgSignupCourse> signupCourseMap = new HashMap<>();
        for (OrgSignupCourse signupCourse:signupCourseList){
            String key = getUniqueId(signupCourse);
            signupCourseMap.put(key,signupCourse);
        }

        //2.课消金额
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, null);
        Map<Long, List<OrgSignupCourseLesson>> lessonsMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : courseLessons) {
            String key = getKey(lesson.getUserId(),lesson.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            addKexiaoData(lesson, stat);
            if (lesson.getSignupCourseId() > 0) {
                List<OrgSignupCourseLesson> lessonList = lessonsMap.get(lesson.getSignupCourseId());
                if (lessonList == null) {
                    lessonList = new ArrayList<>();
                    lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                }
                lessonList.add(lesson);
            }
        }

        //3.退款(班)金额
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIds(orgId, userIds);
        refundList = mergeRefund(refundList);
        for (OrgSignupRefund refund : refundList) {
            if (isHistoryRefund(refund)) {
                OrgSignupCourse signupCourse = signupCourseMap.get(getUniqueId(refund));
                if (signupCourse != null && isRefunded(signupCourse.getStatus())) {
                    handleHistoryRefundData(refund, signupCourse, lessonsMap.get(signupCourse.getId()));
                }
            }
        }
        for (OrgSignupRefund refund : refundList) {
            String key = getKey(refund.getUserId(),refund.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            log.debug("[KexiaoStatistics] statistics={}",stat);
            addRefundData(refund, stat,stat.getCompleteStatus());
        }
        //4.转班金额
        Map<Long, List<TxTransferClassRecord>> recordListMap = getTxTransferClassRecordList(userIds);

        Set<Long> keySet = recordListMap.keySet();

        for (Long userId : keySet) {
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list != null && list.size() > 0) {
                for (TxTransferClassRecord record : list) {
                    String key = getKey(record.getTransferOutUserId(),record.getTransferOutClassId());
                    KexiaoStatistics stat = ret.get(key);
                    if (stat == null) {
                        stat = new KexiaoStudentStat();
                        ret.put(key, stat);
                    }
                    addTransferData(record, stat);
                }
            }
        }

        //处理未补充数据
        List<OrgStudentLesson> lessons = studentLessonDao.listByUserIdsAndLessonType(orgId,userIds,Arrays.asList(-1),"id","userId","courseId","kexiaoStatus");
        for (OrgStudentLesson lesson:lessons){
            String key = getKey(lesson.getUserId(),lesson.getCourseId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            if(lesson.getKexiaoStatus()==1){
                stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber()+1);
            }
            stat.setArrangeNormalNumber(stat.getArrangeNormalNumber()+1);
        }

        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userIds, ret);
        return ret;
    }

    private String getKey(long userId,long classId){
        return userId+"_"+classId;
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIds(userIds, status);
        return getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds, Long classId) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIdsAndClassId(userIds, classId, status);
        return getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getUserIdToRecordListMap(List<TxTransferClassInfo> transferClassInfos) {
        Map<Long, List<TxTransferClassRecord>> ret = new HashMap<>();
        Map<Long, TxTransferClassInfo> numberMap = CollectionHelper.toKeyMap(transferClassInfos, "transferNumber");

        List<Long> transferNumbers = ListUtil.toKeyList(transferClassInfos, "transferNumber", TxTransferClassInfo.class);
        List<TxTransferClassRecord> recordList = new ArrayList<>();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = transferClassRecordDao.listByTransferNumbers(transferNumbers);
        }
        for (TxTransferClassRecord record : recordList) {
            long number = record.getTransferNumber();
            TxTransferClassInfo classInfo = numberMap.get(number);

            List<TxTransferClassRecord> list = ret.get(classInfo.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                ret.put(classInfo.getUserId(), list);
            }
            list.add(record);
        }

        return ret;
    }

    private void addBuyData(OrgSignupCourse signupCourse, KexiaoStatistics stat) {
        log.info("[Kexiao] signupCourse={},KexiaoStatistics={}",signupCourse,stat);
        if(stat.getCompleteStatus()==0) {
            stat.setContractAmount(stat.getContractAmount() + signupCourse.getTotalPayPrice());
            stat.setContractNumber(stat.getContractNumber() + KexiaoUtil.getClassNumber(signupCourse));
        }
    }

    private void addKexiaoData(OrgSignupCourseLesson lesson, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            //已课消数据
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoNormalAmount(stat.getKexiaoNormalAmount() + lesson.getAmount());
                    stat.setKexiaoNormalNumber(stat.getKexiaoNormalNumber() + getLessonNumber(lesson));
                }
                stat.setArrangeNormalAmount(stat.getArrangeNormalAmount() + lesson.getAmount());
                stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + getLessonNumber(lesson));
                }
                //已排课数据
                stat.setArrangeFreeNumber(stat.getArrangeFreeNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                stat.setCancelNormalNumber(stat.getCancelNormalNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE_CANCEL.getCode()) {
                stat.setCancelFreeNumber(stat.getCancelFreeNumber() + getLessonNumber(lesson));
            }
        }
    }

    private int getLessonNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime(lesson.getChargeUnit())) {
            return lesson.getLessonDuration();
        } else {
            return 1;
        }
    }

    private void addRefundData(OrgSignupRefund refund, KexiaoStatistics stat,int completeStatus) {
        if(completeStatus==0) {
            stat.setRefundAmount(stat.getRefundAmount() + refund.getRefundFee() + refund.getRefundPrice());
            stat.setRefundNormalNumber(stat.getRefundNormalNumber() + refund.getRefundLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassInfo info, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + info.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + info.getLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassRecord record, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + record.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + record.getRealLessonCount().intValue());
            stat.setTransferFreeNumber(stat.getTransferFreeNumber() + record.getFreeLessonCount());
        }
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIds(Long orgId, Collection<Long> classIds) {
        Map<Long, Long> classIdToCourseId = courseApiService.mapClassIdToCourseId(classIds);
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdsAndStudentIds(orgId, null, classIdToCourseId.values(), null);
        Map<Long, KexiaoSignupCourseStat> statMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);

        Map<Long, KexiaoStatistics> ret = new HashMap<>();

        Set<Long> keySet = statMap.keySet();
        for (Long id : keySet) {
            KexiaoSignupCourseStat stat = statMap.get(id);
            log.debug("[KexiaoSignupCourseStat] KexiaoSignupCourseStat={}", stat);
            KexiaoStatistics existStat = ret.get(stat.getClassId());
            if (existStat == null) {
                existStat = new KexiaoStatistics();
                BeanUtils.copyProperties(stat, existStat);
                ret.put(stat.getClassId(), existStat);
            } else {
                existStat.setContractNumber(existStat.getContractNumber() + stat.getContractNumber());
                existStat.setContractAmount(existStat.getContractAmount() + stat.getContractAmount());

                existStat.setArrangeNormalNumber(existStat.getArrangeNormalNumber() + stat.getArrangeNormalNumber());
                existStat.setArrangeNormalAmount(existStat.getArrangeNormalAmount() + stat.getArrangeNormalAmount());
                existStat.setArrangeFreeNumber(existStat.getArrangeFreeNumber() + stat.getArrangeFreeNumber());
                existStat.setCancelNormalNumber(existStat.getCancelNormalNumber() + stat.getCancelNormalNumber());
                existStat.setCancelFreeNumber(existStat.getCancelFreeNumber() + stat.getCancelFreeNumber());

                existStat.setRefundAmount(existStat.getRefundAmount() + stat.getRefundAmount());
                existStat.setRefundNormalNumber(existStat.getRefundNormalNumber() + stat.getRefundNormalNumber());
                existStat.setRefundFreeNumber(existStat.getRefundFreeNumber() + stat.getRefundFreeNumber());

                existStat.setTransferAmount(existStat.getTransferAmount() + stat.getTransferAmount());
                existStat.setTransferNormalNumber(existStat.getTransferNormalNumber() + stat.getTransferNormalNumber());
                existStat.setTransferFreeNumber(existStat.getTransferFreeNumber() + stat.getTransferFreeNumber());

                existStat.setKexiaoNormalNumber(existStat.getKexiaoNormalNumber() + stat.getKexiaoNormalNumber());
                existStat.setKexiaoNormalAmount(existStat.getKexiaoNormalAmount() + stat.getKexiaoNormalAmount());
                existStat.setKexiaoFreeNumber(existStat.getKexiaoFreeNumber() + stat.getKexiaoFreeNumber());
            }
        }
        return ret;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentCourse(long orgId, long userId, long courseId) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        OrgStudentCourse studentCourse = studentcourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
        if (studentCourse != null) {
            statistics = queryKexiaoStatByStudentClass(orgId, userId, studentCourse.getCourseId());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userId, courseId, statistics);
        return statistics;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentClass(long orgId, long userId, long classId) {
        Long courseId = classId;
        OrgCourse course = courseDao.getById(classId, "id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit");
        if (course == null) {
            throw new ParameterException("班级ID不存在!(" + classId + ")");
        }
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            courseId = course.getParentId();
        } else {
            courseId = course.getId();
        }
        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId), classId, orgId,SignupCourseStatus.PAY_SUCCESS);

        //历史退班或转班的,没有订单
        if(signupCourseList==null || signupCourseList.size()<1){
            OrgStudentCourse studentCourse = studentcourseDao.listByCourseIdAndUserId(orgId,classId,userId);
            if(studentCourse.getStatus()!=0){
                signupCourseList = new ArrayList<>();
                OrgSignupCourse signupCourse = new OrgSignupCourse();
                signupCourse.setLessonCount(0);
                signupCourse.setUpdateTime(studentCourse.getCreateTime());
                signupCourse.setStatus(6);
                signupCourse.setUserId(userId);
                signupCourse.setClassId(classId);
                signupCourse.setOrgCourseId(courseId);
                signupCourseList.add(signupCourse);
            }
        }
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listLessonsByUserIdAndClassId(orgId, userId, classId, null, null);
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIdAndClassId(orgId, userId, classId);
        Set<String> refundIds = new HashSet<>();
        Set<Long> refundPurchaseIds = new HashSet<>();
        for (OrgSignupRefund refund:refundList){
            refundIds.add(refund.getUserId()+"_"+refund.getClassId());
            refundPurchaseIds.add(refund.getSignupPurchaseId());
        }

        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIdAndClassId(userId, classId, status);
        List<Long> transferNumbers = ListUtil.toKeyList(transferClassInfos, "transferNumber", TxTransferClassInfo.class);
        List<TxTransferClassRecord> recordList = new ArrayList<>();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = transferClassRecordDao.listByTransferNumbers(transferNumbers);
        }

        for (OrgSignupCourse signupCourse:signupCourseList){
            log.info("[Kexiao] signupCourse={}",signupCourse);
            if(signupCourse.getStatus()==6 && !refundPurchaseIds.contains(signupCourse.getSignupPurchaseId())) {
                OrgSignupRefund refund = new OrgSignupRefund();
                refund.setCreateTime(signupCourse.getUpdateTime() == null ? signupCourse.getCreateTime() : signupCourse.getUpdateTime());
                refund.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
                refund.setRefundLessonCount(0L);
                refund.setRefundFee(signupCourse.getTotalPayPrice());
                refund.setClassId(signupCourse.getClassId());
                refund.setCourseId(signupCourse.getOrgCourseId());
                refund.setChargeUnit(course.getChargeUnit());
                refund.setUserId(signupCourse.getUserId());
                refund.setOrgId(signupCourse.getOrgId());
                refund.setKexiaoMoney(0L);
                refund.setKexiaoCount(0L);

                for (OrgSignupRefund signupRefund : refundList) {
                    if (signupRefund.getSignupPurchaseId().equals(signupCourse.getSignupPurchaseId())) {
                        refund.setRefundFee(refund.getRefundFee() - signupRefund.getRefundFee() - signupRefund.getRefundPrice());
                        refund.setRefundLessonCount(refund.getRefundLessonCount() - signupRefund.getRefundLessonCount());
                    }
                }

                for (OrgSignupCourseLesson courseLesson : courseLessons) {
                    if (courseLesson.getSignupCourseId().equals(signupCourse.getId()) && courseLesson.getKexiaoStatus() == 1) {
                        refund.setRefundFee(refund.getRefundFee() - courseLesson.getAmount());
                        refund.setRefundLessonCount(refund.getRefundLessonCount() - courseLesson.getLessonCount());
                    }
                }
                refund.setKexiaoCount(signupCourse.getLessonCount() - refund.getRefundLessonCount());
                refundList.add(refund);
            }
        }

        //处理历史数据:班已经退了,但无退班记录,在内存中补充
        OrgStudentCourse studentCourse = studentcourseDao.listByCourseIdAndUserId(orgId,classId,userId);
        if(studentCourse.getStatus()==1 && !refundIds.contains(studentCourse.getUserId()+"_"+studentCourse.getCourseId())){

        }

        refundList = new ArrayList<>(mergeRefund(refundList));

        KexiaoStatistics statistics = createClassKexiaoStatistics(signupCourseList, courseLessons, refundList, recordList);
        statistics.setUserId(userId);
        statistics.setClassId(classId);
        statistics.setChargeUnit(course.getChargeUnit());
        if (statistics.getCompleteStatus() != 0 || signupCourseList.size() < 1) {
            handHistoryArrangeLesson(orgId, userId, classId, statistics);
        }

        //如果用户的订单未补充,则需要重新计算总课次和赠送课
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode()) {
            List<OrgStudentLesson> studentLessons = studentLessonDao.getByUserIdAndClassId(orgId, userId, classId, null);
            int kexiaoCount = 0;
            for (OrgStudentLesson studentLesson : studentLessons) {
                if (studentLesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoCount++;
                }
            }
            statistics.setKexiaoNormalNumber(kexiaoCount);
            statistics.setArrangeNormalNumber(studentLessons.size());
        }

        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userId, classId, statistics);
        return statistics;
    }


    private List<OrgSignupRefund> mergeRefund(List<OrgSignupRefund> refundList){
        Map<String,OrgSignupRefund> refundMap = new HashMap<>();
        for (OrgSignupRefund refund:refundList){
            String key = refund.getSignupPurchaseId()+"_"+refund.getClassId();
            OrgSignupRefund exist = refundMap.get(key);
            if(exist!=null){
                if(exist.getCreateTime().compareTo(refund.getCreateTime())<0){
                    exist.setCreateTime(refund.getCreateTime());
                }
                exist.setRefundFee(refund.getRefundFee()+exist.getRefundFee());
                exist.setRefundLessonCount(refund.getRefundLessonCount()+exist.getRefundLessonCount());
                exist.setRefundPrice(refund.getRefundPrice()+exist.getRefundPrice());
                exist.setKexiaoCount(refund.getKexiaoCount()+exist.getKexiaoCount());
                exist.setKexiaoMoney(refund.getKexiaoMoney()+exist.getKexiaoMoney());
            }else {
                refundMap.put(key,refund);
            }
        }
        log.info("[Kexiao] merge result={}",refundMap);
        return new ArrayList(refundMap.values());
    }

    /**
     * 未补充的订单计算排课
     *
     * @param orgId
     * @param userId
     * @param classId
     * @param statistics
     */
    private void handHistoryArrangeLesson(long orgId, long userId, long classId, KexiaoStatistics statistics) {
        List<OrgStudentLesson> lessons = studentLessonDao.getByUserIdAndClassId(orgId, userId, classId, null, Arrays.asList(LessonType.OTHER.getCode()));
        if (lessons != null && lessons.size() > 0) {
            for (OrgStudentLesson lesson : lessons) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    statistics.setKexiaoNormalNumber(statistics.getKexiaoNormalNumber() + 1);
                }
                statistics.setArrangeNormalNumber(statistics.getArrangeNormalNumber() + 1);
            }
        }

    }

    /**
     * 用户在班级上的课消统计
     * @param signupCourseList
     * @param courseLessons
     * @param refundList
     * @param recordList
     * @return
     */
    private KexiaoStatistics createClassKexiaoStatistics(List<OrgSignupCourse> signupCourseList,
                                                         List<OrgSignupCourseLesson> courseLessons,
                                                         List<OrgSignupRefund> refundList,
                                                         List<TxTransferClassRecord> recordList) {
        KexiaoStatistics statistics = new KexiaoStatistics();

        int completeStatus = 0;
        Map<String, OrgSignupCourse> courseMap = new HashMap<>();
        //计算合同数据
        if (signupCourseList != null && signupCourseList.size() > 0) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                addBuyData(signupCourse, statistics);
                if (!isComputable(signupCourse)) {
                    completeStatus = 1;
                }
            }

            log.info("[Kexiao] KexiaoStatistics={}",statistics);
            for (OrgSignupCourse signupCourse:signupCourseList){
                courseMap.put(getUniqueId(signupCourse),signupCourse);
            }
        }
        statistics.setCompleteStatus(completeStatus);

        Map<Long, List<OrgSignupCourseLesson>> lessonsMap = new HashMap<>();
        //增加课消/排课数据
        if (courseLessons != null && courseLessons.size() > 0) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                addKexiaoData(lesson, statistics);
                if (lesson.getSignupCourseId() > 0) {
                    List<OrgSignupCourseLesson> lessonList = lessonsMap.get(lesson.getSignupCourseId());
                    if (lessonList == null) {
                        lessonList = new ArrayList<>();
                        lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                    }
                    lessonList.add(lesson);
                }
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}",statistics);

        log.info("[Kexiao] OrgSignupRefund list={}",refundList);

        //计算退班数据
        if (refundList != null && refundList.size() > 0) {
            for (OrgSignupRefund refund : refundList) {
                if (isHistoryRefund(refund)) {
                    OrgSignupCourse signupCourse = courseMap.get(getUniqueId(refund));
                    if (signupCourse != null && isRefunded(signupCourse.getStatus())) {
                        handleHistoryRefundData(refund, signupCourse, lessonsMap.get(signupCourse.getId()));
                    }else {
                        log.info("Signupcourse is not exist.courseMap={},refund={}",courseMap,refund);
                    }
                }else {
                    log.info("It is not history refund record.");
                }
            }
            for (OrgSignupRefund refund : refundList) {
                addRefundData(refund, statistics,completeStatus);
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}",statistics);

        //4.转班金额
        if (recordList != null && recordList.size() > 0) {
            for (TxTransferClassRecord record : recordList) {
                addTransferData(record, statistics);
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}",statistics);
        return statistics;

    }

    private boolean isRefunded(int status){
        return status==SignupCourseStatus.QUIT_CLASS.getCode()|| status==SignupCourseStatus.QUIT_PURCHASE.getCode();
    }

    //处理历史退班数据,历史退班退班课节数=报名课节数-课消课节数
    private void handleHistoryRefundData(OrgSignupRefund refund, OrgSignupCourse signupCourse, List<OrgSignupCourseLesson> courseLessons) {
        log.info("[KexiaoStatistics] handle refund before:refund={},courseLessons={}", refund,courseLessons);
        if(signupCourse == null){
            log.warn("[Kexiao] signupCourse is null");
            return;
        }
        if (signupCourse.getLessonCount() < 1 ) {
            refund.setRefundPrice(signupCourse.getTotalPayPrice() - refund.getRefundFee());
        } else {
            long kexiaoNumber = 0;
            long kexiaoMoney = 0;
            if (courseLessons != null) {
                for (OrgSignupCourseLesson lesson : courseLessons) {
                    if (lesson != null && lesson.getKexiaoStatus() != null && lesson.getLessonType() != null
                            && lesson.getKexiaoStatus() == 1 && lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                        if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                            kexiaoNumber += lesson.getLessonDuration();
                        } else {
                            kexiaoNumber++;
                        }
                        kexiaoMoney += lesson.getAmount();
                    }
                }
            }
            refund.setRefundLessonCount(KexiaoUtil.getClassNumber(signupCourse) - kexiaoNumber);
            refund.setRefundPrice(signupCourse.getTotalPayPrice() - refund.getRefundFee() - kexiaoMoney);
            log.info("[Kexiao] kexiaoNumber={},kexiaoMoney={}",kexiaoNumber,kexiaoMoney);
        }

        log.info("[Kexiao] handle refund after:{},signupCourse={}", refund, signupCourse);
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIdAndUserIds(long orgId, long classId, Collection<Long> userIds) {
        Map<Long, KexiaoStatistics> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        Long courseId = classId;
        OrgCourse course = courseDao.getById(classId, "id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit");
        if (course == null) {
            throw new ParameterException("班级ID不存在!(" + classId + ")");
        }
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            courseId = course.getParentId();
        } else {
            courseId = course.getId();
        }

        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, classId, orgId, SignupCourseStatus.PAY_SUCCESS);
        Map<Long, List<OrgSignupCourse>> signupCourseMap = new HashMap<>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            List<OrgSignupCourse> list = signupCourseMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                signupCourseMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }

        Map<Long, List<OrgSignupCourseLesson>> courseLessonMap = new HashMap<>();
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdsAndClassId(userIds, classId, null);
        for (OrgSignupCourseLesson courseLesson : courseLessons) {
            List<OrgSignupCourseLesson> list = courseLessonMap.get(courseLesson.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                courseLessonMap.put(courseLesson.getUserId(), list);
            }
            list.add(courseLesson);
        }

        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIdsAndClassId(orgId, userIds, classId);
        Map<Long, List<OrgSignupRefund>> refundMap = new HashMap<>();
        for (OrgSignupRefund refund : refundList) {
            List<OrgSignupRefund> list = refundMap.get(refund.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                refundMap.put(refund.getUserId(), list);
            }
            list.add(refund);
        }

        Map<Long, List<TxTransferClassRecord>> recordMap = getTxTransferClassRecordList(userIds, classId);

        for (Long userId : userIds) {
            KexiaoStatistics statistics = createClassKexiaoStatistics(
                    signupCourseMap.get(userId),
                    courseLessonMap.get(userId), refundMap.get(userId),
                    recordMap.get(userId));
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            ret.put(userId, statistics);
        }
        return ret;
    }

    @Override
    public Map<Long, KexiaoSignupCourseStat> queryKexiaoStatBySignUpCourseIds(Collection<OrgSignupCourse> signupCourseList) {
        if (signupCourseList == null || signupCourseList.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map<String, OrgSignupCourse> courseMap = new HashMap<>();
        for (OrgSignupCourse signupCourse:signupCourseList){
            courseMap.put(getUniqueId(signupCourse),signupCourse);
        }

        //1.查询订单信息
        List<Long> signupCourseIds = ListUtil.toKeyList(signupCourseList, "id", OrgSignupCourse.class);
        List<Long> purchaseIds = ListUtil.toKeyList(signupCourseList, "signupPurchaseId", OrgSignupCourse.class);
        //2.查询已排课信息
        List<OrgSignupCourseLesson> arrangedList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds, LessonType.FREE.getCode(), null);
        Map<Long, OrgSignupCourseLesson> arrangedFreeMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : arrangedList) {
            arrangedFreeMap.put(lesson.getSignupCourseId(), lesson);
        }
        List<OrgSignupCourseLesson> normalList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds, LessonType.NORMAL.getCode(), null);
        Map<Long, OrgSignupCourseLesson> arrangedNormalMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : normalList) {
            arrangedNormalMap.put(lesson.getSignupCourseId(), lesson);
        }

        //3.查询已课消信息
        List<OrgSignupCourseLesson> freeKexiaoList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds,
                LessonType.FREE.getCode(), LessonStatus.FINISHED.getStatus());
        Map<Long, OrgSignupCourseLesson> freeKexiaoMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : freeKexiaoList) {
            freeKexiaoMap.put(lesson.getSignupCourseId(), lesson);
        }

        List<OrgSignupCourseLesson> kexiaoList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds,
                LessonType.NORMAL.getCode(), LessonStatus.FINISHED.getStatus());
        Map<Long, List<OrgSignupCourseLesson>> lessonsMap = new HashMap<>();
        Map<Long, OrgSignupCourseLesson> normalKexiaoMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : kexiaoList) {
            normalKexiaoMap.put(lesson.getSignupCourseId(), lesson);
            if (lesson.getSignupCourseId() > 0) {
                List<OrgSignupCourseLesson> lessonList = lessonsMap.get(lesson.getSignupCourseId());
                if (lessonList == null) {
                    lessonList = new ArrayList<>();
                    lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                }
                lessonList.add(lesson);
            }
        }
        //4.查询转班信息
        List<Integer> status = Arrays.asList(TransferClassStatus.SUCCESS.getCode(), TransferClassStatus.INIT.getCode());
        Map<String, TxTransferClassRecord> purchaseTransferMap = transferClassRecordDao.groupByPurchaseIds(purchaseIds, status);
        //5.查询退款/退班信息
        List<OrgSignupRefund> refunds = refundDao.getByPurcahseIds(new HashSet<Long>(purchaseIds));
        Map<String, OrgSignupRefund> refundMap = new HashMap<>();
        for (OrgSignupRefund refund : refunds) {

            if (isHistoryRefund(refund)) {
                OrgSignupCourse signupCourse = courseMap.get(getUniqueId(refund));
                if (signupCourse != null && isRefunded(signupCourse.getStatus())) {
                    handleHistoryRefundData(refund, signupCourse, lessonsMap.get(signupCourse.getId()));
                }
            }

            String key = refund.getSignupPurchaseId() + "_" + refund.getClassId();
            OrgSignupRefund tmp = refundMap.get(key);
            if (tmp == null) {
                refundMap.put(key, refund);
            } else {
                tmp.setRefundFee(tmp.getRefundFee() + tmp.getRefundPrice() + refund.getRefundFee() + refund.getRefundPrice());
                tmp.setRefundLessonCount(tmp.getRefundLessonCount() + refund.getRefundLessonCount());
            }
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);

        //5.计算剩余课次/学费
        Map<Long, KexiaoSignupCourseStat> ret = new HashMap<>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
            KexiaoSignupCourseStat stat = new KexiaoSignupCourseStat();
            KexiaoStatisticsBuilder builder = new KexiaoStatisticsBuilder(stat);
            builder.addSignupCourse(signupCourse)
                    .addArrangedNormalLesson(arrangedNormalMap.get(signupCourse.getId()))
                    .addArrangedFreeLesson(arrangedFreeMap.get(signupCourse.getId()))
                    .addKexiaoFreeLesson(freeKexiaoMap.get(signupCourse.getId()))
                    .addKexiaoNormalLesson(normalKexiaoMap.get(signupCourse.getId()))
                    .addTransferRecord(purchaseTransferMap.get(key))
                    .addRefundRecord(refundMap.get(key));
            builder.build();

            stat.setStatus(signupCourse.getStatus());
            stat.setPurchaseId(signupCourse.getSignupPurchaseId());
            ret.put(signupCourse.getId(), stat);
        }
        return ret;
    }

    @Override
    public OrgSignupCourseLesson querySignupCourseLessonInfo(Long signupCouseId, Long lessonId) {
        Map<String, OrgSignupCourseLesson> lessonMap = signupCourseLessonDao.listBySignupCourseIdAndLessonId(Arrays.asList(signupCouseId), Arrays.asList(lessonId));
        return lessonMap.get(signupCouseId + "_" + lessonId);
    }

    @Override
    public Map<Long, List<OrgSignupCourseLesson>> queryLessonSignupCourseList(Collection<Long> lessonIds, Long userId) {
        List<OrgSignupCourseLesson> lessons = signupCourseLessonDao.listByUserIdAndLessonId(Arrays.asList(userId), lessonIds, null);
        Map<Long, List<OrgSignupCourseLesson>> ret = new HashMap<>();
        for (OrgSignupCourseLesson lesson : lessons) {
            List<OrgSignupCourseLesson> list = ret.get(lesson.getId());
            if (list == null) {
                list = new ArrayList<>();
            }
            list.add(lesson);
        }
        return ret;
    }

    //测试统一课消使用
    public StudentCourseKexiaoDocument finishCountMoney1(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);
        Map<Long, OrgSignupCourse> signupCourseMap = CollectionHelper.toKeyMap(signupCourseList, "id");
        Map<Long, KexiaoSignupCourseStat> courseStatMap = new HashMap<>();
        if (signupCourseId != null && signupCourseId > 0) {
            if (signupCourseMap.keySet().contains(signupCourseId)) {
                courseStatMap = queryKexiaoStatBySignUpCourseIds(Arrays.asList(signupCourseMap.get(signupCourseId)));
            }
        } else {
            courseStatMap = queryKexiaoStatBySignUpCourseIds(signupCourseList);
        }
        StudentCourseKexiaoDocument doc = new StudentCourseKexiaoDocument();
        if (courseStatMap != null && courseStatMap.size() > 0) {
            for (KexiaoStatistics statistics : courseStatMap.values()) {
                log.debug("StudentCourseKexiaoDocument =={},{},{}", statistics, statistics.getLeftAmount(), statistics.getLeftNumber());
                if (ChargeUnit.isByTime(statistics.getChargeUnit())) {
                    doc.setFinishTime(doc.getFinishTime() + statistics.getKexiaoNumber() + statistics.getTransferNumber() + statistics.getRefundNumber());
                    doc.setNormalTime(doc.getNormalTime() + statistics.getKexiaoNormalNumber() + statistics.getTransferNormalNumber() + statistics.getRefundNormalNumber());
                } else {
                    doc.setFinishCount(doc.getFinishCount() + statistics.getKexiaoNumber() + statistics.getTransferNumber() + statistics.getRefundNumber());
                    doc.setNormalCount(doc.getNormalCount() + statistics.getKexiaoNormalNumber() + statistics.getTransferNormalNumber() + statistics.getRefundNormalNumber());
                }
                doc.setFinishMoney(statistics.getKexiaoAmount() + statistics.getTransferAmount() + statistics.getRefundAmount());
            }
        }
        return doc;
    }

    @Override
    public StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        finishCountMoney1(orgId, courseId, userId, signupCourseId, null);

        log.info("StudentCourseKexiaoDocument finishCountMoney = {},{},{},{}", orgId, courseId, userId, signupCourseId, status);
        StudentCourseKexiaoDocument kexiaoDocument = orgStudentKexiaoRecordDao.finishCountMoney(orgId, courseId, userId, signupCourseId, status);
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);

        log.info("StudentCourseKexiaoDocument signupCourseList = {},{}", signupCourseList, kexiaoDocument);
        List<Long> outPurchaseIds = Lists.newArrayList();
        Long classId = 0l;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            classId = signupCourse.getClassId();
            if (signupCourseId != null) {
                if (signupCourse.getId().longValue() == signupCourseId.longValue()) {
                    outPurchaseIds.add(signupCourse.getSignupPurchaseId());
                    break;
                }
            } else {
                outPurchaseIds.add(signupCourse.getSignupPurchaseId());
            }
        }

        if (CollectionUtils.isEmpty(outPurchaseIds)) {
            return kexiaoDocument;
        }

        TxTransferClassRecord txTransferClassRecord = transferClassRecordDao.sumByPurchases(outPurchaseIds, classId);
        log.info("StudentCourseKexiaoDocument txTransferClassRecord=={}", txTransferClassRecord);
        if (txTransferClassRecord != null && txTransferClassRecord.getChargeUnit() != null) {
            if (txTransferClassRecord.getChargeUnit() != null && txTransferClassRecord.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()) {
                kexiaoDocument.setFinishCount(kexiaoDocument.getFinishCount() + txTransferClassRecord.getTransferLessonCount().longValue());
            } else {
                kexiaoDocument.setFinishTime(kexiaoDocument.getFinishTime() + txTransferClassRecord.getTransferLessonCount().longValue());
            }
            kexiaoDocument.setFinishMoney(kexiaoDocument.getFinishMoney() + txTransferClassRecord.getLessonMoney());
        }

        return kexiaoDocument;
    }

    @Override
    public void fillKexiaoData(KexiaoStatisticsSuper dto, KexiaoStatistics statistics) {
        String remainTuition = getLeftAmountStr(statistics);
        dto.setRemainTuition(remainTuition);

        //未补充,并且没有退班
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode() && !statistics.isRefund()) {
            dto.setTotalClassTimesForKexiaoValue(0);
            dto.setLeftClassTimesForKexiaoValue(0);
            dto.setFinishClassTimesForKexiaoValue(0);
            dto.setTotalClassTimesForKexiao("--");
            dto.setLeftClassTimesForKexiao("--");
            dto.setBuyClassTimesForKexiao("--");
            dto.setFinishClassTimesForKexiao("--");
        }else {
            dto.setTotalClassTimesForKexiaoValue((int) statistics.getTotalNumber());
            dto.setLeftClassTimesForKexiaoValue((int) statistics.getLeftNumber());
            dto.setFinishClassTimesForKexiaoValue((int) statistics.getKexiaoNumber());
            if (ChargeUnit.isByTime(statistics.getChargeUnit())) {
                dto.setTotalClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getLeftNumber()));
                dto.setFinishClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", dto);
            } else {
                long leftNum = statistics.getTotalNumber() - statistics.getKexiaoNumber();
                dto.setTotalClassTimesForKexiao(String.valueOf(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(String.valueOf(leftNum));
                dto.setFinishClassTimesForKexiao(String.valueOf(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(String.valueOf(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", dto);
            }
        }
    }
}