
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto.wechatMsgRequest;

import java.util.Date;

import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SignWechatTemplateMsg extends WechatMsgTypeSuper {

    private String studentName;
    private String orgName;
    private int signStatus;
    private String courseName;
    private Long startTime;
    private Long endTime;
    private Long signTime;
    private String teacherName;
    private String extension; // 号码尾缀
    private String scheduleUrl;

    public String createTimeRangeStr() {
        return super.createCourseTime(startTime, endTime);
    }

    public String getSignTimeStr() {
        return DateUtil.getStrByDateFormate(new Date(this.signTime), "yyyy-MM-dd HH:mm");
    }

    public Object getSignStatusStr() {
        return SignStatus.createSignStr(this.signStatus);
    }

    @Override
    public TxWechatTemplateMsgType getType() {
        return TxWechatTemplateMsgType.SIGNUP_WECHAT_TEMPLATE;
    }

    /**
     * @param studentName
     * @param orgName2
     * @param status
     * @param courseName2
     * @param time
     * @param time2
     * @param time3
     * @param teacherName2
     * @param extention
     * @param url
     * @return
     */
    public static SignWechatTemplateMsg newInstance(String studentName, String orgName, Integer signStatus,
        String courseName, Long startTime, Long entTime, long signTime, String teacherName, String extension,
        String url) {
        SignWechatTemplateMsg msg = new SignWechatTemplateMsg();
        msg.setCourseName(courseName);
        msg.setEndTime(entTime);
        msg.setExtension(extension);
        msg.setOrgName(orgName);
        msg.setScheduleUrl(url);
        msg.setSignStatus(signStatus);
        msg.setSignTime(signTime);
        msg.setStartTime(startTime);
        msg.setStudentName(studentName);
        msg.setTeacherName(teacherName);
        return msg;
    }

}
