
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto.wechatMsgRequest;

import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CourseNotifyWechatMsg extends WechatMsgTypeSuper {

    private String studentName;
    private String courseName;
    private String extension;
    private long startTime;
    private long endTime;
    private String teacherName;
    private String roomName;
    private String scheduleUrl;

    @Override
    public TxWechatTemplateMsgType getType() {
        return TxWechatTemplateMsgType.COURSE_NOTIFY_WECHAT_TEMPLATE;
    }

    /**
     * @return
     */
    public String getCourseTimeRange() {
        return super.createFullCourseTime(startTime, endTime);
    }

    /**
     * @param name
     * @param name2
     * @param extension2
     * @param startTime2
     * @param endTime2
     * @param teacherName
     * @param roomName2
     * @param scheduleUrl2
     * @return
     */
    public static CourseNotifyWechatMsg newInstance(String studentName, String courseName, String extension,
        long startTime, long endTime, String teacherName, String roomName, String scheduleUrl) {
        CourseNotifyWechatMsg msg = new CourseNotifyWechatMsg();
        msg.setStudentName(studentName);
        msg.setCourseName(courseName);
        msg.setExtension(extension);
        msg.setStartTime(startTime);
        msg.setEndTime(endTime);
        msg.setTeacherName(teacherName);
        msg.setRoomName(roomName);
        msg.setScheduleUrl(scheduleUrl);
        return msg;
    }

}
