package com.baijia.tianxiao.sal.common.dto.msg;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.util.SmsContentHelper;
import lombok.Data;

import java.util.Map;

/**
 * @author cxm
 * @version 1.0
 * @title SendMsgRequest
 * @desc TODO
 * @date 2016年3月19日
 */
@Data
public class SendMsgRequest extends BaseDto {

    /**
     * 公众号的appid,预留
     */
    private String appId;

    private Long orgId;

    /**
     * 微信模板ID 具体ID查看WechateTemplateMsgType的数字
     */
    private Integer wechatTemplateId;

    /**
     * 短信内容,如果不发短信,将短信内容设置为空即可
     */
    private String smsContent;

    /**
     * 发送人的ID
     */
    private Long senderId;

    private UserRoleEnum senderRole;

    private Long receiverId;

    private UserRoleEnum receiverRole;

    private String mobile;

    /**
     * 微信的openId
     */
    private String weixinOpenId;

    /**
     * 发送短信时是否进行计数,默认短信都开启计数.
     */
    private boolean countSms = true;

    /**
     * 短信模板及编码
     */
    private TxSmsCodeType smsCodeType;

    /**
     * 关联发短信的连带任务，比如报名线上短信支付
     */
    private Long sendSmsKey = 0l;

    /**
     * 默认短信走天校通知通道
     */
    private SmsMessageType smsMsgType = SmsMessageType.TIANXIAO_NOTIFY;

    /**
     * 发送微信消息的参数
     */
    private Map<String, Object> wechatParams;


    /**
     * 如果微信和短信模板同时存在,先发送微信,微信发送是吧再发送短信
     */
    private boolean wechatFirst = true;

}
