package com.baijia.tianxiao.sal.common.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by wengshengli on 2017/8/24.
 */
public enum PointsType {

    PRODUCT(0, "增加积分"),
    CONSUME(1, "消费积分"),
    DEDUCT(2, "扣除积分"),
    ;

    private int type;
    private String label;

    private static Map<Integer, PointsType> cache;

    static {
        cache = Maps.newHashMap();
        for (PointsType pointsType : PointsType.values()) {
            cache.put(pointsType.type, pointsType);
        }
    }

    private PointsType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static PointsType get(int type) {
        return cache.get(type);
    }
}

