package com.baijia.tianxiao.sal.common.api;

import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;

/**
 * Created by wengshengli on 2017/5/23.
 */
public interface CommonMsgService {
    /**
     * 发送微信（优先）或短信
     *
     * @param request
     * @return
     * @throws MsgSendException
     */
    boolean sendMsg(SendMsgRequest request) throws MsgSendException;

    /**
     * 只发短信
     *
     * @param orgId
     * @param sender
     * @param senderRole
     * @param receiver
     * @param receiverRole
     * @param mobile
     * @param smsContent
     * @return
     */
    boolean sendTxSms(Long orgId, Long sender, Integer senderRole, Long receiver, Integer receiverRole,
                      TxSmsCodeType smsCodeType, Long sendSmsKey, String mobile, String smsContent);
}
