/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentKexiaoStatisticsApiServiceImpl
implements StudentKexiaoStatisticsApiService {
    private static final Logger log = LoggerFactory.getLogger(StudentKexiaoStatisticsApiServiceImpl.class);
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;

    public List<KexiaoStatisticss> lessonKexiaoStatistics() {
        return null;
    }

    @Override
    public List<KexiaoStatisticsSuper> fillCurrentCourseInfo(Long orgId, Long userId, Collection<Long> orgCourseIds) {
        if (GenericsUtils.isNullOrEmpty(orgCourseIds) || userId == null) {
            return GenericsUtils.emptyList();
        }
        List<KexiaoStatisticsSuper> retKexiaoList = this.fillInfosForCourse(orgId, userId, orgCourseIds);
        Iterator<KexiaoStatisticsSuper> iter = retKexiaoList.iterator();
        while (iter.hasNext()) {
            KexiaoStatisticsSuper next = iter.next();
            if (next.getOrgStudentCourseStatus().intValue() == StudentCourseStatus.NORMAL.getCode()) {
                Integer leftClassTimesForKexiaoValue = next.getLeftClassTimesForKexiaoValue();
                Integer totalClassTimesForKexiaoValue = next.getTotalClassTimesForKexiaoValue();
                if (leftClassTimesForKexiaoValue == null || totalClassTimesForKexiaoValue == null || leftClassTimesForKexiaoValue > 0 || totalClassTimesForKexiaoValue == 0) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        return retKexiaoList;
    }

    private List<KexiaoStatisticsSuper> fillInfosForCourse(Long orgId, Long userId, Collection<Long> orgCourseIds) {
        ArrayList retKexiaoList = Lists.newArrayListWithCapacity((int)orgCourseIds.size());
        for (Long courseId : orgCourseIds) {
            KexiaoStatisticsSuper kss = KexiaoStatisticsSuper.newInstanceWithUserId();
            kss.setUserId(userId);
            kss.setCourseId(courseId);
            retKexiaoList.add(kss);
        }
        this.fillStudentKeXiaoStatistics(orgId, retKexiaoList, 2);
        return retKexiaoList;
    }

    @Override
    public void fillStudentKeXiaoStatistics(Long orgId, Collection<? extends KexiaoStatisticsSuper> studentRequest, Integer fillInfoType) {
        try {
            if (GenericsUtils.isNullOrEmpty(studentRequest)) {
                return;
            }
            log.debug("studnetRequest are :{} ", studentRequest);
            HashSet courseIds = Sets.newHashSet();
            HashSet setCourseIds = Sets.newHashSet();
            HashSet userIds = Sets.newHashSet();
            HashMap one2OneCourseIdMap = Maps.newHashMap();
            for (KexiaoStatisticsSuper kexiaoStatisticsSuper : studentRequest) {
                if (fillInfoType != 1) {
                    courseIds.add(kexiaoStatisticsSuper.getCourseId());
                    if (kexiaoStatisticsSuper.getParentCourseId() != null && kexiaoStatisticsSuper.getParentCourseId() != 0L) {
                        courseIds.add(kexiaoStatisticsSuper.getParentCourseId());
                        one2OneCourseIdMap.put(kexiaoStatisticsSuper.getCourseId(), kexiaoStatisticsSuper.getParentCourseId());
                    }
                }
                userIds.add(kexiaoStatisticsSuper.getUserId());
            }
            setCourseIds.addAll(courseIds);
            List<StudentClasHourDocument> list = this.searchStudentClasHourDocuments(userIds, orgId);
            Map<String, StudentClassHour> map = this.buildStudentClassHourInfo(list);
            List<StudentClassHourStatusDocument> scsdl = this.searchStudentClassHourStatusDocuments(userIds, orgId);
            Map studentClassHourStatusDocumentMap = GenericsUtils.toFieldMap(scsdl, (String[])new String[]{"userId"});
            HashMap studentCourseMap = this.buildStudentClassStatusInfo(scsdl);
            if (GenericsUtils.isNullOrEmpty(studentCourseMap)) {
                studentCourseMap = Maps.newHashMap();
            }
            for (StudentClass st : studentCourseMap.values()) {
                courseIds.add(st.getCourseId());
            }
            if (GenericsUtils.notNullAndEmpty((Object)setCourseIds)) {
                courseIds.retainAll(setCourseIds);
            }
            List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
            HashMap coursesMap = Maps.newHashMap();
            for (OrgCourse oc : courses) {
                coursesMap.put(oc.getId(), oc);
                if (oc.getParentId() == null || oc.getParentId() == 0L) continue;
                courseIds.add(oc.getParentId());
                one2OneCourseIdMap.put(oc.getId(), oc.getParentId());
            }
            Map<String, StudentClassHour> studentClassHourMap = this.findStudentClassHours(map, studentCourseMap, coursesMap);
            List findKexiaoStatistics = this.orgStudentKexiaoRecordDao.findKexiaoStatistics(orgId, (Collection)userIds, (Collection)courseIds);
            List findAllOrgStudentSigupStatistics = this.orgSignupCourseDao.findAllOrgStudentSignupStatistics(orgId, (Collection)userIds, (Collection)courseIds);
            Map sumRefundMoney = this.orgSignupRefundDao.sumRefundMoney(orgId, (Collection)courseIds, (Collection)userIds);
            Map orgStudentSigupStatisticsMap = Maps.newHashMap();
            HashSet needShowTipInfo = Sets.newHashSet();
            if (GenericsUtils.notNullAndEmpty((Object)findAllOrgStudentSigupStatistics)) {
                for (OrgStudentSignupStatistics next : findAllOrgStudentSigupStatistics) {
                    if (!next.isInfoFillOver()) {
                        needShowTipInfo.add(next.getUserId());
                    }
                    long l = next.getUserId();
                    long courseId = next.getCourseId();
                    String key = this.createKey(l, courseId);
                    Long refundMoney = null;
                    refundMoney = (Long)sumRefundMoney.get(key);
                    if (refundMoney == null) continue;
                    Long retMoney = next.getPayMoney() - refundMoney;
                    next.setPayMoney(Long.valueOf(retMoney < 0L ? 0L : retMoney));
                }
                orgStudentSigupStatisticsMap = GenericsUtils.toFieldListMap((Collection)findAllOrgStudentSigupStatistics, (String[])new String[]{"userId"});
            }
            Map kexiaoStaisticsMap = Maps.newHashMap();
            if (GenericsUtils.notNullAndEmpty((Object)findKexiaoStatistics)) {
                kexiaoStaisticsMap = GenericsUtils.toFieldListMap((Collection)findKexiaoStatistics, (String[])new String[]{"userId"});
            }
            for (KexiaoStatisticsSuper kexiaoStatisticsSuper : studentRequest) {
                Long userId = kexiaoStatisticsSuper.getUserId();
                boolean hasStudentCourse = true;
                if (fillInfoType == 1) {
                    StudentClassHourStatusDocument studentClassHourStatusDocument = null;
                    studentClassHourStatusDocument = (StudentClassHourStatusDocument)studentClassHourStatusDocumentMap.get(userId);
                    hasStudentCourse = studentClassHourStatusDocument != null;
                }
                List ossSignupInfo = (List)orgStudentSigupStatisticsMap.get(userId);
                List ossKexiaoInfo = (List)kexiaoStaisticsMap.get(userId);
                if (hasStudentCourse && needShowTipInfo.contains(userId)) {
                    kexiaoStatisticsSuper.setKexiaoInfoFillStatus(0);
                }
                if (!hasStudentCourse || hasStudentCourse && GenericsUtils.isNullOrEmpty((Object)ossSignupInfo)) {
                    kexiaoStatisticsSuper.setCanShowTotalKexiaoInfo(true);
                }
                this.countKexiaoStatistics(kexiaoStatisticsSuper, courseIds, one2OneCourseIdMap, studentClassHourMap, ossSignupInfo, ossKexiaoInfo, fillInfoType);
            }
        }
        catch (Exception e) {
            log.error("exception is : {} ", (Throwable)e);
        }
    }

    private String createKey(long userId, long courseId) {
        String key = String.format("%s_%s", userId, courseId);
        return key;
    }

    private Map<String, StudentClassHour> buildStudentClassHourInfo(List<StudentClasHourDocument> list) {
        HashMap studentClassHourMapSecond = Maps.newHashMap();
        for (StudentClasHourDocument document : list) {
            StudentClassHour classHour = this.buildStudentClassHour(document);
            Long userId = classHour.getUserId();
            Long courseId = classHour.getCourseId();
            String key = userId + "_" + courseId;
            studentClassHourMapSecond.put(key, classHour);
        }
        return studentClassHourMapSecond;
    }

    private List<StudentClasHourDocument> searchStudentClasHourDocuments(Set<Long> userIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        List ret = this.orgStudentLessonDao.queryStudentClassHours(userIds, orgId);
        return ret;
    }

    private List<StudentClassHourStatusDocument> searchStudentClassHourStatusDocuments(Set<Long> studentIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        return this.orgStudentCourseDao.searchStudentClassHourStatus(studentIds, orgId);
    }

    private Map<String, StudentClass> buildStudentClassStatusInfo(List<StudentClassHourStatusDocument> studentClassHourStatusDocumentLists) {
        HashMap statusMap = Maps.newHashMap();
        for (StudentClassHourStatusDocument next : studentClassHourStatusDocumentLists) {
            Long userId = next.getUserId();
            Long courseId = next.getCourseId();
            Integer lessonCount = next.getLessonCount();
            StudentClass studentClass = new StudentClass();
            String key = userId + "_" + courseId;
            Integer status = next.getStatus();
            studentClass.setStatus(status.intValue());
            studentClass.setContractCount(lessonCount == null ? 0 : lessonCount);
            studentClass.setUserId(userId.longValue());
            studentClass.setCourseId(courseId.longValue());
            statusMap.put(key, studentClass);
        }
        log.debug("statusMap is :{}", (Object)statusMap);
        return statusMap;
    }

    private void countKexiaoStatistics(KexiaoStatisticsSuper oss, Set<Long> courseIdsSuper, Map<Long, Long> one2OneCourseIdMap, Map<String, StudentClassHour> studentClassHourMap, List<OrgStudentSignupStatistics> ossSignupInfo, List<KexiaoStatisticss> ossKexiaoInfo, Integer fillInfoType) {
        Map signupStatisticsMap = GenericsUtils.toFieldMap(ossSignupInfo, (String[])new String[]{"courseId"});
        Map kexiaoStatisticssMap = GenericsUtils.toFieldMap(ossKexiaoInfo, (String[])new String[]{"courseId"});
        HashSet courseIds = Sets.newHashSet();
        boolean singleCourse = false;
        if (oss.getCourseId() != null) {
            courseIds.add(oss.getCourseId());
            singleCourse = true;
        } else {
            courseIds.addAll(courseIdsSuper);
            if (GenericsUtils.notNullAndEmpty(one2OneCourseIdMap)) {
                courseIds.addAll(one2OneCourseIdMap.keySet());
                courseIds.removeAll(one2OneCourseIdMap.values());
            }
        }
        Long remainTuition = null;
        for (Long courseId : courseIds) {
            boolean canSetInfo = true;
            String key = String.format("%s_%s", oss.getUserId(), courseId);
            StudentClassHour sch = studentClassHourMap.get(key);
            if (sch == null) continue;
            if (sch.isArrange()) {
                oss.setHasLesson(true);
            }
            int status = sch.getStatus();
            OrgStudentSignupStatistics orgStudentSigupStatistics = null;
            KexiaoStatisticss kexiaoStatisticss = null;
            if (one2OneCourseIdMap.containsKey(courseId)) {
                Long parentCourseId = one2OneCourseIdMap.get(courseId);
                orgStudentSigupStatistics = (OrgStudentSignupStatistics)signupStatisticsMap.get(parentCourseId);
                kexiaoStatisticss = (KexiaoStatisticss)kexiaoStatisticssMap.get(parentCourseId);
            } else {
                orgStudentSigupStatistics = (OrgStudentSignupStatistics)signupStatisticsMap.get(courseId);
                kexiaoStatisticss = (KexiaoStatisticss)kexiaoStatisticssMap.get(courseId);
            }
            Long signupMoney = null;
            if (orgStudentSigupStatistics != null) {
                if (!orgStudentSigupStatistics.isInfoFillOver()) {
                    canSetInfo = false;
                } else {
                    signupMoney = orgStudentSigupStatistics.getPayMoney();
                }
            } else {
                oss.setHasSignupCourseRecord(false);
            }
            if (canSetInfo) {
                oss.setCanShowTotalKexiaoInfo(true);
            }
            if (fillInfoType == 1 && status != StudentCourseStatus.NORMAL.getCode()) {
                log.info("current course was not a inStudying course , so will skip :{} ", (Object)courseId);
                continue;
            }
            oss.setCurrentCourseCanSetInfo(canSetInfo);
            Long kexiaoMoney = 0L;
            if (canSetInfo) {
                oss.setCanShowTotalKexiaoInfo(true);
                if (signupMoney != null) {
                    if (status == StudentCourseStatus.NORMAL.getCode()) {
                        if (kexiaoStatisticss != null && kexiaoStatisticss.getKexiaoMoney() != null) {
                            kexiaoMoney = kexiaoStatisticss.getKexiaoMoney();
                        }
                    } else {
                        kexiaoMoney = signupMoney;
                    }
                } else {
                    signupMoney = 0L;
                }
                remainTuition = remainTuition == null ? 0L : remainTuition;
                remainTuition = remainTuition + (signupMoney - kexiaoMoney);
            }
            if (!singleCourse) continue;
            oss.setOrgStudentCourseStatus(status);
            this.setClassHourInfos(oss, sch, canSetInfo, fillInfoType);
        }
        if (remainTuition != null) {
            oss.setRemainTuition(StudentKexiaoStatisticsApiServiceImpl.countRemainTuition(remainTuition));
            oss.setRemainTuitionValue(remainTuition);
        }
    }

    private void setClassHourInfos(KexiaoStatisticsSuper oss, StudentClassHour dto, boolean canSetInfo, Integer fillInfoType) {
        Integer totalCount = dto.getTotalCount();
        Integer finishCount = dto.getFinishCount();
        Integer buyCount = dto.getContractCount();
        oss.setBuyCount(buyCount == null ? 0 : buyCount);
        Long totalArrangeClassHour = dto.getTotalClassHour();
        Long totalKexiaoClassHour = dto.getTotalKexiaoClassHour();
        Integer leftCount = totalCount - finishCount;
        if (fillInfoType == 3) {
            totalCount = buyCount;
        }
        oss.setChargeUnitType(dto.getChargeUnit());
        if (dto.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode() || dto.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode() || dto.getChargeUnit().intValue() == ChargeUnit.BY_MINUTE.getCode()) {
            long countClassHour;
            long l = countClassHour = buyCount == null ? 0L : (long)buyCount.intValue();
            if (totalArrangeClassHour == null || totalArrangeClassHour == 0L || totalArrangeClassHour < countClassHour) {
                totalArrangeClassHour = countClassHour;
            }
            if (totalKexiaoClassHour == null) {
                oss.setFinishClassTimesForKexiao("0");
                oss.setFinishClassTimesForKexiaoValue(0);
            } else {
                oss.setFinishClassTimesForKexiao(StudentKexiaoStatisticsApiServiceImpl.countTime(totalKexiaoClassHour));
                oss.setFinishClassTimesForKexiaoValue(totalKexiaoClassHour.intValue());
            }
            leftCount = (int)(totalArrangeClassHour - (long)oss.getFinishClassTimesForKexiaoValue().intValue());
            oss.setTotalClassTimesForKexiaoValue(fillInfoType == 3 ? (int)countClassHour : totalArrangeClassHour.intValue());
            oss.setLeftClassTimesForKexiaoValue(leftCount);
            if (canSetInfo) {
                oss.setTotalClassTimesForKexiao(StudentKexiaoStatisticsApiServiceImpl.countTime(oss.getTotalClassTimesForKexiaoValue().longValue()));
                oss.setLeftClassTimesForKexiao(StudentKexiaoStatisticsApiServiceImpl.countTime(leftCount.longValue()));
            } else {
                oss.setTotalClassTimesForKexiao("--");
                oss.setLeftClassTimesForKexiao("--");
            }
        } else {
            oss.setFinishClassTimesForKexiao(String.valueOf(finishCount));
            oss.setFinishClassTimesForKexiaoValue(finishCount);
            oss.setTotalClassTimesForKexiaoValue(totalCount);
            oss.setLeftClassTimesForKexiaoValue(leftCount);
            if (canSetInfo) {
                oss.setTotalClassTimesForKexiao(String.valueOf(totalCount));
                oss.setLeftClassTimesForKexiao(String.valueOf(leftCount));
            } else {
                oss.setTotalClassTimesForKexiao("--");
                oss.setLeftClassTimesForKexiao("--");
            }
        }
    }

    public static void main(String[] args) {
        String countTime = StudentKexiaoStatisticsApiServiceImpl.countTime(2L);
        System.out.println(countTime);
    }

    public static String countTime(Long time) {
        BigDecimal b1 = new BigDecimal(time);
        BigDecimal b2 = new BigDecimal(60);
        return b1.divide(b2, 1, 4).toPlainString();
    }

    public static String countRemainTuition(Long remainTuition) {
        BigDecimal b1 = new BigDecimal(remainTuition);
        BigDecimal b2 = new BigDecimal(100);
        return b1.divide(b2, 2, 4).toPlainString();
    }

    public static long countClassHour(int count, int chargeUnit) {
        return count;
    }

    public Map<String, StudentClassHour> findStudentClassHours(Map<String, StudentClassHour> map, Map<String, StudentClass> statusMap, Map<Long, OrgCourse> coursesMap) {
        for (Map.Entry<String, StudentClass> entry : statusMap.entrySet()) {
            String key = entry.getKey();
            StudentClass sc = entry.getValue();
            Long courseId = sc.getCourseId();
            StudentClassHour sch = map.get(key);
            if (sch == null) {
                sch = new StudentClassHour();
                sch.setTotalCount(Integer.valueOf(sc.getContractCount()));
                sch.setLeftCount(Integer.valueOf(sc.getContractCount()));
                sch.setFinishCount(Integer.valueOf(0));
                sch.setArrange(false);
            } else if (sc.getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                sch.setTotalCount(sch.getFinishCount());
            } else {
                sch.setTotalCount(Integer.valueOf(Math.max(sc.getContractCount(), sch.getTotalCount())));
            }
            sch.setStatus(sc.getStatus());
            sch.setContractCount(sc.getContractCount());
            OrgCourse courseInfo = coursesMap.get(courseId);
            if (courseInfo != null) {
                sch.setChargeType(courseInfo.getChargeType());
                sch.setChargeUnit(courseInfo.getChargeUnit());
            }
            map.put(key, sch);
        }
        return map;
    }

    private StudentClassHour buildStudentClassHour(StudentClasHourDocument document) {
        Long studentId = document.getUserId();
        Long courseId = document.getCourseId();
        Long totalCount = document.getTotal();
        Long finishCount = document.getFinished();
        Long totalClassHourMinute = document.getTotalArrangeTime();
        Long totalKexiaoTime = document.getKexiaoTime();
        totalCount = totalCount == null ? 0L : totalCount;
        finishCount = finishCount == null ? 0L : finishCount;
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentId.longValue());
        classHour.setCourseId(courseId.longValue());
        classHour.setFinishCount(Integer.valueOf(finishCount.intValue()));
        classHour.setTotalCount(Integer.valueOf(totalCount.intValue()));
        classHour.setTotalClassHour(totalClassHourMinute);
        classHour.setTotalKexiaoClassHour(totalKexiaoTime);
        return classHour;
    }
}

