/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.common.dto.PointsExchangeRecordDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PointsMsgServiceImpl
implements PointsMsgService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PointsMsgServiceImpl.class);
    private CloudQueue pointMsgQueue;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public void pointsMessage(ProducePointType producePointType, Long keyId, Long orgId, Long userId, Long money, Integer pointsType) {
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        if (orgStudent != null) {
            PointsExchangeRecordDto object = new PointsExchangeRecordDto();
            object.setUniqRemark(producePointType.getTableName() + "_" + keyId);
            object.setOrgId(orgId);
            object.setStudentId(orgStudent.getId());
            object.setStudentName(orgStudent.getName());
            object.setMobile(orgStudent.getMobile());
            object.setMoney(money.doubleValue() / 100.0);
            object.setPointsType(pointsType);
            object.setRemark(producePointType.getLabel());
            try {
                Message message = this.pointMsgQueue.putMessage(new Message(JacksonUtil.obj2Str((Object)object)));
                log.info("potint message result = {},{}", (Object)message, (Object)JacksonUtil.obj2Str((Object)object));
            }
            catch (Exception e) {
                log.warn("point message error ={}", (Object)e.getMessage());
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.pointMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("points.msg.queue"));
        }
        catch (Exception e) {
            log.warn("init cloud account :" + e);
        }
    }
}

