/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.ClassOrderCompleteStatus;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constant.TransferClassStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.common.impl.KexiaoStatisticsBuilder;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KexiaoApiServiceImpl
implements KexiaoApiService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoApiServiceImpl.class);
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgSignupRefundDao refundDao;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private TxTransferClassRecordDao transferClassRecordDao;
    @Autowired
    private TxTransferClassInfoDao transferClassInfoDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentcourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    private static final Date SUPPORT_TIME = DateUtil.getStrToDate((String)"yyyy-MM-dd mm:HH:ss", (String)"2017-06-01 00:00:00");

    @Override
    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        if (sign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", (Object)sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        }
        return LessonStatus.UN_START;
    }

    @Override
    public String getLeftAmountStr(KexiaoStatistics stat) {
        String remainTuition = "0.00";
        if (stat != null) {
            remainTuition = stat.getCompleteStatus() != 0 ? "--" : NumberUtil.convertFenToYuan((long)stat.getLeftAmount());
        }
        return remainTuition;
    }

    @Override
    public void setStudentLessonKexiaoStatus(Collection<OrgStudentLesson> studentLessons) {
        HashSet<Long> classIds = new HashSet<Long>();
        for (OrgStudentLesson lesson : studentLessons) {
            classIds.add(lesson.getCourseId());
        }
        HashSet<OrgStudentLesson> signKexiaoLessons = new HashSet<OrgStudentLesson>();
        HashSet<OrgStudentLesson> timeKexiaoLessons = new HashSet<OrgStudentLesson>();
        Map<Long, OrgCourseConsumeRule> consumeRuleMap = this.courseApiService.getClassRule(classIds);
        for (OrgStudentLesson lesson : studentLessons) {
            OrgCourseConsumeRule rule = consumeRuleMap.get(lesson.getCourseId());
            if (rule == null || rule.getRuleValue() == 0) {
                timeKexiaoLessons.add(lesson);
                continue;
            }
            signKexiaoLessons.add(lesson);
        }
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED;
    }

    @Override
    public Map<Long, KexiaoStudentStat> queryUserKexiaoStat(Long orgId, Collection<Long> userIds) {
        HashMap<Long, KexiaoStudentStat> ret = new HashMap<Long, KexiaoStudentStat>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        List studentCourseList = this.studentcourseDao.listByUserIds(orgId, userIds, null);
        ArrayList<OrgSignupCourse> signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, (Collection)SignupCourseStatus.PAY_SUCCESS);
        if (signupCourseList == null || signupCourseList.isEmpty()) {
            signupCourseList = new ArrayList<OrgSignupCourse>();
        }
        HashSet<String> userCourseSet = new HashSet<String>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            userCourseSet.add(signupCourse.getUserId() + "_" + signupCourse.getClassId());
        }
        for (Object studentCourse : studentCourseList) {
            int index = 0;
            if (userCourseSet.contains(studentCourse.getUserId() + "_" + studentCourse.getCourseId())) continue;
            if (studentCourse.getStatus() != 0) {
                OrgSignupCourse signupCourse = new OrgSignupCourse();
                signupCourse.setLessonCount(Integer.valueOf(0));
                signupCourse.setSignupPurchaseId(Long.valueOf(this.generatePurchaseId(index++)));
                signupCourse.setOrgCourseId(studentCourse.getRealCourseId());
                signupCourse.setClassId(studentCourse.getCourseId());
                signupCourse.setUserId(studentCourse.getUserId());
                signupCourse.setChargeUnit(studentCourse.getChargeUnit());
                signupCourse.setOrgId(orgId);
                signupCourse.setUpdateTime(studentCourse.getCreateTime());
                signupCourse.setStatus(Integer.valueOf(6));
                signupCourseList.add(signupCourse);
                log.info("[Kexiao] create signupCourse={}", (Object)signupCourse);
                continue;
            }
            log.warn("[Kexiao] student course not exist order.studentCourse={}", studentCourse);
        }
        HashMap<String, OrgSignupCourse> signupCourseMap = new HashMap<String, OrgSignupCourse>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = this.getUniqueId(signupCourse);
            signupCourseMap.put(key, signupCourse);
        }
        HashMap<String, Integer> userCourseCompleteStatusMap = new HashMap<String, Integer>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = this.getKey(signupCourse.getUserId(), signupCourse.getClassId());
            Integer status = (Integer)userCourseCompleteStatusMap.get(key);
            if (status == null) {
                status = this.isComputable(signupCourse) ? Integer.valueOf(0) : Integer.valueOf(1);
                userCourseCompleteStatusMap.put(key, status);
                continue;
            }
            if (this.isComputable(signupCourse)) continue;
            userCourseCompleteStatusMap.put(key, 1);
        }
        for (OrgSignupCourse signupCourse : signupCourseList) {
            Object stat = (KexiaoStudentStat)ret.get(signupCourse.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ((KexiaoStatistics)stat).setUserId(signupCourse.getUserId());
                ((KexiaoStatistics)stat).setCompleteStatus(0);
                ret.put(signupCourse.getUserId(), (KexiaoStudentStat)stat);
            }
            String key = this.getKey(signupCourse.getUserId(), signupCourse.getClassId());
            ((KexiaoStatistics)stat).setCompleteStatus((Integer)userCourseCompleteStatusMap.get(key));
            this.addBuyData(signupCourse, (KexiaoStatistics)stat);
            ((KexiaoStudentStat)stat).splitContractNumber(signupCourse);
        }
        Set keySet = userCourseCompleteStatusMap.keySet();
        if (keySet != null) {
            HashSet<Long> unCompleteUsers = new HashSet<Long>();
            for (String key : keySet) {
                long userId = Long.parseLong(key.split("_")[0]);
                if ((Integer)userCourseCompleteStatusMap.get(key) == 0) continue;
                unCompleteUsers.add(userId);
            }
            for (Object stat : ret.values()) {
                if (unCompleteUsers.contains(((KexiaoStatistics)stat).getUserId())) {
                    ((KexiaoStatistics)stat).setCompleteStatus(1);
                    continue;
                }
                ((KexiaoStatistics)stat).setCompleteStatus(0);
            }
        }
        log.info("[Kexiao] result={},userCourseCompleteStatusMap={}", ret, userCourseCompleteStatusMap);
        List courseLessons = this.signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, null);
        HashMap<Long, ArrayList<OrgSignupCourseLesson>> lessonMap = new HashMap<Long, ArrayList<OrgSignupCourseLesson>>();
        for (OrgSignupCourseLesson lesson : courseLessons) {
            ArrayList<OrgSignupCourseLesson> list;
            Object stat = (KexiaoStudentStat)ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ((KexiaoStatistics)stat).setUserId(lesson.getUserId());
                ret.put(lesson.getUserId(), (KexiaoStudentStat)stat);
            }
            if ((list = (ArrayList<OrgSignupCourseLesson>)lessonMap.get(lesson.getSignupCourseId())) == null) {
                list = new ArrayList<OrgSignupCourseLesson>();
                lessonMap.put(lesson.getSignupCourseId(), list);
            }
            list.add(lesson);
            this.addKexiaoData(lesson, (KexiaoStatistics)stat);
            if (((KexiaoStatistics)stat).getCompleteStatus() != 0) continue;
            ((KexiaoStudentStat)stat).splitKexiaoNumber(lesson);
        }
        log.info("[Kexiao] result={}", ret);
        List<OrgSignupRefund> refundList = this.refundDao.listOrderByUserIds(orgId, userIds);
        log.info("[Kexiao] Refund list={}", (Object)refundList);
        Map<Long, OrgSignupRefund> refundMap = this.createRefundRecord(orgId, signupCourseList, refundList);
        if (refundMap != null && refundMap.size() > 0) {
            if (refundList == null || refundList.isEmpty()) {
                refundList = new ArrayList<OrgSignupRefund>();
            }
            refundList.addAll(refundMap.values());
        }
        refundList = this.mergeRefund(refundList);
        log.info("[Kexiao] Refund list={}", refundList);
        log.info("[Kexiao] signupCourseMap={},courseLessonMap={}", signupCourseMap, lessonMap);
        for (OrgSignupRefund refund : refundList) {
            OrgSignupCourse signupCourse = (OrgSignupCourse)signupCourseMap.get(this.getUniqueId(refund));
            List lessons = null;
            log.info("[Kexiao] Refund signupCourse={}", (Object)signupCourse);
            if (signupCourse != null && signupCourse.getId() != null && signupCourse.getId() > 0L) {
                lessons = (List)lessonMap.get(signupCourse.getId());
            }
            if (signupCourse != null && this.isHistoryRefund(refund) && this.isRefunded(signupCourse.getStatus())) {
                this.handleHistoryRefundData(refund, signupCourse, lessons);
                continue;
            }
            log.info("No need handle.signupCourse={}", (Object)signupCourse);
        }
        log.info("[Kexiao] Refund list={},signupCourseMap={}", refundList, signupCourseMap);
        for (OrgSignupRefund refund : refundList) {
            Object stat = (KexiaoStudentStat)ret.get(refund.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ((KexiaoStatistics)stat).setUserId(refund.getUserId());
                ret.put(refund.getUserId(), (KexiaoStudentStat)stat);
            }
            OrgSignupCourse signupCourse = (OrgSignupCourse)signupCourseMap.get(this.getUniqueId(refund));
            log.info("[Kexiao] Refund purchaseId={}", (Object)refund.getSignupPurchaseId());
            if (signupCourse == null) continue;
            String key = this.getKey(signupCourse.getUserId(), signupCourse.getClassId());
            this.addRefundData(refund, (KexiaoStatistics)stat, (Integer)userCourseCompleteStatusMap.get(key));
            if (((KexiaoStatistics)stat).getCompleteStatus() != 0) continue;
            ((KexiaoStudentStat)stat).splitRefundNumber(refund);
        }
        log.info("[Kexiao] result={}", ret);
        Map<Long, List<TxTransferClassRecord>> recordListMap = this.getTxTransferClassRecordList(userIds);
        Set<Long> userIdSet = recordListMap.keySet();
        for (Long userId : userIdSet) {
            List<TxTransferClassRecord> list;
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(userId);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(userId);
                ret.put(userId, stat);
            }
            if ((list = recordListMap.get(userId)) == null || list.size() <= 0) continue;
            for (TxTransferClassRecord record : list) {
                this.addTransferData(record, (KexiaoStatistics)stat);
                if (stat.getCompleteStatus() != 0) continue;
                stat.splitTransferNumber(record);
            }
        }
        log.info("[Kexiao] result={}", ret);
        List lessons = this.studentLessonDao.listByUserIdsAndLessonType(orgId.longValue(), userIds, Arrays.asList(-1), new String[]{"id", "userId", "courseId", "kexiaoStatus"});
        for (OrgStudentLesson lesson : lessons) {
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setUserId(lesson.getUserId());
                ret.put(lesson.getUserId(), stat);
            }
            if (lesson.getKexiaoStatus() == 1) {
                stat.setKexiaoNormalCount(stat.getKexiaoNormalCount() + 1L);
            }
            stat.setArrangeNormalCount(stat.getArrangeNormalCount() + 1L);
        }
        log.info("[Kexiao] result={}", ret);
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userIds, ret});
        return ret;
    }

    private boolean isHistoryRefund(OrgSignupRefund refund) {
        return refund.getCreateTime().compareTo(SUPPORT_TIME) < 0 && refund.getRefundLessonCount() < 1L;
    }

    private String getUniqueId(OrgSignupCourse signupCourse) {
        return signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
    }

    private String getUniqueId(OrgSignupRefund refund) {
        return refund.getSignupPurchaseId() + "_" + refund.getClassId();
    }

    private long generatePurchaseId(int index) {
        return System.currentTimeMillis() * 10L + (long)index;
    }

    private boolean isComputable(OrgSignupCourse signupCourse) {
        return signupCourse.getLessonCount() > 0 || signupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode() || signupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_PURCHASE.getCode();
    }

    public Map<Long, OrgSignupRefund> createRefundRecord(long orgId, List<OrgSignupCourse> signupCourseList, List<OrgSignupRefund> refundList) {
        log.debug("[Kexiao] Create refund record.signupCourseList={}", signupCourseList);
        HashMap<Long, OrgSignupRefund> ret = new HashMap<Long, OrgSignupRefund>();
        if (signupCourseList == null || signupCourseList.size() < 1) {
            return ret;
        }
        HashSet<Long> classIds = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<String> keySet = new HashSet<String>();
        for (OrgSignupCourse course : signupCourseList) {
            classIds.add(course.getClassId());
            userIds.add(course.getUserId());
            keySet.add(course.getUserId() + "_" + course.getClassId());
        }
        log.info("[Kexiao] create refund record.classIds={},userIds={},keySet={}", new Object[]{classIds, userIds, keySet});
        if (classIds.isEmpty()) {
            log.info("[Kexiao] not need to handle");
            return ret;
        }
        HashSet<String> refundPurchaseIds = new HashSet<String>();
        for (OrgSignupRefund refund : refundList) {
            refundPurchaseIds.add(this.getUniqueId(refund));
        }
        for (OrgSignupCourse course : signupCourseList) {
            if (!this.isRefunded(course.getStatus()) || refundPurchaseIds.contains(this.getUniqueId(course))) continue;
            OrgSignupRefund refund = new OrgSignupRefund();
            refund.setCreateTime(course.getUpdateTime() == null ? course.getCreateTime() : course.getUpdateTime());
            refund.setSignupPurchaseId(course.getSignupPurchaseId());
            refund.setRefundLessonCount(Long.valueOf(0L));
            refund.setRefundFee(course.getTotalPayPrice());
            refund.setClassId(course.getClassId());
            refund.setCourseId(course.getOrgCourseId());
            refund.setChargeUnit(course.getChargeUnit());
            refund.setUserId(course.getUserId());
            refund.setOrgId(course.getOrgId());
            refund.setKexiaoMoney(Long.valueOf(0L));
            refund.setKexiaoCount(Long.valueOf(0L));
            ret.put(course.getId(), refund);
        }
        return ret;
    }

    @Override
    public Map<String, KexiaoStatistics> queryClassKexiaoStatByUserIds(Long orgId, Collection<Long> userIds) {
        HashMap<String, KexiaoStatistics> ret = new HashMap<String, KexiaoStatistics>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        List signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, (Collection)SignupCourseStatus.PAY_SUCCESS);
        for (Object signupCourse : signupCourseList) {
            String key = this.getKey(signupCourse.getUserId(), signupCourse.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStatistics();
                stat.setCompleteStatus(0);
                ret.put(key, stat);
            }
            if (!this.isComputable((OrgSignupCourse)signupCourse)) {
                stat.setCompleteStatus(1);
            }
            this.addBuyData((OrgSignupCourse)signupCourse, stat);
        }
        HashMap<String, OrgSignupCourse> signupCourseMap = new HashMap<String, OrgSignupCourse>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = this.getUniqueId(signupCourse);
            signupCourseMap.put(key, signupCourse);
        }
        List courseLessons = this.signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, null);
        HashMap<Long, ArrayList<Object>> lessonsMap = new HashMap<Long, ArrayList<Object>>();
        for (Object lesson : courseLessons) {
            String key = this.getKey(lesson.getUserId(), lesson.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            this.addKexiaoData((OrgSignupCourseLesson)lesson, stat);
            if (lesson.getSignupCourseId() <= 0L) continue;
            ArrayList<Object> lessonList = (ArrayList<Object>)lessonsMap.get(lesson.getSignupCourseId());
            if (lessonList == null) {
                lessonList = new ArrayList<Object>();
                lessonsMap.put(lesson.getSignupCourseId(), lessonList);
            }
            lessonList.add(lesson);
        }
        List<OrgSignupRefund> refundList = this.refundDao.listOrderByUserIds(orgId, userIds);
        refundList = this.mergeRefund(refundList);
        for (OrgSignupRefund refund : refundList) {
            OrgSignupCourse signupCourse;
            if (!this.isHistoryRefund(refund) || (signupCourse = (OrgSignupCourse)signupCourseMap.get(this.getUniqueId(refund))) == null || !this.isRefunded(signupCourse.getStatus())) continue;
            this.handleHistoryRefundData(refund, signupCourse, (List)lessonsMap.get(signupCourse.getId()));
        }
        for (OrgSignupRefund refund : refundList) {
            String key = this.getKey(refund.getUserId(), refund.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            log.debug("[KexiaoStatistics] statistics={}", (Object)stat);
            this.addRefundData(refund, stat, stat.getCompleteStatus());
        }
        Map<Long, List<TxTransferClassRecord>> recordListMap = this.getTxTransferClassRecordList(userIds);
        Set<Long> keySet = recordListMap.keySet();
        for (Long userId : keySet) {
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list == null || list.size() <= 0) continue;
            for (TxTransferClassRecord record : list) {
                String key = this.getKey(record.getTransferOutUserId(), record.getTransferOutClassId());
                KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
                if (stat == null) {
                    stat = new KexiaoStudentStat();
                    ret.put(key, stat);
                }
                this.addTransferData(record, stat);
            }
        }
        List lessons = this.studentLessonDao.listByUserIdsAndLessonType(orgId.longValue(), userIds, Arrays.asList(-1), new String[]{"id", "userId", "courseId", "kexiaoStatus"});
        for (OrgStudentLesson lesson : lessons) {
            String key = this.getKey(lesson.getUserId(), lesson.getCourseId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            if (lesson.getKexiaoStatus() == 1) {
                stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + 1L);
            }
            stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + 1L);
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userIds, ret});
        return ret;
    }

    private String getKey(long userId, long classId) {
        return userId + "_" + classId;
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIds(userIds, status);
        return this.getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds, Long classId) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIdsAndClassId(userIds, classId, status);
        return this.getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getUserIdToRecordListMap(List<TxTransferClassInfo> transferClassInfos) {
        HashMap<Long, List<TxTransferClassRecord>> ret = new HashMap<Long, List<TxTransferClassRecord>>();
        Map numberMap = CollectionHelper.toKeyMap(transferClassInfos, (String)"transferNumber");
        List transferNumbers = ListUtil.toKeyList(transferClassInfos, (String)"transferNumber", TxTransferClassInfo.class);
        List recordList = new ArrayList();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = this.transferClassRecordDao.listByTransferNumbers((Collection)transferNumbers);
        }
        for (TxTransferClassRecord record : recordList) {
            long number = record.getTransferNumber();
            TxTransferClassInfo classInfo = (TxTransferClassInfo)numberMap.get(number);
            ArrayList<TxTransferClassRecord> list = (ArrayList<TxTransferClassRecord>)ret.get(classInfo.getUserId());
            if (list == null) {
                list = new ArrayList<TxTransferClassRecord>();
                ret.put(classInfo.getUserId(), list);
            }
            list.add(record);
        }
        return ret;
    }

    private void addBuyData(OrgSignupCourse signupCourse, KexiaoStatistics stat) {
        log.info("[Kexiao] signupCourse={},KexiaoStatistics={}", (Object)signupCourse, (Object)stat);
        if (stat.getCompleteStatus() == 0) {
            stat.setContractAmount(stat.getContractAmount() + signupCourse.getTotalPayPrice());
            stat.setContractNumber(stat.getContractNumber() + (long)KexiaoUtil.getClassNumber(signupCourse));
        }
    }

    private void addKexiaoData(OrgSignupCourseLesson lesson, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            if (lesson.getLessonType().intValue() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoNormalAmount(stat.getKexiaoNormalAmount() + lesson.getAmount());
                    stat.setKexiaoNormalNumber(stat.getKexiaoNormalNumber() + (long)this.getLessonNumber(lesson));
                }
                stat.setArrangeNormalAmount(stat.getArrangeNormalAmount() + lesson.getAmount());
                stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType().intValue() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + (long)this.getLessonNumber(lesson));
                }
                stat.setArrangeFreeNumber(stat.getArrangeFreeNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType().intValue() == LessonType.CANCEL.getCode()) {
                stat.setCancelNormalNumber(stat.getCancelNormalNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType().intValue() == LessonType.FREE_CANCEL.getCode()) {
                stat.setCancelFreeNumber(stat.getCancelFreeNumber() + (long)this.getLessonNumber(lesson));
            }
        }
    }

    private int getLessonNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime((int)lesson.getChargeUnit())) {
            return lesson.getLessonDuration();
        }
        return 1;
    }

    private void addRefundData(OrgSignupRefund refund, KexiaoStatistics stat, int completeStatus) {
        if (completeStatus == 0) {
            stat.setRefundAmount(stat.getRefundAmount() + refund.getRefundFee() + refund.getRefundPrice());
            stat.setRefundNormalNumber(stat.getRefundNormalNumber() + (long)refund.getRefundLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassInfo info, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + info.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + (long)info.getLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassRecord record, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + (long)record.getLessonMoney().intValue());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + (long)record.getRealLessonCount().intValue());
            stat.setTransferFreeNumber(stat.getTransferFreeNumber() + (long)record.getFreeLessonCount().intValue());
        }
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIds(Long orgId, Collection<Long> classIds) {
        Map<Long, Long> classIdToCourseId = this.courseApiService.mapClassIdToCourseId(classIds);
        List signupCourseList = this.signupCourseDao.getByCourseIdsAndStudentIds(orgId, null, classIdToCourseId.values(), null, new String[0]);
        Map<Long, KexiaoSignupCourseStat> statMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);
        HashMap<Long, KexiaoStatistics> ret = new HashMap<Long, KexiaoStatistics>();
        Set<Long> keySet = statMap.keySet();
        for (Long id : keySet) {
            KexiaoSignupCourseStat stat = statMap.get(id);
            log.debug("[KexiaoSignupCourseStat] KexiaoSignupCourseStat={}", (Object)stat);
            KexiaoStatistics existStat = (KexiaoStatistics)ret.get(stat.getClassId());
            if (existStat == null) {
                existStat = new KexiaoStatistics();
                BeanUtils.copyProperties((Object)stat, (Object)existStat);
                ret.put(stat.getClassId(), existStat);
                continue;
            }
            existStat.setContractNumber(existStat.getContractNumber() + stat.getContractNumber());
            existStat.setContractAmount(existStat.getContractAmount() + stat.getContractAmount());
            existStat.setArrangeNormalNumber(existStat.getArrangeNormalNumber() + stat.getArrangeNormalNumber());
            existStat.setArrangeNormalAmount(existStat.getArrangeNormalAmount() + stat.getArrangeNormalAmount());
            existStat.setArrangeFreeNumber(existStat.getArrangeFreeNumber() + stat.getArrangeFreeNumber());
            existStat.setCancelNormalNumber(existStat.getCancelNormalNumber() + stat.getCancelNormalNumber());
            existStat.setCancelFreeNumber(existStat.getCancelFreeNumber() + stat.getCancelFreeNumber());
            existStat.setRefundAmount(existStat.getRefundAmount() + stat.getRefundAmount());
            existStat.setRefundNormalNumber(existStat.getRefundNormalNumber() + stat.getRefundNormalNumber());
            existStat.setRefundFreeNumber(existStat.getRefundFreeNumber() + stat.getRefundFreeNumber());
            existStat.setTransferAmount(existStat.getTransferAmount() + stat.getTransferAmount());
            existStat.setTransferNormalNumber(existStat.getTransferNormalNumber() + stat.getTransferNormalNumber());
            existStat.setTransferFreeNumber(existStat.getTransferFreeNumber() + stat.getTransferFreeNumber());
            existStat.setKexiaoNormalNumber(existStat.getKexiaoNormalNumber() + stat.getKexiaoNormalNumber());
            existStat.setKexiaoNormalAmount(existStat.getKexiaoNormalAmount() + stat.getKexiaoNormalAmount());
            existStat.setKexiaoFreeNumber(existStat.getKexiaoFreeNumber() + stat.getKexiaoFreeNumber());
        }
        return ret;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentCourse(long orgId, long userId, long courseId) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        OrgStudentCourse studentCourse = this.studentcourseDao.getStudentCourseByRealCourseId(Long.valueOf(orgId), Long.valueOf(courseId), Long.valueOf(userId));
        if (studentCourse != null) {
            statistics = this.queryKexiaoStatByStudentClass(orgId, userId, studentCourse.getCourseId());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userId, courseId, statistics});
        return statistics;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentClass(long orgId, long userId, long classId) {
        OrgStudentCourse studentCourse;
        Long courseId = classId;
        OrgCourse course = (OrgCourse)this.courseDao.getById((Serializable)Long.valueOf(classId), new String[]{"id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit"});
        if (course == null) {
            throw new ParameterException("\u73ed\u7ea7ID\u4e0d\u5b58\u5728!(" + classId + ")");
        }
        courseId = CourseTypeEnum.isOneToOne((Integer)course.getCourseType()) ? course.getParentId() : course.getId();
        ArrayList<OrgSignupCourse> signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId), Long.valueOf(classId), Long.valueOf(orgId), (Collection)SignupCourseStatus.PAY_SUCCESS);
        if ((signupCourseList == null || signupCourseList.size() < 1) && (studentCourse = this.studentcourseDao.listByCourseIdAndUserId(Long.valueOf(orgId), Long.valueOf(classId), Long.valueOf(userId))).getStatus() != 0) {
            signupCourseList = new ArrayList<OrgSignupCourse>();
            OrgSignupCourse signupCourse = new OrgSignupCourse();
            signupCourse.setLessonCount(Integer.valueOf(0));
            signupCourse.setUpdateTime(studentCourse.getCreateTime());
            signupCourse.setStatus(Integer.valueOf(6));
            signupCourse.setUserId(Long.valueOf(userId));
            signupCourse.setClassId(Long.valueOf(classId));
            signupCourse.setOrgCourseId(courseId);
            signupCourseList.add(signupCourse);
        }
        List courseLessons = this.signupCourseLessonDao.listLessonsByUserIdAndClassId(Long.valueOf(orgId), Long.valueOf(userId), Long.valueOf(classId), null, null);
        ArrayList<OrgSignupRefund> refundList = this.refundDao.listOrderByUserIdAndClassId(Long.valueOf(orgId), Long.valueOf(userId), Long.valueOf(classId));
        HashSet<String> refundIds = new HashSet<String>();
        HashSet<Long> refundPurchaseIds = new HashSet<Long>();
        for (OrgSignupRefund refund : refundList) {
            refundIds.add(refund.getUserId() + "_" + refund.getClassId());
            refundPurchaseIds.add(refund.getSignupPurchaseId());
        }
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIdAndClassId(Long.valueOf(userId), Long.valueOf(classId), status);
        List transferNumbers = ListUtil.toKeyList((Collection)transferClassInfos, (String)"transferNumber", TxTransferClassInfo.class);
        ArrayList<TxTransferClassRecord> recordList = new ArrayList();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = this.transferClassRecordDao.listByTransferNumbers((Collection)transferNumbers);
        }
        for (OrgSignupCourse signupCourse : signupCourseList) {
            log.info("[Kexiao] signupCourse={}", (Object)signupCourse);
            if (signupCourse.getStatus() != 6 || refundPurchaseIds.contains(signupCourse.getSignupPurchaseId())) continue;
            OrgSignupRefund refund = new OrgSignupRefund();
            refund.setCreateTime(signupCourse.getUpdateTime() == null ? signupCourse.getCreateTime() : signupCourse.getUpdateTime());
            refund.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
            refund.setRefundLessonCount(Long.valueOf(0L));
            refund.setRefundFee(signupCourse.getTotalPayPrice());
            refund.setClassId(signupCourse.getClassId());
            refund.setCourseId(signupCourse.getOrgCourseId());
            refund.setChargeUnit(course.getChargeUnit());
            refund.setUserId(signupCourse.getUserId());
            refund.setOrgId(signupCourse.getOrgId());
            refund.setKexiaoMoney(Long.valueOf(0L));
            refund.setKexiaoCount(Long.valueOf(0L));
            for (OrgSignupRefund signupRefund : refundList) {
                if (!signupRefund.getSignupPurchaseId().equals(signupCourse.getSignupPurchaseId())) continue;
                refund.setRefundFee(Long.valueOf(refund.getRefundFee() - signupRefund.getRefundFee() - signupRefund.getRefundPrice()));
                refund.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() - signupRefund.getRefundLessonCount()));
            }
            for (OrgSignupCourseLesson courseLesson : courseLessons) {
                if (!courseLesson.getSignupCourseId().equals(signupCourse.getId()) || courseLesson.getKexiaoStatus() != 1) continue;
                refund.setRefundFee(Long.valueOf(refund.getRefundFee() - courseLesson.getAmount()));
                refund.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() - (long)courseLesson.getLessonCount()));
            }
            refund.setKexiaoCount(Long.valueOf((long)signupCourse.getLessonCount().intValue() - refund.getRefundLessonCount()));
            refundList.add(refund);
        }
        OrgStudentCourse studentCourse2 = this.studentcourseDao.listByCourseIdAndUserId(Long.valueOf(orgId), Long.valueOf(classId), Long.valueOf(userId));
        if (studentCourse2.getStatus() != 1 || !refundIds.contains(studentCourse2.getUserId() + "_" + studentCourse2.getCourseId())) {
            // empty if block
        }
        refundList = new ArrayList<OrgSignupRefund>(this.mergeRefund((List<OrgSignupRefund>)refundList));
        KexiaoStatistics statistics = this.createClassKexiaoStatistics(signupCourseList, courseLessons, refundList, recordList);
        statistics.setUserId(userId);
        statistics.setClassId(classId);
        statistics.setChargeUnit(course.getChargeUnit());
        if (statistics.getCompleteStatus() != 0 || signupCourseList.size() < 1) {
            this.handHistoryArrangeLesson(orgId, userId, classId, statistics);
        }
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode().intValue()) {
            List studentLessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, classId, null, new String[0]);
            int kexiaoCount = 0;
            for (OrgStudentLesson studentLesson : studentLessons) {
                if (studentLesson.getKexiaoStatus().intValue() != LessonStatus.FINISHED.getStatus()) continue;
                ++kexiaoCount;
            }
            statistics.setKexiaoNormalNumber(kexiaoCount);
            statistics.setArrangeNormalNumber(studentLessons.size());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userId, classId, statistics});
        return statistics;
    }

    private List<OrgSignupRefund> mergeRefund(List<OrgSignupRefund> refundList) {
        HashMap<String, OrgSignupRefund> refundMap = new HashMap<String, OrgSignupRefund>();
        for (OrgSignupRefund refund : refundList) {
            String key = refund.getSignupPurchaseId() + "_" + refund.getClassId();
            OrgSignupRefund exist = (OrgSignupRefund)refundMap.get(key);
            if (exist != null) {
                if (exist.getCreateTime().compareTo(refund.getCreateTime()) < 0) {
                    exist.setCreateTime(refund.getCreateTime());
                }
                exist.setRefundFee(Long.valueOf(refund.getRefundFee() + exist.getRefundFee()));
                exist.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() + exist.getRefundLessonCount()));
                exist.setRefundPrice(Long.valueOf(refund.getRefundPrice() + exist.getRefundPrice()));
                exist.setKexiaoCount(Long.valueOf(refund.getKexiaoCount() + exist.getKexiaoCount()));
                exist.setKexiaoMoney(Long.valueOf(refund.getKexiaoMoney() + exist.getKexiaoMoney()));
                continue;
            }
            refundMap.put(key, refund);
        }
        log.info("[Kexiao] merge result={}", refundMap);
        return new ArrayList<OrgSignupRefund>(refundMap.values());
    }

    private void handHistoryArrangeLesson(long orgId, long userId, long classId, KexiaoStatistics statistics) {
        List lessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, classId, null, Arrays.asList(LessonType.OTHER.getCode()), new String[0]);
        if (lessons != null && lessons.size() > 0) {
            for (OrgStudentLesson lesson : lessons) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    statistics.setKexiaoNormalNumber(statistics.getKexiaoNormalNumber() + 1L);
                }
                statistics.setArrangeNormalNumber(statistics.getArrangeNormalNumber() + 1L);
            }
        }
    }

    private KexiaoStatistics createClassKexiaoStatistics(List<OrgSignupCourse> signupCourseList, List<OrgSignupCourseLesson> courseLessons, List<OrgSignupRefund> refundList, List<TxTransferClassRecord> recordList) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        int completeStatus = 0;
        HashMap<String, OrgSignupCourse> courseMap = new HashMap<String, OrgSignupCourse>();
        if (signupCourseList != null && signupCourseList.size() > 0) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                this.addBuyData(signupCourse, statistics);
                if (this.isComputable(signupCourse)) continue;
                completeStatus = 1;
            }
            log.info("[Kexiao] KexiaoStatistics={}", (Object)statistics);
            for (OrgSignupCourse signupCourse : signupCourseList) {
                courseMap.put(this.getUniqueId(signupCourse), signupCourse);
            }
        }
        statistics.setCompleteStatus(completeStatus);
        HashMap<Long, ArrayList<OrgSignupCourseLesson>> lessonsMap = new HashMap<Long, ArrayList<OrgSignupCourseLesson>>();
        if (courseLessons != null && courseLessons.size() > 0) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                this.addKexiaoData(lesson, statistics);
                if (lesson.getSignupCourseId() <= 0L) continue;
                ArrayList<OrgSignupCourseLesson> lessonList = (ArrayList<OrgSignupCourseLesson>)lessonsMap.get(lesson.getSignupCourseId());
                if (lessonList == null) {
                    lessonList = new ArrayList<OrgSignupCourseLesson>();
                    lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                }
                lessonList.add(lesson);
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}", (Object)statistics);
        log.info("[Kexiao] OrgSignupRefund list={}", refundList);
        if (refundList != null && refundList.size() > 0) {
            for (OrgSignupRefund refund : refundList) {
                if (this.isHistoryRefund(refund)) {
                    OrgSignupCourse signupCourse = (OrgSignupCourse)courseMap.get(this.getUniqueId(refund));
                    if (signupCourse != null && this.isRefunded(signupCourse.getStatus())) {
                        this.handleHistoryRefundData(refund, signupCourse, (List)lessonsMap.get(signupCourse.getId()));
                        continue;
                    }
                    log.info("Signupcourse is not exist.courseMap={},refund={}", courseMap, (Object)refund);
                    continue;
                }
                log.info("It is not history refund record.");
            }
            for (OrgSignupRefund refund : refundList) {
                this.addRefundData(refund, statistics, completeStatus);
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}", (Object)statistics);
        if (recordList != null && recordList.size() > 0) {
            for (TxTransferClassRecord record : recordList) {
                this.addTransferData(record, statistics);
            }
        }
        log.info("[Kexiao] KexiaoStatistics={}", (Object)statistics);
        return statistics;
    }

    private boolean isRefunded(int status) {
        return status == SignupCourseStatus.QUIT_CLASS.getCode() || status == SignupCourseStatus.QUIT_PURCHASE.getCode();
    }

    private void handleHistoryRefundData(OrgSignupRefund refund, OrgSignupCourse signupCourse, List<OrgSignupCourseLesson> courseLessons) {
        log.info("[KexiaoStatistics] handle refund before:refund={},courseLessons={}", (Object)refund, courseLessons);
        if (signupCourse == null) {
            log.warn("[Kexiao] signupCourse is null");
            return;
        }
        if (signupCourse.getLessonCount() < 1) {
            refund.setRefundPrice(Long.valueOf(signupCourse.getTotalPayPrice() - refund.getRefundFee()));
        } else {
            long kexiaoNumber = 0L;
            long kexiaoMoney = 0L;
            if (courseLessons != null) {
                for (OrgSignupCourseLesson lesson : courseLessons) {
                    if (lesson == null || lesson.getKexiaoStatus() == null || lesson.getLessonType() == null || lesson.getKexiaoStatus() != 1 || lesson.getLessonType().intValue() != LessonType.NORMAL.getCode()) continue;
                    kexiaoNumber = ChargeUnit.isByTime((int)signupCourse.getChargeUnit()) ? (kexiaoNumber += (long)lesson.getLessonDuration().intValue()) : ++kexiaoNumber;
                    kexiaoMoney += lesson.getAmount().longValue();
                }
            }
            refund.setRefundLessonCount(Long.valueOf((long)KexiaoUtil.getClassNumber(signupCourse) - kexiaoNumber));
            refund.setRefundPrice(Long.valueOf(signupCourse.getTotalPayPrice() - refund.getRefundFee() - kexiaoMoney));
            log.info("[Kexiao] kexiaoNumber={},kexiaoMoney={}", (Object)kexiaoNumber, (Object)kexiaoMoney);
        }
        log.info("[Kexiao] handle refund after:{},signupCourse={}", (Object)refund, (Object)signupCourse);
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIdAndUserIds(long orgId, long classId, Collection<Long> userIds) {
        HashMap<Long, KexiaoStatistics> ret = new HashMap<Long, KexiaoStatistics>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        Long courseId = classId;
        OrgCourse course = (OrgCourse)this.courseDao.getById((Serializable)Long.valueOf(classId), new String[]{"id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit"});
        if (course == null) {
            throw new ParameterException("\u73ed\u7ea7ID\u4e0d\u5b58\u5728!(" + classId + ")");
        }
        courseId = CourseTypeEnum.isOneToOne((Integer)course.getCourseType()) ? course.getParentId() : course.getId();
        List signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, Long.valueOf(classId), Long.valueOf(orgId), (Collection)SignupCourseStatus.PAY_SUCCESS);
        HashMap signupCourseMap = new HashMap();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            List list = (List)signupCourseMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList();
                signupCourseMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }
        HashMap<Long, Object> courseLessonMap = new HashMap<Long, Object>();
        List courseLessons = this.signupCourseLessonDao.listByUserIdsAndClassId(userIds, classId, null);
        for (OrgSignupCourseLesson courseLesson : courseLessons) {
            ArrayList<OrgSignupCourseLesson> list = (ArrayList<OrgSignupCourseLesson>)courseLessonMap.get(courseLesson.getUserId());
            if (list == null) {
                list = new ArrayList<OrgSignupCourseLesson>();
                courseLessonMap.put(courseLesson.getUserId(), list);
            }
            list.add(courseLesson);
        }
        List refundList = this.refundDao.listOrderByUserIdsAndClassId(Long.valueOf(orgId), userIds, Long.valueOf(classId));
        HashMap<Long, ArrayList<OrgSignupRefund>> refundMap = new HashMap<Long, ArrayList<OrgSignupRefund>>();
        for (OrgSignupRefund refund : refundList) {
            ArrayList<OrgSignupRefund> list = (ArrayList<OrgSignupRefund>)refundMap.get(refund.getUserId());
            if (list == null) {
                list = new ArrayList<OrgSignupRefund>();
                refundMap.put(refund.getUserId(), list);
            }
            list.add(refund);
        }
        Map<Long, List<TxTransferClassRecord>> recordMap = this.getTxTransferClassRecordList(userIds, classId);
        for (Long userId : userIds) {
            KexiaoStatistics statistics = this.createClassKexiaoStatistics((List)signupCourseMap.get(userId), (List)courseLessonMap.get(userId), (List)refundMap.get(userId), recordMap.get(userId));
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            ret.put(userId, statistics);
        }
        return ret;
    }

    @Override
    public Map<Long, KexiaoSignupCourseStat> queryKexiaoStatBySignUpCourseIds(Collection<OrgSignupCourse> signupCourseList) {
        if (signupCourseList == null || signupCourseList.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, OrgSignupCourse> courseMap = new HashMap<String, OrgSignupCourse>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            courseMap.put(this.getUniqueId(signupCourse), signupCourse);
        }
        List signupCourseIds = ListUtil.toKeyList(signupCourseList, (String)"id", OrgSignupCourse.class);
        List purchaseIds = ListUtil.toKeyList(signupCourseList, (String)"signupPurchaseId", OrgSignupCourse.class);
        List arrangedList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, Integer.valueOf(LessonType.FREE.getCode()), null);
        HashMap<Long, OrgSignupCourseLesson> arrangedFreeMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : arrangedList) {
            arrangedFreeMap.put(lesson.getSignupCourseId(), lesson);
        }
        List normalList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, Integer.valueOf(LessonType.NORMAL.getCode()), null);
        HashMap<Long, OrgSignupCourseLesson> arrangedNormalMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : normalList) {
            arrangedNormalMap.put(lesson.getSignupCourseId(), lesson);
        }
        List freeKexiaoList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, Integer.valueOf(LessonType.FREE.getCode()), Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        HashMap<Long, OrgSignupCourseLesson> freeKexiaoMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : freeKexiaoList) {
            freeKexiaoMap.put(lesson.getSignupCourseId(), lesson);
        }
        List kexiaoList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, Integer.valueOf(LessonType.NORMAL.getCode()), Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        HashMap<Long, ArrayList<OrgSignupCourseLesson>> lessonsMap = new HashMap<Long, ArrayList<OrgSignupCourseLesson>>();
        HashMap<Long, OrgSignupCourseLesson> normalKexiaoMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : kexiaoList) {
            normalKexiaoMap.put(lesson.getSignupCourseId(), lesson);
            if (lesson.getSignupCourseId() <= 0L) continue;
            ArrayList<OrgSignupCourseLesson> lessonList = (ArrayList<OrgSignupCourseLesson>)lessonsMap.get(lesson.getSignupCourseId());
            if (lessonList == null) {
                lessonList = new ArrayList<OrgSignupCourseLesson>();
                lessonsMap.put(lesson.getSignupCourseId(), lessonList);
            }
            lessonList.add(lesson);
        }
        List<Integer> status = Arrays.asList(TransferClassStatus.SUCCESS.getCode(), TransferClassStatus.INIT.getCode());
        Map purchaseTransferMap = this.transferClassRecordDao.groupByPurchaseIds((Collection)purchaseIds, status);
        List refunds = this.refundDao.getByPurcahseIds(new HashSet(purchaseIds));
        HashMap<String, OrgSignupRefund> refundMap = new HashMap<String, OrgSignupRefund>();
        for (OrgSignupRefund refund : refunds) {
            String key;
            OrgSignupRefund tmp;
            OrgSignupCourse signupCourse;
            if (this.isHistoryRefund(refund) && (signupCourse = (OrgSignupCourse)courseMap.get(this.getUniqueId(refund))) != null && this.isRefunded(signupCourse.getStatus())) {
                this.handleHistoryRefundData(refund, signupCourse, (List)lessonsMap.get(signupCourse.getId()));
            }
            if ((tmp = (OrgSignupRefund)refundMap.get(key = refund.getSignupPurchaseId() + "_" + refund.getClassId())) == null) {
                refundMap.put(key, refund);
                continue;
            }
            tmp.setRefundFee(Long.valueOf(tmp.getRefundFee() + tmp.getRefundPrice() + refund.getRefundFee() + refund.getRefundPrice()));
            tmp.setRefundLessonCount(Long.valueOf(tmp.getRefundLessonCount() + refund.getRefundLessonCount()));
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);
        HashMap<Long, KexiaoSignupCourseStat> ret = new HashMap<Long, KexiaoSignupCourseStat>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
            KexiaoSignupCourseStat stat = new KexiaoSignupCourseStat();
            KexiaoStatisticsBuilder builder = new KexiaoStatisticsBuilder(stat);
            builder.addSignupCourse(signupCourse).addArrangedNormalLesson((OrgSignupCourseLesson)arrangedNormalMap.get(signupCourse.getId())).addArrangedFreeLesson((OrgSignupCourseLesson)arrangedFreeMap.get(signupCourse.getId())).addKexiaoFreeLesson((OrgSignupCourseLesson)freeKexiaoMap.get(signupCourse.getId())).addKexiaoNormalLesson((OrgSignupCourseLesson)normalKexiaoMap.get(signupCourse.getId())).addTransferRecord((TxTransferClassRecord)purchaseTransferMap.get(key)).addRefundRecord((OrgSignupRefund)refundMap.get(key));
            builder.build();
            stat.setStatus(signupCourse.getStatus());
            stat.setPurchaseId(signupCourse.getSignupPurchaseId());
            ret.put(signupCourse.getId(), stat);
        }
        return ret;
    }

    @Override
    public OrgSignupCourseLesson querySignupCourseLessonInfo(Long signupCouseId, Long lessonId) {
        Map lessonMap = this.signupCourseLessonDao.listBySignupCourseIdAndLessonId(Arrays.asList(signupCouseId), Arrays.asList(lessonId));
        return (OrgSignupCourseLesson)lessonMap.get(signupCouseId + "_" + lessonId);
    }

    @Override
    public Map<Long, List<OrgSignupCourseLesson>> queryLessonSignupCourseList(Collection<Long> lessonIds, Long userId) {
        List lessons = this.signupCourseLessonDao.listByUserIdAndLessonId(Arrays.asList(userId), lessonIds, null);
        HashMap<Long, List<OrgSignupCourseLesson>> ret = new HashMap<Long, List<OrgSignupCourseLesson>>();
        for (OrgSignupCourseLesson lesson : lessons) {
            ArrayList<OrgSignupCourseLesson> list = (ArrayList<OrgSignupCourseLesson>)ret.get(lesson.getId());
            if (list == null) {
                list = new ArrayList<OrgSignupCourseLesson>();
            }
            list.add(lesson);
        }
        return ret;
    }

    public StudentCourseKexiaoDocument finishCountMoney1(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status, new String[0]);
        Map signupCourseMap = CollectionHelper.toKeyMap((Collection)signupCourseList, (String)"id");
        Map<Object, Object> courseStatMap = new HashMap();
        if (signupCourseId != null && signupCourseId > 0L) {
            if (signupCourseMap.keySet().contains(signupCourseId)) {
                courseStatMap = this.queryKexiaoStatBySignUpCourseIds(Arrays.asList((OrgSignupCourse)signupCourseMap.get(signupCourseId)));
            }
        } else {
            courseStatMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);
        }
        StudentCourseKexiaoDocument doc = new StudentCourseKexiaoDocument();
        if (courseStatMap != null && courseStatMap.size() > 0) {
            for (KexiaoStatistics kexiaoStatistics : courseStatMap.values()) {
                log.debug("StudentCourseKexiaoDocument =={},{},{}", new Object[]{kexiaoStatistics, kexiaoStatistics.getLeftAmount(), kexiaoStatistics.getLeftNumber()});
                if (ChargeUnit.isByTime((int)kexiaoStatistics.getChargeUnit())) {
                    doc.setFinishTime(Long.valueOf(doc.getFinishTime() + kexiaoStatistics.getKexiaoNumber() + kexiaoStatistics.getTransferNumber() + kexiaoStatistics.getRefundNumber()));
                    doc.setNormalTime(Long.valueOf(doc.getNormalTime() + kexiaoStatistics.getKexiaoNormalNumber() + kexiaoStatistics.getTransferNormalNumber() + kexiaoStatistics.getRefundNormalNumber()));
                } else {
                    doc.setFinishCount(Long.valueOf(doc.getFinishCount() + kexiaoStatistics.getKexiaoNumber() + kexiaoStatistics.getTransferNumber() + kexiaoStatistics.getRefundNumber()));
                    doc.setNormalCount(Long.valueOf(doc.getNormalCount() + kexiaoStatistics.getKexiaoNormalNumber() + kexiaoStatistics.getTransferNormalNumber() + kexiaoStatistics.getRefundNormalNumber()));
                }
                doc.setFinishMoney(Long.valueOf(kexiaoStatistics.getKexiaoAmount() + kexiaoStatistics.getTransferAmount() + kexiaoStatistics.getRefundAmount()));
            }
        }
        return doc;
    }

    @Override
    public StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        this.finishCountMoney1(orgId, courseId, userId, signupCourseId, null);
        log.info("StudentCourseKexiaoDocument finishCountMoney = {},{},{},{}", new Object[]{orgId, courseId, userId, signupCourseId, status});
        StudentCourseKexiaoDocument kexiaoDocument = this.orgStudentKexiaoRecordDao.finishCountMoney(orgId, courseId, userId, signupCourseId, status);
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status, new String[0]);
        log.info("StudentCourseKexiaoDocument signupCourseList = {},{}", (Object)signupCourseList, (Object)kexiaoDocument);
        ArrayList outPurchaseIds = Lists.newArrayList();
        Long classId = 0L;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            classId = signupCourse.getClassId();
            if (signupCourseId != null) {
                if (signupCourse.getId().longValue() != signupCourseId.longValue()) continue;
                outPurchaseIds.add(signupCourse.getSignupPurchaseId());
                break;
            }
            outPurchaseIds.add(signupCourse.getSignupPurchaseId());
        }
        if (CollectionUtils.isEmpty((Collection)outPurchaseIds)) {
            return kexiaoDocument;
        }
        TxTransferClassRecord txTransferClassRecord = this.transferClassRecordDao.sumByPurchases((List)outPurchaseIds, classId);
        log.info("StudentCourseKexiaoDocument txTransferClassRecord=={}", (Object)txTransferClassRecord);
        if (txTransferClassRecord != null && txTransferClassRecord.getChargeUnit() != null) {
            if (txTransferClassRecord.getChargeUnit() != null && txTransferClassRecord.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                kexiaoDocument.setFinishCount(Long.valueOf(kexiaoDocument.getFinishCount() + txTransferClassRecord.getTransferLessonCount().longValue()));
            } else {
                kexiaoDocument.setFinishTime(Long.valueOf(kexiaoDocument.getFinishTime() + txTransferClassRecord.getTransferLessonCount().longValue()));
            }
            kexiaoDocument.setFinishMoney(Long.valueOf(kexiaoDocument.getFinishMoney() + (long)txTransferClassRecord.getLessonMoney().intValue()));
        }
        return kexiaoDocument;
    }

    @Override
    public void fillKexiaoData(KexiaoStatisticsSuper dto, KexiaoStatistics statistics) {
        String remainTuition = this.getLeftAmountStr(statistics);
        dto.setRemainTuition(remainTuition);
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode().intValue() && !statistics.isRefund()) {
            dto.setTotalClassTimesForKexiaoValue(0);
            dto.setLeftClassTimesForKexiaoValue(0);
            dto.setFinishClassTimesForKexiaoValue(0);
            dto.setTotalClassTimesForKexiao("--");
            dto.setLeftClassTimesForKexiao("--");
            dto.setBuyClassTimesForKexiao("--");
            dto.setFinishClassTimesForKexiao("--");
        } else {
            dto.setTotalClassTimesForKexiaoValue((int)statistics.getTotalNumber());
            dto.setLeftClassTimesForKexiaoValue((int)statistics.getLeftNumber());
            dto.setFinishClassTimesForKexiaoValue((int)statistics.getKexiaoNumber());
            if (ChargeUnit.isByTime((int)statistics.getChargeUnit())) {
                dto.setTotalClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getLeftNumber()));
                dto.setFinishClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", (Object)dto);
            } else {
                long leftNum = statistics.getTotalNumber() - statistics.getKexiaoNumber();
                dto.setTotalClassTimesForKexiao(String.valueOf(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(String.valueOf(leftNum));
                dto.setFinishClassTimesForKexiao(String.valueOf(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(String.valueOf(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", (Object)dto);
            }
        }
    }
}

