package com.baijia.tianxiao.sal.common.utils;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.util.NumberUtil;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * Created by lxp on 2017/5/6.
 */
@Slf4j
public class KexiaoUtil {
    private static final int HOUR = 60;
    private static final int HALF_HOUR = 30;

    public static double getLessonNum(long number, int chargeUnit) {
        ChargeUnit unit = ChargeUnit.getByCode(chargeUnit);
        if (unit == null) {
            unit = ChargeUnit.BY_OTHER;
        }
        switch (unit) {
            case BY_HOUR:
            case BY_HALF_HOUR:
            case BY_MINUTE:
                return NumberUtil.convertMinToHourWithScale(number, 2);
            case BY_TIMES:
                return number;
            default:
                log.error("[Kexiao] chargeUnit is error.charUnit={}", chargeUnit);
                return number;
        }
    }

    public static String classHourFormat(long minute) {
        BigDecimal bigDecimal = new BigDecimal(minute);
        BigDecimal base = new BigDecimal(60);
        String result = bigDecimal.divide(base, 2, BigDecimal.ROUND_HALF_UP).toString();
        for (int i = result.length() - 1; i > 0; i--) {
            if (result.charAt(i) == '0') {//去除末尾的0
                result = result.substring(0, i);
            } else if (result.charAt(i) == '.') {//去除末尾的.
                result = result.substring(0, i);
                break;
            } else {
                break;
            }
        }
        return result;
    }

    public static int getClassNumber(OrgSignupCourse signupCourse) {
        ChargeUnit chargeUnit = ChargeUnit.getByCode(signupCourse.getChargeUnit());
        switch (chargeUnit) {
            case BY_HOUR:
                return signupCourse.getLessonCount() * HOUR;
            case BY_HALF_HOUR:
                return signupCourse.getLessonCount() * HALF_HOUR;
            case BY_MINUTE:
                return signupCourse.getLessonCount();
            case BY_TIMES:
                return signupCourse.getLessonCount();
            default:
                log.warn("[SignupCourseLesson] chargeUnit is error.signupCourse={}", signupCourse);
                return signupCourse.getLessonCount();
        }
    }

    public static void main(String[] args) {
        System.out.println(classHourFormat(30));
        System.out.println(classHourFormat(60));
        System.out.println(classHourFormat(15));
        System.out.println(classHourFormat(10));
        System.out.println(classHourFormat(0));
    }
}
