package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 04/09/2017 5:25 PM
 */
@Slf4j
@Service
public class OrgTeacherApiServiceImpl implements OrgTeacherApiService {
    
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    
    @Autowired
    private TeacherDao teacherDao;
    
    @Autowired
    private StorageDao storageDao;

    public Map<Long, TwoTuple<String, String>> getNameAndAvatarByUserIds(Long orgId, Collection<Long> userIds){
        if(CollectionUtils.isEmpty(userIds)){
            return Maps.newHashMap();
        }
        List<OrgTeacher> orgTeachers = orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, userIds, null, null);
        return buildTeacherBaseMap(orgTeachers);
    }

    private Map<Long, TwoTuple<String, String>> buildTeacherBaseMap(List<OrgTeacher> orgTeachers){
        Map<Long, TwoTuple<String, String>> result = Maps.newHashMap();
        if(CollectionUtils.isEmpty(orgTeachers)){
            return result;
        }
        List<Teacher> teachers = teacherDao
            .getByUserIds(orgTeachers.stream().map(orgTeacher -> orgTeacher.getUserId()).collect(Collectors.toList()));
        Map<Long, Teacher> teacherMap = CollectorUtil.collectMap(teachers, (Function<Teacher, Long>) teacher -> teacher.getUserId());
        Map<Long, Teacher> storageIds = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
            @Override
            public Long apply(Teacher teacher) {
                return teacher.getAvatar();
            }
        });
        List<Storage> storages = storageDao.getByIds(storageIds.keySet());
        Map<Long, Storage> storageMap = CollectorUtil.collectMap(storages, new Function<Storage, Long>() {
            @Override
            public Long apply(Storage storage) {
                return storage.getId();
            }
        });

        for (OrgTeacher orgTeacher : orgTeachers) {
            Teacher teacher = teacherMap.get(orgTeacher.getUserId());
            String name = null;
            String avatar = null;
            if (teacher != null) {
                name = teacher.getRealName();
            }
            if (teacher.getAvatar() != null) {
                Storage storage = storageMap.get(teacher.getAvatar());
                if (storage != null) {
                    String avatarUrl =
                        StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                    avatar = avatarUrl;
                }
            }
            avatar = StringUtils.defaultIfBlank(avatar, AvatarConstants.STUFF_AVATAR_URL);
            TwoTuple<String, String> tuple = new TwoTuple<>(name, avatar);
            result.put(orgTeacher.getUserId(), tuple);
        }
        return result;
    }
    
}
