package com.baijia.tianxiao.sal.common.dto.kexiao;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import lombok.Data;

/**
 * Created by lxp on 2017/4/24.
 */
@Data
public class KexiaoStudentStat extends KexiaoStatistics {

    private long contractCount;
    private long contractTime;
    private long completeOrderCount;
    private long completeOrderTime;

    private long arrangeNormalCount;
    private long arrangeNormalTime;
    private long arrangeFreeCount;
    private long arrangeFreeTime;

    private long refundFreeCount;
    private long refundFreeTime;
    private long refundNormalCount;
    private long refundNormalTime;

    private long transferFreeCount;
    private long transferFreeTime;
    private long transferNormalCount;
    private long transferNormalTime;

    private long kexiaoNormalCount;
    private long kexiaoNormalTime;
    private long kexiaoFreeCount;
    private long kexiaoFreeTime;

    public void splitContractNumber(OrgSignupCourse signupCourse) {
        if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
            this.contractTime += KexiaoUtil.getClassNumber(signupCourse);
        } else {
            this.contractCount += signupCourse.getLessonCount();
        }
        if(signupCourse.getLessonCount()>0){
            if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                this.completeOrderTime += KexiaoUtil.getClassNumber(signupCourse);
            } else {
                this.completeOrderCount += signupCourse.getLessonCount();
            }
        }
    }

    public void splitRefundNumber(OrgSignupRefund refund) {
        if (ChargeUnit.isByTime(refund.getChargeUnit())) {
            this.refundNormalTime += refund.getRefundLessonCount();
        } else {
            this.refundNormalCount += refund.getRefundLessonCount();
        }
    }

    public void splitTransferNumber(TxTransferClassRecord record) {
        if (ChargeUnit.isByTime(record.getChargeUnit())) {
            transferNormalTime += record.getRealLessonCount();
            transferFreeTime += record.getFreeLessonCount();
        } else {
            transferNormalCount += record.getRealLessonCount();
            transferFreeCount += record.getFreeLessonCount();
        }
    }

    public void splitKexiaoNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime(lesson.getChargeUnit())) {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoNormalTime += lesson.getLessonDuration();
                }
                arrangeNormalTime += lesson.getLessonDuration();
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoFreeTime += lesson.getLessonDuration();
                }
                arrangeFreeTime += lesson.getLessonDuration();
            }
        } else {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoNormalCount++;
                }
                arrangeNormalCount++;
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoFreeCount++;
                }
                arrangeFreeCount++;
            }
        }
    }

    public long getBuyCount() {
        return getContractCount() - getRefundNormalCount() - getTransferNormalCount();
    }

    public long getBuyTime() {
        return getContractTime() - getRefundNormalTime() - getTransferNormalTime();
    }

    public long getTotalCount() {
        if (getCompleteStatus() == 0) {
            return getBuyCount() + getArrangeFreeCount();
        } else {
            return getArrangeNormalCount()+getArrangeFreeCount();
        }
    }

    public long getTotalTime() {
        if (getCompleteStatus() == 0) {
            return getBuyTime() + getArrangeFreeTime();
        } else {
            return getArrangeNormalTime()+getArrangeFreeTime();
        }
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("KexiaoStudentStat{");
        sb.append("contractCount=").append(contractCount);
        sb.append(", contractTime=").append(contractTime);
        sb.append(", completeOrderCount=").append(completeOrderCount);
        sb.append(", completeOrderTime=").append(completeOrderTime);
        sb.append(", arrangeNormalCount=").append(arrangeNormalCount);
        sb.append(", arrangeNormalTime=").append(arrangeNormalTime);
        sb.append(", arrangeFreeCount=").append(arrangeFreeCount);
        sb.append(", arrangeFreeTime=").append(arrangeFreeTime);
        sb.append(", refundFreeCount=").append(refundFreeCount);
        sb.append(", refundFreeTime=").append(refundFreeTime);
        sb.append(", refundNormalCount=").append(refundNormalCount);
        sb.append(", refundNormalTime=").append(refundNormalTime);
        sb.append(", transferFreeCount=").append(transferFreeCount);
        sb.append(", transferFreeTime=").append(transferFreeTime);
        sb.append(", transferNormalCount=").append(transferNormalCount);
        sb.append(", transferNormalTime=").append(transferNormalTime);
        sb.append(", kexiaoNormalCount=").append(kexiaoNormalCount);
        sb.append(", kexiaoNormalTime=").append(kexiaoNormalTime);
        sb.append(", kexiaoFreeCount=").append(kexiaoFreeCount);
        sb.append(", kexiaoFreeTime=").append(kexiaoFreeTime);
        sb.append('}');
        return sb.toString()+":"+super.toString();
    }
}
