package com.baijia.tianxiao.sal.common.dto;

import com.google.gson.Gson;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 08/06/2017 5:51 PM
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public final class InviteCardTaskDto {
    private Integer lessonId;
    private String openId;
    private Boolean sendWechatMsg;
    
    public static InviteCardTaskDto fromJson(String json){
        if(StringUtils.isBlank(json)){
            return null;
        }else {
            return new Gson().fromJson(json, InviteCardTaskDto.class);
        }
    }
    
    public String toJson(){
        return new Gson().toJson(this);
    }
}
