package com.baijia.tianxiao.sal.common.api;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoClassStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by lxp on 2017/2/22.
 */
public interface KexiaoApiService {
    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule);

    public LessonStatus getKexiaoStatus(Date startTime);

    public void setStudentLessonKexiaoStatus(Collection<OrgStudentLesson> studentLessons);

    public String getLeftAmountStr(KexiaoStatistics stat);

    /**
     * 统计学生总的课次和学费信息
     *
     * @param userIds
     * @return
     */
    public Map<Long, KexiaoStudentStat> queryUserKexiaoStat(Long orgId, Collection<Long> userIds);

    /**
     * 统计学生在班上的课次和学费信息
     * @param orgId
     * @param userIds
     * @return
     */
    public Map<String, KexiaoStatistics> queryClassKexiaoStatByUserIds(Long orgId, Collection<Long> userIds);

    /**
     * 统计某个班上的课次和学费信息
     *
     * @param classIds
     * @return
     */
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIds(Long orgId,Collection<Long> classIds);

    /**
     * 统计订单上的课次和学费信息
     *
     * @param signupCourseList
     * @return
     */
    public Map<Long, KexiaoSignupCourseStat> queryKexiaoStatBySignUpCourseIds(Collection<OrgSignupCourse> signupCourseList);

    /**
     * 统计学员在班上的剩余学费和课次信息
     *
     * @param userId
     * @param classId
     * @return
     */
    public KexiaoStatistics queryKexiaoStatByStudentClass(long orgId, long userId, long classId);

    /**
     * 根据课程ID查询课消数据
     * @param orgId
     * @param userId
     * @param courseId
     * @return
     */
    public KexiaoStatistics queryKexiaoStatByStudentCourse(long orgId, long userId, long courseId);


    /**
     * 统计学员在班上的剩余学费和课次信息
     *
     * @param userIds
     * @param classId
     * @return
     */
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIdAndUserIds(long orgId, long classId,Collection<Long> userIds);

    /**
     * 查询订单在课节上的金额
     *
     * @param SignupCouseId
     * @param lessonId
     */
    public OrgSignupCourseLesson querySignupCourseLessonInfo(Long SignupCouseId, Long lessonId);

    /**
     * 查询用户课节对应的订单信息
     *
     * @param lessonIds
     * @param userId
     * @return
     */
    public Map<Long, List<OrgSignupCourseLesson>> queryLessonSignupCourseList(Collection<Long> lessonIds, Long userId);


    /**
     * @param orgId
     * @param courseId
     * @param userId
     * @param signupCourseId
     * @param status
     * @return
     */
    StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status);

    /**
     * 填充課消數據
     * @param dto
     * @param statistics
     */
    public void fillKexiaoData(KexiaoStatisticsSuper dto, KexiaoStatistics statistics);

}
