
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.activity.dao.article.OrgTeacherDocumentMongoDbDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherUseStatus;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Mar 10, 2017
 * @Desc 用于对不走OrgteacherDao对老师进行查询的接口进行过滤
 */
@Service
@Slf4j
public class FilterSoftDelTeacherServiceImpl implements FilterSoftDelTeacherService {

    // @Autowired(required = false)
    // private OrgTeacherQuery orgTeacherQuery;
    @Autowired(required = false)
    private OrgTeacherDocumentMongoDbDao orgTeacherDocumentMongoDbDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgTeacherForSolrService orgTeacherForSolrService;

    @Override
    public void filterOrgCourseTeacherWithUserIds(Long orgId, Collection<Long> orgCourseTeacherUserIds) {
        if (GenericsUtils.isNullOrEmpty(orgCourseTeacherUserIds) || orgId == null) {
            return;
        }
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), orgCourseTeacherUserIds, false);
        List<OrgTeacher> teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId,
                orgCourseTeacherUserIds, OrgTeacherStatus.SIGNED.getCode(), null, "useStatus", "userId");
        Map<Long, OrgTeacher> extractList = getAllNormalTeachers(teacherByUserIdsAndOrgId);
        for (Iterator<Long> iter = orgCourseTeacherUserIds.iterator(); iter.hasNext(); ) {
            Long next = iter.next();
            OrgTeacher orgTeacher = extractList.get(next);
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus != null && useStatus == OrgTeacherUseStatus.PAUSE.code
                    && canFilterWithoutClassRecord(hasClassRecord.get(next))) {
                iter.remove();
            }
        }
    }

    @Override
    public void filterOrgCourseTeacher(Long orgId, List<OrgCourseTeacher> orgCourseTeachers) {
        if (GenericsUtils.isNullOrEmpty(orgCourseTeachers) || orgId == null) {
            return;
        }
        List<Long> userIds =
                CollectionUtils.extractList(orgCourseTeachers, new CollectionUtils.Extracter<Long, OrgCourseTeacher>() {
                    @Override
                    public Long extract(OrgCourseTeacher arg0) {
                        return arg0.getUserId();
                    }
                });
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), userIds, false);
        List<OrgTeacher> teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, userIds,
                OrgTeacherStatus.SIGNED.getCode(), true, "useStatus", "userId");
        Map<Long, OrgTeacher> extractList = getAllNormalTeachers(teacherByUserIdsAndOrgId);
        for (Iterator<OrgCourseTeacher> iter = orgCourseTeachers.iterator(); iter.hasNext(); ) {
            OrgCourseTeacher next = iter.next();
            OrgTeacher orgTeacher = extractList.get(next.getUserId());
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus != null && useStatus == OrgTeacherUseStatus.PAUSE.code
                    && canFilterWithoutClassRecord(hasClassRecord.get(next.getUserId()))) {
                iter.remove();
            }
        }
    }

    @Override
    public void filterTeachers(Long orgId, List<Teacher> teacherList) {
        if (GenericsUtils.isNullOrEmpty(teacherList) || orgId == null) {
            return;
        }
        List<Long> userIds = CollectionUtils.extractList(teacherList, new CollectionUtils.Extracter<Long, Teacher>() {
            @Override
            public Long extract(Teacher arg0) {
                return arg0.getUserId();
            }
        });
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), userIds, false);
        List<OrgTeacher> teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, userIds,
                OrgTeacherStatus.SIGNED.getCode(), null, "useStatus", "userId");
        List<Long> delTeacherIds = Lists.newArrayList();
        Map<Long, OrgTeacher> extractList = getAllNormalTeachers(teacherByUserIdsAndOrgId);
        for (Iterator<Teacher> iter = teacherList.iterator(); iter.hasNext(); ) {
            Teacher next = iter.next();
            OrgTeacher orgTeacher = extractList.get(next.getUserId());
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus != null && useStatus == OrgTeacherUseStatus.PAUSE.code
                    && canFilterWithoutClassRecord(hasClassRecord.get(next.getUserId()))) {
                //iter.remove();
                delTeacherIds.add(next.getId());
            }
        }

        List<Teacher> result = Lists.newArrayList();
        if (!delTeacherIds.isEmpty()) {
            for (Teacher teacher : teacherList) {
                for (Long teacherId : delTeacherIds) {
                    if (teacher != null && teacher.getId() != null && teacherId != null && teacher.getId().longValue() != teacherId.longValue()) {
                        result.add(teacher);
                    }
                }
            }
        } else {
            result.addAll(teacherList);
        }
        teacherList = result;
    }

    /**
     * @param hasClassRecord
     * @return
     */
    private boolean canFilterWithoutClassRecord(Boolean hasClassRecord) {
        return true;
        // return !(boolean1 != null && boolean1); //TODO 这逻辑不确定加不加
    }

    /**
     * 查询某个老师是否有上课记录
     *
     * @param orgId
     * @param teacherIds
     * @return 返回的是某个老师id/useId对应的状态位,如果有记录一定是有上课记录的(with key find matcher value)
     */
    @Override
    public Map<Long, Boolean> hasClassRecord(Integer orgId, Collection<Long> teacherIds, Boolean... isId) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyMap();
        }
        Map<Long, Boolean> retMap = Maps.newHashMap();
        boolean isIdQuery = (GenericsUtils.notNullAndEmpty(isId) ? isId[0] : true); // 默认是走ID查询
        Map<Long, OrgTeacherDocument> docMap = null;
        try {
            docMap = this.queryOrgTeachersWithIds(orgId, teacherIds, isIdQuery);
        } catch (Exception e) {
            // 暂时不加,后面填坑的自己处理这里
            // docMap = this.queryOrgTechersWithDB(orgId, teacherIds, isIdQuery);
            GenericsUtils.logErrorAndInfo(log, e, " can not queryOrgTeachersWithIds teacherIds", teacherIds);
            return Maps.newHashMap();
        }
        log.info("docMap are :{} ", docMap);
        if (GenericsUtils.notNullAndEmpty(docMap)) {
            for (Long teacherId : teacherIds) {
                boolean isHas = false;
                OrgTeacherDocument otd = docMap.get(teacherId);
                if (otd != null) {
                    if (otd.getFinishedClassTime() > 0) {
                        isHas = true;
                    }
                    retMap.put(teacherId, isHas);
                }
            }
        }
        return retMap;
    }

    /**
     * @param orgId
     * @param teacherIds
     * @param isId
     * @return
     */
    public Map<Long, OrgTeacherDocument> queryOrgTechersWithDB(Integer orgId, Collection<Long> teacherIds,
                                                               Boolean isId) {
        Collection<OrgTeacher> orgTeachers = Lists.newArrayList();
        if (isId) {
            orgTeachers = this.orgTeacherDao.getTeachersByOrgIdAndIds(orgId, teacherIds);
        } else {
            orgTeachers = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId.longValue(), teacherIds, null, null);
        }
        Date beginDate = null;
        Date endDate = DateUtil.getEndOfMonth();
        Map<Long, OrgTeacherDocument> createOrgTeacherDocuments = orgTeacherForSolrService
                .createOrgTeacherDocuments(orgId.longValue(), orgTeachers, beginDate, endDate, false);
        return createOrgTeacherDocuments;
    }

    /**
     * @param orgId
     * @param teacherIds
     * @param isIdQuery
     * @return
     */
    private Map<Long, OrgTeacherDocument> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds,
                                                                  boolean isIdQuery) {
        List<Map<String, Object>> listByQuery =
                this.orgTeacherDocumentMongoDbDao.queryOrgTeachersWithIds(orgId, teacherIds, isIdQuery);
        List<OrgTeacherDocument> retDocuments = OrgTeacherDocument.buidOrgTeacherDocumentFromMap(listByQuery);
        String queryField = isIdQuery ? "orgTeacherId" : "teacherUserId";
        Map<Long, OrgTeacherDocument> docMap = GenericsUtils.toFieldMap(retDocuments, queryField);
        return docMap;
    }

    /**
     * @param teacherByUserIdsAndOrgId
     * @return
     */

    private Map<Long, OrgTeacher> getAllNormalTeachers(List<OrgTeacher> teacherByUserIdsAndOrgId) {
        Map<Long, OrgTeacher> extractMap =
                com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(teacherByUserIdsAndOrgId,
                        new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, OrgTeacher>() {
                            @Override
                            public Long extract(OrgTeacher arg0) {
                                return arg0.getUserId();
                            }
                        });
        return extractMap;
    }

}
