package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/11/15.
 */
@Service
public class AccountApiServiceImpl implements AccountApiService {

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;

    @Override
    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "未知";
        if (cascadeId!=null && cascadeId > 0) {// 子账号
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            TXCascadeCredential credential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
            shortName = credential.getName();
        } else {// 主账号
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    @Override
    public String getCascadeAvatar(int cascadeId){
        TXCascadeAccount tca = txCascadeAccountDao.getById(cascadeId);
        Preconditions.checkNotNull(tca, "该cascadeId:" + cascadeId + "找不到对应的TXCascadeAccount!");
        TXCascadeCredential txc = txCascadeCredentialDao.getById(tca.getCredentialId());
        if(StringUtils.isNotBlank(txc.getAvatar())){
            return txc.getAvatar();
        }
        return AvatarConstants.STUFF_AVATAR_URL;
    }

    @Override
    public Map<Long,String> getAccountNameMap(Long orgId, Collection<Integer> cascadeIds){
        Map<Long, String> map = credentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        if(cascadeIds.contains(0)){
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            map.put(0L,orgInfo.getContacts());
        }
        return map;
    }

    @Override
    public List<Integer> getAllTxOrgIds() {
        List<OrgSubAccount> accounts = this.subAccountDao.getAll(new String[]{"orgId"});
        List<Integer> list = ListUtil.toKeyList(accounts, "orgId", OrgSubAccount.class);
        return list;
    }

    @Override
    public OrgInfo getMasterOrgInfo(long orgId) {
        OrgSubAccount subAccount = subAccountDao.getByOrgId((int)orgId);
        Long masterId = null;
        if (subAccount.getPid()!=null && subAccount.getPid()>0){
            masterId = subAccount.getPid().longValue();
        }else {
            masterId = orgId;
        }
        return orgInfoDao.getOrgInfo(masterId.intValue());
    }
}
