
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 26, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
public class KexiaoStatisticsSuper {

    // 请求参数---begin---
    private Long studentId; // @Request=false
    @JsonIgnore
    private Long userId; // @Request
    private Long courseId; // @Request=false
    private Long parentCourseId;// 针对一对一班级而言,对应课程的id,orgSignupCourse的报名记录是针对课程而言的.
    // 请求参数---end---

    // 填充数据----begin----
    private String remainTuition; // 剩余学费
    @JsonIgnore
    private Long remainTuitionValue; // 剩余学费数字表示
    private String totalClassTimesForKexiao;
    private String finishClassTimesForKexiao;
    private String leftClassTimesForKexiao;
    private String buyClassTimesForKexiao;
    private int scheduleStatus = 1;//是否能继续排正价课
    private int buyCount;//购买次数
    @JsonIgnore
    private Integer totalClassTimesForKexiaoValue = 0; // 如果按照小时/半小时(单位为分钟)|如果为次
    @JsonIgnore
    private Integer finishClassTimesForKexiaoValue = 0;
    @JsonIgnore
    private Integer leftClassTimesForKexiaoValue = 0;
    private Integer chargeUnitType = ChargeUnit.BY_TIMES.getCode(); // 默认为按次
    @JsonIgnore
    private Integer kexiaoInfoFillStatus = 1; // 0:未补充完成 1:补充完成 ,用于判断当前端上是否展示 --/tipInfo,针对某个学员所有课程而言
    @JsonIgnore
    private boolean currentCourseCanSetInfo = true; // 针对某门课程是否能够设置课消信息,单独控制某门课程上tipInfo/remainTuition
    @JsonIgnore
    private boolean hasSignupCourseRecord = true; // 是否有报名记录(该字段只用于单个班级情况判断)
    @JsonIgnore
    private boolean canShowTotalKexiaoInfo; // 学员详情统计所有班级时候信息的补充情况,用于判断前端是否能够展示剩余学费(任何一门课可以展示数据)
    // 填充数据----end----

    // 业务传输数据
    @JsonIgnore
    private Integer orgStudentCourseStatus;
    private boolean hasLesson;

    public static KexiaoStatisticsSuper newInstanceWithUserId() {
        return new KexiaoStatisticsSuper();
    }

    /**
     * @param studentId
     * @param userId
     */
    public static KexiaoStatisticsSuper newInstance(Long studentId, Long userId) {
        return newInstance(studentId, userId, null);
    }

    public static KexiaoStatisticsSuper newInstance(Long studentId, Long userId, Long courseId) {
        KexiaoStatisticsSuper kss = new KexiaoStatisticsSuper();
        kss.setStudentId(studentId);
        kss.setUserId(userId);
        kss.setCourseId(courseId);
        return kss;
    }

    /**
     * 主要用于展示tipInfo
     * 
     * @return
     */
    public boolean isKexiaoFillOver() {
        return this.kexiaoInfoFillStatus == 1;
    }

    /**
     * 主要控制能否展示学费
     * 
     * @return
     */
    public boolean isCanShowKexiaoInfo() {
        return canShowTotalKexiaoInfo;
    }

}
