package com.baijia.tianxiao.sal.common.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by wengshengli on 2017/8/25.
 */
public enum ProducePointType {

    SIGNUP(1, "ORG_SIGNUP_INFO", "报名"),
    RECHARGE(2, "ORG_SIGNUP_INFO", "充值"),
    TIMECARD(3, "ORG_SIGNUP_INFO", "合同次卡"),
    CLASS_REFUND(4, "ORG_SIGNUP_REFUND", "退班退款"),
    STUDENT_REFUND(5, "TX_STUDENT_FINANCE_RECORD", "学生余额账户退款"),
    TRANFER_REFUND(6, "TX_TRANSFER_CLASS_RECORD", "转班退款"),
    TIMESCARD_REFUND(7,"TX_PURCHASE_TIMESCARD_REFUND","合同次卡退款");

    private int type;
    private String tableName;
    private String label;

    private static Map<Integer, ProducePointType> cache;

    static {
        cache = Maps.newHashMap();
        for (ProducePointType producePointType : ProducePointType.values()) {
            cache.put(producePointType.type, producePointType);
        }
    }

    ProducePointType(int type, String tableName, String label) {
        this.type = type;
        this.tableName = tableName;
        this.label = label;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static ProducePointType get(int type) {
        return cache.get(type);
    }
}
