/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherApiServiceImpl
implements OrgTeacherApiService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherApiServiceImpl.class);
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private StorageDao storageDao;

    @Override
    public Map<Long, TwoTuple<String, String>> getNameAndAvatarByUserIds(Long orgId, Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        List orgTeachers = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, userIds, null, null, new String[0]);
        return this.buildTeacherBaseMap(orgTeachers);
    }

    private Map<Long, TwoTuple<String, String>> buildTeacherBaseMap(List<OrgTeacher> orgTeachers) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(orgTeachers)) {
            return result;
        }
        List teachers = this.teacherDao.getByUserIds((Collection)orgTeachers.stream().map(orgTeacher -> orgTeacher.getUserId()).collect(Collectors.toList()), new String[0]);
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, teacher -> teacher.getUserId());
        Map storageIds = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher teacher) {
                return teacher.getAvatar();
            }
        });
        List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        for (OrgTeacher orgTeacher2 : orgTeachers) {
            Storage storage;
            Teacher teacher2 = (Teacher)teacherMap.get(orgTeacher2.getUserId());
            String name = null;
            String avatar = null;
            if (teacher2 != null) {
                name = teacher2.getRealName();
            }
            if (teacher2.getAvatar() != null && (storage = (Storage)storageMap.get(teacher2.getAvatar())) != null) {
                String avatarUrl;
                avatar = avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
            }
            avatar = (String)StringUtils.defaultIfBlank(avatar, (CharSequence)"https://imgs.genshuixue.com/21644918_xqjeiipb.png");
            TwoTuple tuple = new TwoTuple((Object)name, (Object)avatar);
            result.put(orgTeacher2.getUserId(), tuple);
        }
        return result;
    }
}

