/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.utils;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentNotifyMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.CourseNotifyWechatMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.SignWechatTemplateMsg;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatTemplateMsgHelper {
    private static final Logger log = LoggerFactory.getLogger(WechatTemplateMsgHelper.class);

    public static SendMsgRequest createSendMsgRequestToStu(Long orgId, String mobile, Long studentId, String weixinOpenId, String smsContent, WechateTemplateMsgType wechatType, WechatMsgTypeSuper typeMsg) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgId);
        request.setMobile(mobile);
        request.setCountSms(false);
        request.setReceiverId(studentId);
        request.setWeixinOpenId(weixinOpenId);
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgId);
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(wechatType.getValue());
        request.setSmsContent(smsContent);
        Map<Object, Object> wechatParams = null;
        log.info("WechatMsgTypeSuper is:{} {}", (Object)typeMsg, (Object)"");
        switch (typeMsg.getType()) {
            case SIGNUP_WECHAT_TEMPLATE: {
                wechatParams = WechatTemplateMsgHelper.createSignWechatTempateMsg((SignWechatTemplateMsg)typeMsg);
                break;
            }
            case COURSE_NOTIFY_WECHAT_TEMPLATE: {
                wechatParams = WechatTemplateMsgHelper.createCourseNotifyWechatMsg((CourseNotifyWechatMsg)typeMsg);
                break;
            }
            case AFTER_COURSE_COMMENT_WECHAT_TEMPLATE: {
                wechatParams = WechatTemplateMsgHelper.createAfterCourseCommentWechatMsg((AfterCourseCommentMsg)typeMsg);
                break;
            }
            case AFTER_COURSE_COMMENT_NOTIFY_WECHAT_TEMPLATE: {
                wechatParams = WechatTemplateMsgHelper.createAfterCourseNotifyWechatMsg((AfterCourseCommentNotifyMsg)typeMsg);
                break;
            }
            default: {
                wechatParams = Maps.newHashMap();
            }
        }
        request.setWechatParams(wechatParams);
        return request;
    }

    public static Map<String, Object> createSignWechatTempateMsg(SignWechatTemplateMsg msgRequest) {
        HashMap params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msgRequest.getType();
        String first = String.format(type.first, msgRequest.getStudentName(), msgRequest.getOrgName(), msgRequest.getSignStatusStr(), msgRequest.createTimeRangeStr());
        String remark = String.format(type.remark, msgRequest.getExtension());
        WechatTemplateMsgHelper.fillParams(params, type, first, remark, msgRequest.getScheduleUrl(), msgRequest.getStudentName(), msgRequest.getSignTimeStr(), msgRequest.getCourseName(), msgRequest.getTeacherName());
        return params;
    }

    public static Map<String, Object> createCourseNotifyWechatMsg(CourseNotifyWechatMsg msg) {
        HashMap params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getStudentName(), msg.getCourseName());
        String remark = String.format(type.remark, msg.getExtension());
        WechatTemplateMsgHelper.fillParams(params, type, first, remark, msg.getScheduleUrl(), msg.getCourseTimeRange(), msg.getTeacherName(), msg.getCourseName(), msg.getRoomName());
        return params;
    }

    public static Map<String, Object> createAfterCourseCommentWechatMsg(AfterCourseCommentMsg msg) {
        HashMap params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getStudentName(), msg.getCourseName());
        WechatTemplateMsgHelper.fillParams(params, type, first, type.remark, msg.getCommentUrl(), msg.getStudentName(), msg.getCourseName(), msg.getTeacherName());
        return params;
    }

    public static Map<String, Object> createAfterCourseNotifyWechatMsg(AfterCourseCommentNotifyMsg msg) {
        HashMap params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getTeacherName(), msg.getCourseTimeStr());
        WechatTemplateMsgHelper.fillParams(params, type, first, type.remark, msg.getCommentUrl(), msg.getStudentName(), msg.getCourseName(), msg.getTeacherName());
        return params;
    }

    private static void fillParams(Map<String, Object> params, TxWechatTemplateMsgType type, String first, String remark, String url, String ... keywords) {
        if (type == null) {
            return;
        }
        params.put("first", WechatTemplateMsgHelper.createFirst(first, type.firstColor));
        params.put("remark", WechatTemplateMsgHelper.createRemark(remark, type.remarkColor));
        params.put("url", url);
        String[] typeKeywords = type.keywords;
        if (GenericsUtils.notNullAndEmpty((Object)typeKeywords)) {
            if (GenericsUtils.isNullOrEmpty((Object)keywords) || typeKeywords.length != keywords.length) {
                log.warn("type:{} expect keywork:{} but not match the params:{} ", new Object[]{type, ToStringBuilder.reflectionToString((Object)typeKeywords), ToStringBuilder.reflectionToString((Object)keywords)});
                return;
            }
            List<String> keywordList = Arrays.asList(keywords);
            for (int i = 1; i <= typeKeywords.length; ++i) {
                params.put("keyword" + i, WechatTemplateMsgHelper.createKeyword(keywordList.get(i - 1), type.keywordColor));
            }
        }
        log.info("for type:{} and after fill info , the wechatParams is:{} ", (Object)type, params);
    }

    public static JSONObject createFirst(String value, String color) {
        return WechatTemplateMsgHelper.getTemplateMsgNode(value, color);
    }

    public static JSONObject createRemark(String value, String color) {
        return WechatTemplateMsgHelper.getTemplateMsgNode(value, color);
    }

    public static JSONObject createKeyword(String value, String color) {
        return WechatTemplateMsgHelper.getTemplateMsgNode(value, color);
    }

    public static JSONObject getTemplateMsgNode(String value, String color) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"value", (Object)value);
        obj.put((Object)"color", (Object)color);
        return obj;
    }
}

