/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;

public class KexiaoStatisticsBuilder {
    private OrgSignupCourse signupCourse;
    private OrgSignupCourseLesson arrangedNormalLesson;
    private OrgSignupCourseLesson arrangedFreeLesson;
    private OrgSignupCourseLesson kexiaoNormalLesson;
    private OrgSignupCourseLesson kexiaoFreeLesson;
    private TxTransferClassRecord transferRecord;
    private OrgSignupRefund refundRecord;
    private KexiaoStatistics stat;

    public KexiaoStatisticsBuilder() {
    }

    public KexiaoStatisticsBuilder(KexiaoStatistics stat) {
        this.stat = stat;
    }

    public KexiaoStatisticsBuilder addSignupCourse(OrgSignupCourse signupCourse) {
        this.signupCourse = signupCourse;
        return this;
    }

    public KexiaoStatisticsBuilder addArrangedNormalLesson(OrgSignupCourseLesson arrangedNormalLesson) {
        this.arrangedNormalLesson = arrangedNormalLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addArrangedFreeLesson(OrgSignupCourseLesson arrangedFreeLesson) {
        this.arrangedFreeLesson = arrangedFreeLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addKexiaoNormalLesson(OrgSignupCourseLesson kexiaoNormalLesson) {
        this.kexiaoNormalLesson = kexiaoNormalLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addKexiaoFreeLesson(OrgSignupCourseLesson freeLesson) {
        this.kexiaoFreeLesson = freeLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addRefundRecord(OrgSignupRefund refundRecord) {
        this.refundRecord = refundRecord;
        return this;
    }

    public KexiaoStatisticsBuilder addTransferRecord(TxTransferClassRecord transferRecord) {
        this.transferRecord = transferRecord;
        return this;
    }

    public KexiaoStatistics build() {
        this.stat.setChargeUnit(this.signupCourse.getChargeUnit());
        this.stat.setContractNumber(KexiaoUtil.getClassNumber(this.signupCourse));
        this.stat.setContractAmount(this.signupCourse.getTotalPayPrice());
        this.stat.setClassId(this.signupCourse.getClassId());
        if (this.signupCourse.getLessonCount() > 0) {
            this.stat.setCompleteStatus(0);
        }
        if (this.arrangedNormalLesson != null) {
            if (ChargeUnit.isByTime((int)this.signupCourse.getChargeUnit())) {
                this.stat.setArrangeNormalNumber(this.arrangedNormalLesson.getLessonDuration().intValue());
            } else {
                this.stat.setArrangeNormalNumber(this.arrangedNormalLesson.getLessonCount());
            }
            this.stat.setArrangeNormalAmount(this.arrangedNormalLesson.getAmount());
        }
        if (this.arrangedFreeLesson != null) {
            if (ChargeUnit.isByTime((int)this.signupCourse.getChargeUnit())) {
                this.stat.setArrangeFreeNumber(this.arrangedFreeLesson.getLessonDuration().intValue());
            } else {
                this.stat.setArrangeFreeNumber(this.arrangedFreeLesson.getLessonCount());
            }
        }
        if (this.kexiaoNormalLesson != null) {
            if (ChargeUnit.isByTime((int)this.signupCourse.getChargeUnit())) {
                this.stat.setKexiaoNormalNumber(this.kexiaoNormalLesson.getLessonDuration().intValue());
            } else {
                this.stat.setKexiaoNormalNumber(this.kexiaoNormalLesson.getLessonCount());
            }
            this.stat.setKexiaoNormalAmount(this.kexiaoNormalLesson.getAmount());
        }
        if (this.kexiaoFreeLesson != null) {
            if (ChargeUnit.isByTime((int)this.signupCourse.getChargeUnit())) {
                this.stat.setKexiaoFreeNumber(this.kexiaoFreeLesson.getLessonDuration().intValue());
            } else {
                this.stat.setKexiaoFreeNumber(this.kexiaoFreeLesson.getLessonCount());
            }
        }
        if (this.transferRecord != null) {
            this.stat.setTransferAmount(this.transferRecord.getLessonMoney().intValue());
            this.stat.setTransferNormalNumber(this.transferRecord.getRealLessonCount().intValue());
            this.stat.setTransferFreeNumber(this.transferRecord.getFreeLessonCount().intValue());
        }
        if (this.refundRecord != null) {
            this.stat.setRefundAmount(this.refundRecord.getRefundFee() + this.refundRecord.getRefundFee());
            this.stat.setRefundNormalNumber(this.refundRecord.getRefundLessonCount().intValue());
        }
        return this.stat;
    }
}

