/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.callservice.constant.OrgCallStatus;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.FollowType;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXStudentCommentAPIServiceImpl
implements TXStudentCommentAPIService {
    private static final Logger log = LoggerFactory.getLogger(TXStudentCommentAPIServiceImpl.class);
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private AccountApiService accountApiService;
    private static final String chargeByPeriods = "[%s]\u5b9e\u4ea4\uff1a\uffe5%s, \u603b\u8bfe\u6b21\uff1a%s\u6b21";
    private static final String chargeByClassHour = "[%s]\u5b9e\u4ea4\uff1a\uffe5%s\uff0c\u603b\u8bfe\u65f6\uff1a%s\u5c0f\u65f6";
    private static final String chargeByTimes = "[%s]\u5b9e\u4ea4\uff1a\uffe5%s\uff0c\u603b\u8bfe\u6b21\uff1a%s\u6b21";
    private static final String charegeByOthers = "[%s]\u603b\u4ef7:\u00a5%s";
    private static final String transferClassByPeriods = "[%s]\u603b\u4ef7\uff1a\uffe5%s\uff0c\u603b\u8bfe\u6b21\uff1a%s\u6b21\u3002";
    private static final String transferClassByHour = "[%s]\u603b\u4ef7\uff1a\uffe5%s\uff0c\u603b\u8bfe\u65f6\uff1a%s\u5c0f\u65f6\u3002";
    private static final String transferClassByTimes = "[%s]\u603b\u4ef7\uff1a\uffe5%s\uff0c\u603b\u8bfe\u6b21\uff1a%s\u6b21\u3002";
    public static final String QUIT_CLASS_TO_ACCOUNT_FORMAT = "\u9000\u73ed\uff1a[%s]\u9000\u5b66\u8d39\uffe5%s\uff0c\u5b66\u8d39\u9000\u81f3\u5b66\u751f\u8d26\u6237";
    public static final String QUIT_CLASS_TO_MONEY_FORMAT = "\u9000\u73ed\uff1a[%s]\u9000\u5b66\u8d39\uffe5%s\uff0c\u5b66\u8d39\u4ee5\u73b0\u91d1\u65b9\u5f0f\u9000\u56de";
    public static final String REFUND_CASH_FORMAT = "\u5b66\u751f\u8d26\u6237\u652f\u51fa\uffe5%s\u7528\u4e8e\u9000\u6b3e\u7ed9\u5b66\u5458";
    public static final String SIGNUP_PAY_FORMAT = "\u5b66\u751f\u8d26\u6237\u652f\u51fa\uffe5%s\u7528\u4e8e\u62a5\u540d[%s]";
    public static final String RECHARGE_FORMAT = "\u5b66\u751f\u8d26\u6237\u5145\u503c\uffe5%s";

    @Override
    public TxStudentComment saveTxStudentComment(TxStudentComment comment) {
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    TxStudentComment buildTxStudentComment(TxConsultUser consultUser) {
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setOrigin(consultUser.getConsultSource().intValue());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setType(Integer.valueOf(0));
        return comment;
    }

    @Override
    public TxStudentComment saveByOrgActivitySignUp(TxConsultUser consultUser, String activityName, String userName, String mobile, String award) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        StringBuffer content = new StringBuffer("\u6d3b\u52a8\u540d\u79f0\uff1a");
        content.append(activityName).append("\n");
        content.append("\u59d3\u540d\uff1a").append(userName).append("\n");
        content.append("\u7535\u8bdd\u53f7\u7801\uff1a").append(mobile);
        if (StringUtils.isNotBlank((CharSequence)award)) {
            content.append("\n").append("\u4e2d\u5956\u4fe1\u606f\uff1a").append(award);
        }
        comment.setContent(content.toString());
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByOrgCall400(TxConsultUser consultUser, OrgPushCallInfo callInfo, boolean isNewConsultUser) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        if (isNewConsultUser) {
            comment.setContent("\u7cfb\u7edf\u6dfb\u52a0\u4e86\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u8bbf\u5ba2") + "\n");
        } else {
            comment.setContent("");
        }
        if (callInfo.getStatus().intValue() == OrgCallStatus.CONNECTED.getCode()) {
            if (null != callInfo.getStorageId() && callInfo.getStorageId() > 0L) {
                comment.setSoundId(callInfo.getStorageId());
                comment.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
            } else {
                comment.setSoundId(callInfo.getId());
                comment.setDownStatus(Integer.valueOf(DownLoadStatus.UNFINISH.getCode()));
            }
            comment.setSeconds(Integer.valueOf(callInfo.getDuringTime()));
        }
        comment.setCallStatus(callInfo.getStatus());
        comment.setIsMobile(Integer.valueOf(MobileStatus.IS_400_CALL.getCode()));
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByAdvisory(TxConsultUser consultUser, Long userId, String advisoryWords, boolean isNewConsultUser) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        StringBuffer content = new StringBuffer();
        if (isNewConsultUser) {
            content.append("\u7cfb\u7edf\u6dfb\u52a0\u4e86\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u5728\u7ebf\u7559\u5355\u5b66\u751f") + "\n");
        }
        content.append("\u7559\u5355\u5185\u5bb9: " + (StringUtils.isNotBlank((CharSequence)advisoryWords) ? advisoryWords : "\u65e0"));
        comment.setContent(content.toString());
        comment.setUserId(userId);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByConsultUserManualAdd(TxConsultUser consultUser) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "\u6dfb\u52a0\u4e86\u7ebf\u7d22 %s";
        contentFmt = String.format(contentFmt, consultUser.getName());
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByConsultUserAssign(TxConsultUser consultUser, String ownerName) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "%s \u88ab\u5206\u914d\u4e86 %s \u8fd9\u6761\u7ebf\u7d22.";
        contentFmt = String.format(contentFmt, ownerName, consultUser.getName());
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByConsultUserPull(TxConsultUser consultUser, String operatorName) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "%s \u9886\u53d6\u4e86 %s \u8fd9\u6761\u7ebf\u7d22.";
        contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByConsultUserPush(TxConsultUser consultUser, String operatorName) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "%s \u628a\u7ebf\u7d22\u91ca\u653e\u56de\u516c\u6d77.";
        contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public void batchSaveByRelease(List<Long> consulterIds) {
        ArrayList<TxStudentComment> list = new ArrayList<TxStudentComment>();
        String content = "\u7ebf\u7d22\u5230\u671f \u81ea\u52a8\u91ca\u653e\u56de\u516c\u6d77.";
        for (int i = 0; i < consulterIds.size(); ++i) {
            TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterIds.get(i), new String[0]);
            TxStudentComment comment = this.buildTxStudentComment(consultUser);
            comment.setContent(content);
            list.add(comment);
            if ((i == 0 || i % 100 != 0) && i != consulterIds.size() - 1) continue;
            this.txStudentCommentDao.saveAll(list, false, new String[0]);
            list = new ArrayList();
        }
    }

    @Override
    public TxStudentComment saveByConsultUserChangeStatus(TxConsultUser consultUser, String operatorName, String reason) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "";
        if (consultUser.getIsInvalid().intValue() == Flag.FALSE.getInt()) {
            contentFmt = "%s \u5c06\u7ebf\u7d22 %s \u7684\u72b6\u6001\u4fee\u6539\u4e3a\u6709\u6548.";
            contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
        } else {
            contentFmt = "%s \u5c06\u7ebf\u7d22 %s \u7684\u72b6\u6001\u4fee\u6539\u4e3a\u65e0\u6548.\n\u6807\u8bb0\u539f\u56e0:%s";
            contentFmt = String.format(contentFmt, operatorName, consultUser.getName(), reason);
        }
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByConsultUserPassTo(TxConsultUser consultUser, String from, String to) {
        TxStudentComment comment = this.buildTxStudentComment(consultUser);
        String contentFmt = "%s \u628a\u7ebf\u7d22\u8f6c\u4ea4\u7ed9 %s";
        contentFmt = String.format(contentFmt, from, to);
        comment.setContent(contentFmt);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByMobileChange(TxConsultUser consultUser, String oldMobile, String newMobile) {
        if (!oldMobile.equals(newMobile)) {
            TxStudentComment comment = this.buildTxStudentComment(consultUser);
            String contentFmt = " \u5c06\u624b\u673a\u53f7\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011";
            contentFmt = String.format(contentFmt, oldMobile, newMobile);
            comment.setContent(contentFmt);
            this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
            return comment;
        }
        return null;
    }

    @Override
    public TxStudentComment saveByNameChange(TxConsultUser consultUser, String oldName, String newName) {
        if (!oldName.equals(newName)) {
            TxStudentComment comment = this.buildTxStudentComment(consultUser);
            String contentFmt = " \u5c06\u59d3\u540d\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011";
            contentFmt = String.format(contentFmt, oldName, newName);
            comment.setContent(contentFmt);
            this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
            return comment;
        }
        return null;
    }

    @Override
    public TxStudentComment saveByStudentMerge(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        List comments = this.txStudentCommentDao.getComments(sourceConsultUser.getId(), orgId, Integer.valueOf(StudentType.CONSULT_USER.getCode()), new String[0]);
        if (comments != null && !comments.isEmpty()) {
            for (TxStudentComment comment : comments) {
                comment.setConsultUserId(destConsultUser.getId());
                comment.setUserId(destConsultUser.getUserId());
                comment.setUpdateTime(new Date());
                this.txStudentCommentDao.update((Object)comment, new String[]{"consultUserId", "userId", "updateTime"});
            }
        }
        String sourceName = sourceConsultUser.getName();
        String sourceNickName = sourceConsultUser.getNickName();
        String destName = destConsultUser.getName();
        String destNickName = destConsultUser.getNickName();
        String sourceMobile = sourceConsultUser.getMobile();
        String destMobile = destConsultUser.getMobile();
        StringBuffer sb = new StringBuffer();
        sb.append("\u60a8\u5c06\u5b66\u751f\u3010" + this.getConsulterName(sourceName, sourceNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)sourceMobile)) {
            sb.append("\u3010" + sourceMobile + "\u3011");
        }
        sb.append("\u548c\u5b66\u751f\u3010" + this.getConsulterName(destName, destNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)destMobile)) {
            sb.append("\u3010" + destMobile + "\u3011");
        }
        sb.append("\u5408\u5e76\u4e86");
        TxStudentComment addComment = new TxStudentComment();
        addComment.setCallStatus(Integer.valueOf(0));
        addComment.setConsultUserId(destConsultUser.getId());
        addComment.setUserId(destConsultUser.getUserId());
        addComment.setOrgId(orgId);
        addComment.setCreateTime(new Date());
        addComment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        addComment.setContent(sb.toString());
        this.txStudentCommentDao.save((Object)addComment, new String[0]);
        if (addComment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(addComment.getOrgId(), addComment.getUserId());
        }
        log.info("orgId:{}, addComment:{}", (Object)orgId, (Object)addComment);
        return addComment;
    }

    private String getConsulterName(String source, String dest) {
        return StringUtils.isNotBlank((CharSequence)source) ? source : (StringUtils.isNotBlank((CharSequence)dest) ? dest : "\u533f\u540d\u7528\u6237");
    }

    public static void main(String[] args) {
        System.out.println(new DecimalFormat("0.00").format(0.01));
        System.out.println(new DecimalFormat("0.00").format(0.0));
        System.out.println(new DecimalFormat("0.00").format(123.0));
        System.out.println(new DecimalFormat("0.00").format(12.34));
    }

    @Override
    public TxStudentComment saveBySignUpPurchase(OrgSignupInfo orgSignupInfo, String courseNames) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u62a5\u73ed:[").append(courseNames).append("]\u603b\u4ef7:\u00a5");
        if (orgSignupInfo.getTotalPrices().equals(0)) {
            sb.append("0.00").append("\u5143");
        } else {
            sb.append(new DecimalFormat("#.00").format(orgSignupInfo.getTotalPrices().doubleValue() / 100.0)).append("\u5143");
        }
        TxStudentComment comment = new TxStudentComment();
        comment.setOrgId(orgSignupInfo.getOrgId());
        comment.setUserId(orgSignupInfo.getUserId());
        comment.setCreateTime(orgSignupInfo.getUpdateTime());
        comment.setUpdateTime(orgSignupInfo.getUpdateTime());
        comment.setContent(sb.toString());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setFollowType(Integer.valueOf(FollowType.SIGNUP_COURSE.getType()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByCoursePurchase(Long orgId, Long userId, Date createTime, String courseName, Double price) {
        String content = "\u62a5\u73ed:[%s]\u603b\u4ef7:\u00a5%s\u5143";
        content = String.format(content, courseName, price);
        TxStudentComment comment = new TxStudentComment();
        comment.setOrgId(orgId);
        comment.setUserId(userId);
        comment.setCreateTime(createTime);
        comment.setUpdateTime(createTime);
        comment.setContent(content);
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setFollowType(Integer.valueOf(FollowType.SIGNUP_COURSE.getType()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByAddStudent(OrgStudent student) {
        TxStudentComment comment = new TxStudentComment();
        if (StringUtils.isNotEmpty((CharSequence)student.getName())) {
            comment.setContent("\u6dfb\u52a0\u5b66\u5458 " + student.getName());
        } else {
            comment.setContent("\u6dfb\u52a0\u5b66\u5458 " + student.getNickName());
        }
        comment.setOrgId(student.getOrgId());
        comment.setUserId(student.getUserId());
        comment.setCreateTime(student.getCreateTime());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByStudentPassTo(OrgStudent student, String from, String to) {
        TxStudentComment comment = new TxStudentComment();
        String contentFmt = "%s \u628a\u5b66\u5458\u8f6c\u4ea4\u7ed9 %s";
        contentFmt = String.format(contentFmt, from, to);
        comment.setContent(contentFmt);
        comment.setOrgId(student.getOrgId());
        comment.setUserId(student.getUserId());
        comment.setCreateTime(new Date());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveBySignUpPurchase(OrgSignupInfo orgSignupInfo, Map<Long, OrgSignupCourse> orgSignupCourseMap, Map<Long, OrgCourse> orgCourseMap) {
        if (GenericsUtils.isNullOrEmpty(orgSignupCourseMap)) {
            log.info("can not find any signupCourse info :{}", (Object)orgSignupInfo);
            return null;
        }
        log.info("orgSignupCourseMap is:{} and orgCourseMap is:{} ", orgSignupCourseMap, orgCourseMap);
        StringBuilder sb = new StringBuilder("");
        if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            sb.append("\u8f6c\u73ed\u62a5\u540d: ");
        } else {
            sb.append("\u62a5\u73ed: ");
        }
        for (Map.Entry<Long, OrgCourse> entry : orgCourseMap.entrySet()) {
            int totalCount;
            int times;
            int count;
            Long courseId = entry.getKey();
            OrgSignupCourse osc = orgSignupCourseMap.get(courseId);
            if (osc == null) continue;
            OrgCourse oc = entry.getValue();
            int chargeType = oc.getChargeType();
            int chargeUnit = osc.getChargeUnit();
            String className = oc.getName();
            double balance = (double)osc.getTotalPayPrice().longValue() / 100.0;
            String balanceStr = new DecimalFormat("0.00").format(balance);
            int n = count = osc.getLessonCount() == 0 ? 1 : osc.getLessonCount();
            if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                if (ChargeType.chargeByPeriods((int)chargeType, (int)chargeUnit)) {
                    times = osc.getLessonCount();
                    sb.append(String.format("[%s]\u603b\u4ef7\uff1a\uffe5%s\uff0c\u603b\u8bfe\u6b21\uff1a%s\u6b21\u3002", className, balanceStr, times));
                } else if (ChargeType.chargeByClassHour((int)chargeType, (int)chargeUnit)) {
                    totalCount = this.countClassHour(count, chargeUnit);
                    sb.append(String.format(transferClassByHour, className, balanceStr, totalCount));
                } else {
                    sb.append(String.format("[%s]\u603b\u4ef7\uff1a\uffe5%s\uff0c\u603b\u8bfe\u6b21\uff1a%s\u6b21\u3002", className, balanceStr, count));
                }
                sb.append("\u539f\u73ed\u8f6c\u51fa\u91d1\u989d\uffe5" + new DecimalFormat("0.00").format((double)orgSignupInfo.getTransferClassMoney().longValue() / 100.0));
                if (orgSignupInfo.getTransferRefundMoney() > 0L) {
                    if (orgSignupInfo.getTransferRefundType() == 1) {
                        sb.append("\uff0c\u73b0\u91d1\u9000\u6b3e\uffe5").append(new DecimalFormat("0.00").format((double)orgSignupInfo.getTransferRefundMoney().longValue() / 100.0));
                    } else {
                        sb.append("\uff0c\u9000\u6b3e\u81f3\u5b66\u751f\u8d26\u6237\uff1a\uffe5").append(new DecimalFormat("0.00").format((double)orgSignupInfo.getTransferRefundMoney().longValue() / 100.0));
                    }
                } else if (orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice() > 0L) {
                    sb.append("\uff0c\u8865\u6b3e\u5b9e\u4ea4\uff1a\uffe5").append(new DecimalFormat("0.00").format((orgSignupInfo.getTotalPrices().doubleValue() + orgSignupInfo.getStudentPayPrice().doubleValue()) / 100.0));
                }
                sb.append("  ");
                continue;
            }
            if (ChargeType.chargeByPeriods((int)chargeType, (int)chargeUnit)) {
                times = osc.getLessonCount();
                sb.append(String.format(chargeByPeriods, className, balanceStr, times)).append(",");
                continue;
            }
            if (ChargeType.chargeByClassHour((int)chargeType, (int)chargeUnit)) {
                totalCount = this.countClassHour(count, chargeUnit);
                sb.append(String.format(chargeByClassHour, className, balanceStr, totalCount)).append(",");
                continue;
            }
            if (ChargeType.chargeByTimes((int)chargeType, (int)chargeUnit)) {
                sb.append(String.format(chargeByTimes, className, balanceStr, count)).append(",");
                continue;
            }
            sb.append(String.format(charegeByOthers, className, balanceStr)).append(",");
        }
        String commentInfo = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
        TxStudentComment comment = new TxStudentComment();
        comment.setOrgId(orgSignupInfo.getOrgId());
        comment.setUserId(orgSignupInfo.getUserId());
        comment.setCreateTime(orgSignupInfo.getUpdateTime());
        comment.setUpdateTime(orgSignupInfo.getUpdateTime());
        comment.setContent(commentInfo);
        comment.setType(Integer.valueOf(1));
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            comment.setFollowType(Integer.valueOf(FollowType.TRANSFER_CLASS.getType()));
        } else {
            comment.setFollowType(Integer.valueOf(FollowType.SIGNUP_COURSE.getType()));
        }
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        return comment;
    }

    private int countClassHour(int count, int chargeUnit) {
        if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
            return count * 5 / 10;
        }
        if (chargeUnit == ChargeUnit.BY_MINUTE.getCode()) {
            return count / 60;
        }
        return count;
    }

    @Override
    public void saveByStudentFinanceRecord(Long studentId, Long opMoney, String opInfo, Integer opType, Integer opTo) {
        log.info("studentId is:{} ,opMoney :{} ,opInfo:{},opType:{},opTo:{}", new Object[]{studentId, opMoney, opInfo, opType, opTo});
        OrgStudent os = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (os == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Double money = opMoney == null ? 0.0 : (double)opMoney.longValue() / 100.0;
        String balanceStr = new DecimalFormat("0.00").format(money);
        if (opType == StudentFiannceOpType.QUIT_CLASS.getCode()) {
            if (opTo == 1) {
                sb.append(String.format(QUIT_CLASS_TO_ACCOUNT_FORMAT, opInfo, balanceStr));
            } else if (opTo == 2) {
                sb.append(String.format(QUIT_CLASS_TO_MONEY_FORMAT, opInfo, balanceStr));
            }
        } else if (opType == StudentFiannceOpType.REFUND_CASH.getCode()) {
            sb.append(String.format(REFUND_CASH_FORMAT, balanceStr));
        } else if (opType == StudentFiannceOpType.RECHARGE.getCode()) {
            sb.append(String.format(RECHARGE_FORMAT, balanceStr, opInfo));
        } else if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode()) {
            sb.append(String.format(SIGNUP_PAY_FORMAT, balanceStr, opInfo));
        } else {
            log.info("with orgStudent:{} ,will return ", (Object)os);
            return;
        }
        String commentInfo = sb.toString();
        Date commentTime = new Date();
        TxStudentComment comment = new TxStudentComment();
        comment.setOrgId(os.getOrgId());
        comment.setUserId(os.getUserId());
        comment.setCreateTime(commentTime);
        comment.setUpdateTime(commentTime);
        comment.setContent(commentInfo);
        comment.setType(Integer.valueOf(1));
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setFollowType(Integer.valueOf(FollowType.QUIT_CLASS.getType()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        log.info("create comment :{} for student:{} ", (Object)commentInfo, (Object)os);
    }

    String getParticipantsNameStr(List<TxbacklogParticipant> list) {
        StringBuilder builder = new StringBuilder();
        String accountName = "";
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                TxbacklogParticipant obj = list.get(i);
                accountName = this.accountApiService.getAccountName(obj.getOrgId(), obj.getCascadeId());
                builder.append(accountName);
                if (i == list.size() - 1) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    @Override
    public TxStudentComment saveByBacklogAdd(Long userId, TxBacklog txBacklog, List<TxbacklogParticipant> participants) {
        Long cascadeId = txBacklog.getCascadeId() != null ? txBacklog.getCascadeId().longValue() : 0L;
        String accountName = this.accountApiService.getAccountName(txBacklog.getOrgId(), cascadeId);
        String participantsNameStr = this.getParticipantsNameStr(participants);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        StringBuilder builder = new StringBuilder();
        builder.append(accountName).append(" \u521b\u5efa\u4e86\u5b66\u5458\u8ddf\u8fdb\u5f85\u529e\u4e8b\u9879").append("\n");
        builder.append("\u8ddf\u8fdb\u65f6\u95f4: ").append(sdf.format(txBacklog.getEndTime())).append("\n");
        builder.append("\u53c2\u4e0e\u4eba : ").append(participantsNameStr).append("\n");
        builder.append("\u5f85\u529e\u4e8b\u9879: ").append(txBacklog.getContent());
        TxStudentComment comment = new TxStudentComment();
        comment.setUserId(userId);
        comment.setConsultUserId(txBacklog.getConsultUserId());
        comment.setOrgId(txBacklog.getOrgId());
        comment.setCreateTime(new Date());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setContent(builder.toString());
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return comment;
    }

    @Override
    public TxStudentComment saveByBacklogDel(Long userId, TxBacklog txBacklog, List<TxbacklogParticipant> participants) {
        Long cascadeId = txBacklog.getCascadeId() != null ? txBacklog.getCascadeId().longValue() : 0L;
        String accountName = this.accountApiService.getAccountName(txBacklog.getOrgId(), cascadeId);
        String participantsNameStr = this.getParticipantsNameStr(participants);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        StringBuilder builder = new StringBuilder();
        builder.append(accountName).append(" \u5220\u9664\u4e86\u5b66\u5458\u8ddf\u8fdb\u5f85\u529e\u4e8b\u9879").append("\n");
        builder.append("\u8ddf\u8fdb\u65f6\u95f4: ").append(sdf.format(txBacklog.getEndTime())).append("\n");
        builder.append("\u53c2\u4e0e\u4eba : ").append(participantsNameStr).append("\n");
        builder.append("\u5f85\u529e\u4e8b\u9879: ").append(txBacklog.getContent());
        TxStudentComment comment = new TxStudentComment();
        comment.setUserId(userId);
        comment.setConsultUserId(txBacklog.getConsultUserId());
        comment.setOrgId(txBacklog.getOrgId());
        comment.setCreateTime(new Date());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setContent(builder.toString());
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        if (comment.getUserId() != null) {
            this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
        }
        return comment;
    }

    @Override
    public TxStudentComment saveByBacklogUpdate(Long userId, TxBacklog txBacklogOld, TxBacklog txBacklogNew, List<TxbacklogParticipant> participantsOld, List<TxbacklogParticipant> participantsNew) {
        Long cascadeId = txBacklogNew.getCascadeId() != null ? txBacklogNew.getCascadeId().longValue() : 0L;
        String accountName = this.accountApiService.getAccountName(txBacklogNew.getOrgId(), cascadeId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        boolean dataChange = true;
        StringBuilder builder = new StringBuilder();
        builder.append(accountName).append(" \u4fee\u6539\u4e86\u5b66\u5458\u8ddf\u8fdb\u5f85\u529e\u4e8b\u9879").append("\n");
        if (!txBacklogOld.getEndTime().equals(txBacklogNew.getEndTime())) {
            dataChange = true;
            builder.append("\u539f\u8ddf\u8fdb\u65f6\u95f4: ").append(sdf.format(txBacklogOld.getEndTime())).append("\n");
            builder.append("\u73b0\u8ddf\u8fdb\u65f6\u95f4: ").append(sdf.format(txBacklogNew.getEndTime())).append("\n");
        }
        if (participantsOld != null && participantsNew != null) {
            boolean participantsChange = false;
            if (participantsOld.size() != participantsNew.size()) {
                participantsChange = true;
            } else {
                HashSet<Long> set = new HashSet<Long>();
                for (TxbacklogParticipant obj : participantsOld) {
                    set.add(obj.getCascadeId());
                }
                for (TxbacklogParticipant obj : participantsNew) {
                    set.add(obj.getCascadeId());
                }
                if (participantsOld.size() != set.size()) {
                    participantsChange = true;
                }
            }
            if (participantsChange) {
                dataChange = true;
                builder.append("\u539f\u53c2\u4e0e\u4eba : ").append(this.getParticipantsNameStr(participantsOld)).append("\n");
                builder.append("\u73b0\u53c2\u4e0e\u4eba : ").append(this.getParticipantsNameStr(participantsNew)).append("\n");
            }
        }
        if (!txBacklogOld.getEndTime().equals(txBacklogNew.getEndTime())) {
            dataChange = true;
            builder.append("\u539f\u5f85\u529e\u4e8b\u9879: ").append(txBacklogOld.getContent()).append("\n");
            builder.append("\u73b0\u5f85\u529e\u4e8b\u9879: ").append(txBacklogNew.getContent());
        }
        if (dataChange) {
            TxStudentComment comment = new TxStudentComment();
            comment.setUserId(userId);
            comment.setConsultUserId(txBacklogNew.getConsultUserId());
            comment.setOrgId(txBacklogNew.getOrgId());
            comment.setCreateTime(new Date());
            comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
            comment.setContent(builder.toString());
            this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
            if (comment.getUserId() != null) {
                this.orgStudentDao.updateLastRemindTime(comment.getOrgId(), comment.getUserId());
            }
            return comment;
        }
        return null;
    }
}

