/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganizationInfoAPIServiceImpl
implements OrganizationInfoAPIService {
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    public final LoadingCache<Long, OrgAccount> orgInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, OrgAccount>(){

        public OrgAccount load(Long orgId) throws Exception {
            OrgAccount byId = (OrgAccount)OrganizationInfoAPIServiceImpl.this.orgAccountDao.getById((Serializable)orgId, new String[0]);
            if (byId != null) {
                return byId;
            }
            return null;
        }
    });
    public final LoadingCache<Long, OrgAccount> orgInfoCacheWithNumber = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, OrgAccount>(){

        public OrgAccount load(Long orgNumber) throws Exception {
            ConcurrentMap asMap = OrganizationInfoAPIServiceImpl.this.orgInfoCache.asMap();
            for (OrgAccount oa : asMap.values()) {
                if (!oa.getNumber().equals(orgNumber)) continue;
                return oa;
            }
            OrgAccount byNumber = OrganizationInfoAPIServiceImpl.this.orgAccountDao.getAccountByNumber(Integer.valueOf(orgNumber.intValue()), new String[0]);
            if (byNumber != null) {
                return byNumber;
            }
            return null;
        }
    });

    @Override
    public OrgAccount findOrgAccountWithOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        try {
            return (OrgAccount)this.orgInfoCache.get((Object)orgId);
        }
        catch (ExecutionException e) {
            return (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        }
    }

    @Override
    public OrgAccount findOrgAccountWithOrgNumber(Long orgNumber) {
        if (orgNumber == null) {
            return null;
        }
        try {
            return (OrgAccount)this.orgInfoCacheWithNumber.get((Object)orgNumber);
        }
        catch (ExecutionException e) {
            return this.orgAccountDao.getAccountByNumber(Integer.valueOf(orgNumber.intValue()), new String[0]);
        }
    }

    @Override
    public Map<Integer, OrgInfo> getOrgInfoMap(Collection<Integer> orgIds) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyMap();
        }
        HashMap data = Maps.newHashMap();
        List orgInfos = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgInfos)) {
            for (OrgInfo orgInfo : orgInfos) {
                data.put(orgInfo.getOrgId(), orgInfo);
            }
        }
        return data;
    }
}

