/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.activity.dao.article.OrgTeacherDocumentMongoDbDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherUseStatus;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterSoftDelTeacherServiceImpl
implements FilterSoftDelTeacherService {
    private static final Logger log = LoggerFactory.getLogger(FilterSoftDelTeacherServiceImpl.class);
    @Autowired(required=false)
    private OrgTeacherDocumentMongoDbDao orgTeacherDocumentMongoDbDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgTeacherForSolrService orgTeacherForSolrService;

    @Override
    public void filterOrgCourseTeacherWithUserIds(Long orgId, Collection<Long> orgCourseTeacherUserIds) {
        if (GenericsUtils.isNullOrEmpty(orgCourseTeacherUserIds) || orgId == null) {
            return;
        }
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), orgCourseTeacherUserIds, false);
        List teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, orgCourseTeacherUserIds, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), null, new String[]{"useStatus", "userId"});
        Map<Long, OrgTeacher> extractList = this.getAllNormalTeachers(teacherByUserIdsAndOrgId);
        Iterator<Long> iter = orgCourseTeacherUserIds.iterator();
        while (iter.hasNext()) {
            Long next = iter.next();
            OrgTeacher orgTeacher = extractList.get(next);
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus == null || useStatus != OrgTeacherUseStatus.PAUSE.code || !this.canFilterWithoutClassRecord(hasClassRecord.get(next))) continue;
            iter.remove();
        }
    }

    @Override
    public void filterOrgCourseTeacher(Long orgId, List<OrgCourseTeacher> orgCourseTeachers) {
        if (GenericsUtils.isNullOrEmpty(orgCourseTeachers) || orgId == null) {
            return;
        }
        List userIds = CollectionUtils.extractList(orgCourseTeachers, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgCourseTeacher>(){

            public Long extract(OrgCourseTeacher arg0) {
                return arg0.getUserId();
            }
        });
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), userIds, false);
        List teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, (Collection)userIds, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), Boolean.valueOf(true), new String[]{"useStatus", "userId"});
        Map<Long, OrgTeacher> extractList = this.getAllNormalTeachers(teacherByUserIdsAndOrgId);
        Iterator<OrgCourseTeacher> iter = orgCourseTeachers.iterator();
        while (iter.hasNext()) {
            OrgCourseTeacher next = iter.next();
            OrgTeacher orgTeacher = extractList.get(next.getUserId());
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus == null || useStatus != OrgTeacherUseStatus.PAUSE.code || !this.canFilterWithoutClassRecord(hasClassRecord.get(next.getUserId()))) continue;
            iter.remove();
        }
    }

    @Override
    public void filterTeachers(Long orgId, List<Teacher> teacherList) {
        if (GenericsUtils.isNullOrEmpty(teacherList) || orgId == null) {
            return;
        }
        List userIds = CollectionUtils.extractList(teacherList, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, Teacher>(){

            public Long extract(Teacher arg0) {
                return arg0.getUserId();
            }
        });
        Map<Long, Boolean> hasClassRecord = this.hasClassRecord(orgId.intValue(), userIds, false);
        List teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, (Collection)userIds, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), null, new String[]{"useStatus", "userId"});
        ArrayList delTeacherIds = Lists.newArrayList();
        Map<Long, OrgTeacher> extractList = this.getAllNormalTeachers(teacherByUserIdsAndOrgId);
        for (Teacher next : teacherList) {
            OrgTeacher orgTeacher = extractList.get(next.getUserId());
            Integer useStatus = null;
            if (orgTeacher != null) {
                useStatus = orgTeacher.getUseStatus();
            }
            if (useStatus == null || useStatus != OrgTeacherUseStatus.PAUSE.code || !this.canFilterWithoutClassRecord(hasClassRecord.get(next.getUserId()))) continue;
            delTeacherIds.add(next.getId());
        }
        ArrayList result = Lists.newArrayList();
        if (!delTeacherIds.isEmpty()) {
            for (Teacher teacher : teacherList) {
                for (Long teacherId : delTeacherIds) {
                    if (teacher.getId().longValue() == teacherId.longValue()) continue;
                    result.add(teacher);
                }
            }
        } else {
            result.addAll(teacherList);
        }
        teacherList = result;
    }

    private boolean canFilterWithoutClassRecord(Boolean hasClassRecord) {
        return true;
    }

    @Override
    public Map<Long, Boolean> hasClassRecord(Integer orgId, Collection<Long> teacherIds, Boolean ... isId) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyMap();
        }
        HashMap retMap = Maps.newHashMap();
        boolean isIdQuery = GenericsUtils.notNullAndEmpty((Object)isId) ? isId[0] : true;
        Map<Long, OrgTeacherDocument> docMap = null;
        try {
            docMap = this.queryOrgTeachersWithIds(orgId, teacherIds, isIdQuery);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)" can not queryOrgTeachersWithIds teacherIds", (Object[])new Object[]{teacherIds});
            return Maps.newHashMap();
        }
        log.info("docMap are :{} ", docMap);
        if (GenericsUtils.notNullAndEmpty(docMap)) {
            for (Long teacherId : teacherIds) {
                boolean isHas = false;
                OrgTeacherDocument otd = docMap.get(teacherId);
                if (otd == null) continue;
                if (otd.getFinishedClassTime() > 0) {
                    isHas = true;
                }
                retMap.put(teacherId, isHas);
            }
        }
        return retMap;
    }

    public Map<Long, OrgTeacherDocument> queryOrgTechersWithDB(Integer orgId, Collection<Long> teacherIds, Boolean isId) {
        Collection orgTeachers = Lists.newArrayList();
        orgTeachers = isId != false ? this.orgTeacherDao.getTeachersByOrgIdAndIds(orgId, teacherIds) : this.orgTeacherDao.getTeacherByUserIdsAndOrgId(Long.valueOf(orgId.longValue()), teacherIds, null, null, new String[0]);
        Date beginDate = null;
        Date endDate = DateUtil.getEndOfMonth();
        Map<Long, OrgTeacherDocument> createOrgTeacherDocuments = this.orgTeacherForSolrService.createOrgTeacherDocuments((Long)orgId.longValue(), orgTeachers, beginDate, endDate, false);
        return createOrgTeacherDocuments;
    }

    private Map<Long, OrgTeacherDocument> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds, boolean isIdQuery) {
        List listByQuery = this.orgTeacherDocumentMongoDbDao.queryOrgTeachersWithIds(orgId, teacherIds, new Boolean[]{isIdQuery});
        List retDocuments = OrgTeacherDocument.buidOrgTeacherDocumentFromMap((List)listByQuery);
        String queryField = isIdQuery ? "orgTeacherId" : "teacherUserId";
        Map docMap = GenericsUtils.toFieldMap((Collection)retDocuments, (String[])new String[]{queryField});
        return docMap;
    }

    private Map<Long, OrgTeacher> getAllNormalTeachers(List<OrgTeacher> teacherByUserIdsAndOrgId) {
        Map extractMap = CollectionUtils.extractMap(teacherByUserIdsAndOrgId, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgTeacher>(){

            public Long extract(OrgTeacher arg0) {
                return arg0.getUserId();
            }
        });
        return extractMap;
    }
}

