/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.constant.DBOperation;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsulterAPIServiceImpl
implements ConsulterAPIService {
    private static final Logger log = LoggerFactory.getLogger(ConsulterAPIServiceImpl.class);
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentApiService studentApiService;

    @Override
    public void saveConsultUser(TxConsultUser consultUser) {
        this.consultUserDao.save((Object)consultUser, new String[0]);
    }

    @Override
    public void updateConsultUser(TxConsultUser consultUser, boolean updateNullValue) {
        Date now = new Date();
        consultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)consultUser, Boolean.valueOf(updateNullValue), new String[0]);
    }

    @Override
    public DBResultDto<TxConsultUser> saveOrUpdateByMobile(TxConsultUser baseData) {
        if (baseData == null || StringUtils.isBlank((CharSequence)baseData.getMobile())) {
            log.error("baseData:{}", (Object)baseData);
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        List consultUsers = this.consultUserDao.lookByMobile(baseData.getOrgId(), baseData.getMobile(), new String[0]);
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(baseData.getOrgId(), baseData.getMobile(), new String[]{"id", "name", "delStatus", "weixin"});
        if (CollectionUtils.isEmpty((Collection)consultUsers) && student != null && StringUtils.isNotEmpty((CharSequence)student.getWeixin())) {
            consultUsers = this.consultUserDao.lookByParams(baseData.getOrgId(), student.getWeixin(), new String[0]);
        }
        TxConsultUser consultUser = null;
        DBOperation operation = null;
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            consultUser = baseData;
            if (student != null) {
                consultUser.setStudentId(student.getId());
                consultUser.setWeixinOpenId(student.getWeixin());
            }
            this.consultUserDao.save((Object)consultUser, new String[0]);
            operation = DBOperation.INSERT;
        } else {
            consultUser = (TxConsultUser)consultUsers.get(0);
            boolean isNeedToUpdate = false;
            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
                if (!student.getName().equals(consultUser.getName())) {
                    isNeedToUpdate = true;
                    consultUser.setName(student.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)student.getWeixin()) && !student.getWeixin().equals(consultUser.getWeixinOpenId())) {
                    isNeedToUpdate = true;
                    consultUser.setWeixinOpenId(student.getWeixin());
                }
                if (student.getId().equals(consultUser.getStudentId())) {
                    isNeedToUpdate = true;
                    consultUser.setStudentId(consultUser.getStudentId());
                }
            }
            if (Flag.getBoolean((Integer)baseData.getIsConsulter()) && !Flag.getBoolean((Integer)consultUser.getIsConsulter())) {
                isNeedToUpdate = true;
                consultUser.setIsConsulter(baseData.getIsConsulter());
            }
            if (isNeedToUpdate) {
                consultUser.setUpdateTime(new Date());
                this.consultUserDao.update((Object)consultUser, new String[0]);
            }
            operation = DBOperation.UPDATE;
        }
        if (consultUser == null || operation == null) {
            log.error("baseData:{}", (Object)baseData);
            throw new RuntimeException("\u8fd4\u56de\u7ed3\u679c\u9519\u8bef");
        }
        return new DBResultDto<TxConsultUser>(consultUser, operation);
    }

    @Override
    public DBResultDto<TxConsultUser> saveOrUpdateByWechatOpenId(TxConsultUser baseData) {
        if (baseData == null || StringUtils.isBlank((CharSequence)baseData.getWeixinOpenId())) {
            log.error("baseData:{}", (Object)baseData);
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        log.info("[Wechat Message] BaseData is :{} ", (Object)baseData);
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(baseData.getOrgId(), baseData.getWeixinOpenId(), new String[0]);
        List orgStudents = this.orgStudentDao.getStudentByOpenIdAndOrgId(baseData.getOrgId(), baseData.getWeixinOpenId(), new String[0]);
        boolean consultNeedUpdate = false;
        boolean stuNeedUpdate = false;
        TxConsultUser consultUser = null;
        OrgStudent student = null;
        DBOperation operation = null;
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            consultUser = baseData;
            if (orgStudents != null && orgStudents.size() > 0) {
                student = (OrgStudent)orgStudents.get(0);
                log.info("baseData :{} consultUser not exists but find a student :{} ", (Object)baseData, (Object)student);
                consultUser.setStudentId(student.getId());
                consultUser.setMobile(student.getMobile());
                stuNeedUpdate = true;
                consultNeedUpdate = true;
            }
            this.consultUserDao.save((Object)consultUser, new String[0]);
            operation = DBOperation.INSERT;
        } else {
            consultUser = (TxConsultUser)consultUsers.get(0);
            log.info("find an exists consultUser :{} ", (Object)consultUser);
            if (consultUser.getStudentId() != null && consultUser.getStudentId() > 0L) {
                student = (OrgStudent)this.orgStudentDao.getById((Serializable)consultUser.getStudentId(), new String[0]);
                if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
                    consultUser.setName(student.getName());
                    consultUser.setMobile(student.getMobile());
                    consultNeedUpdate = true;
                }
            } else if (orgStudents != null && orgStudents.size() > 0) {
                student = (OrgStudent)orgStudents.get(0);
                consultUser.setStudentId(student.getId());
                consultUser.setMobile(student.getMobile());
                stuNeedUpdate = true;
                consultNeedUpdate = true;
            }
            if (!StringUtils.equals((CharSequence)consultUser.getWeixinNickName(), (CharSequence)baseData.getWeixinNickName())) {
                consultUser.setWeixinNickName(baseData.getWeixinNickName());
                consultNeedUpdate = true;
            }
            log.info("[Wechat Message] consultNeedUpdate={},studentId={},stuNeedUpdate={}", new Object[]{consultNeedUpdate, stuNeedUpdate, consultUser.getStudentId()});
            if (consultNeedUpdate) {
                if (student != null) {
                    consultUser.setName(student.getName());
                    consultUser.setNickName(student.getName());
                }
                consultUser.setUpdateTime(new Date());
                this.consultUserDao.update((Object)consultUser, new String[0]);
            }
            if (stuNeedUpdate) {
                student.setWeixin(consultUser.getWeixinOpenId());
                this.orgStudentDao.saveOrUpdate((Object)student, new String[0]);
            }
            operation = DBOperation.UPDATE;
        }
        if (consultUser == null || operation == null) {
            log.error("baseData:{}", (Object)baseData);
            throw new RuntimeException("\u8fd4\u56de\u7ed3\u679c\u9519\u8bef");
        }
        return new DBResultDto<TxConsultUser>(consultUser, operation);
    }

    @Override
    public DBResultDto<TxConsultUser> saveOrUpdateByUserId(TxConsultUser consultUser) {
        return null;
    }

    @Override
    public void updateLastRemindTime(Long consultUserId, Date lastRemindTime) {
        Date now = new Date();
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consultUserId, new String[0]);
        consultUser.setLastRemindTime(lastRemindTime);
        consultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
    }

    @Override
    public void updateKefuId(TxConsultUser consultUser, Long kefuId) {
        if (consultUser == null || consultUser.getId() == null) {
            log.error("consultUser1 is null - consultUser:{}", (Object)consultUser);
            return;
        }
        Date now = new Date();
        consultUser.setKefuId(kefuId);
        consultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
    }

    @Override
    public TxConsultUser getConsultUserByStudent(OrgStudent student) {
        List users = this.consultUserDao.lookByStudentId(student.getOrgId(), student.getId(), new String[0]);
        if (users != null && users.size() > 0) {
            return (TxConsultUser)users.get(0);
        }
        users = this.consultUserDao.lookByMobile(student.getOrgId(), student.getMobile(), new String[0]);
        if (users != null && users.size() > 0) {
            return (TxConsultUser)users.get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getWeixin()) && (users = this.consultUserDao.lookByWeixinOpenId(student.getOrgId(), student.getWeixin(), new String[0])) != null && users.size() > 0) {
            return (TxConsultUser)users.get(0);
        }
        return null;
    }

    @Override
    public void batchSetConsultAvatarUrl(Collection<TxConsultUser> txConsultUsers) {
        log.info("txConsultUsers  parm:{}, size param:{}", txConsultUsers, (Object)txConsultUsers.size());
        ArrayList<String> openIds = new ArrayList<String>();
        ArrayList<Long> studentIds = new ArrayList<Long>();
        for (TxConsultUser txConsultUser : txConsultUsers) {
            String openId;
            Long studentId = txConsultUser.getStudentId();
            if (studentId != null && studentId > 0L) {
                studentIds.add(studentId);
            }
            if ((openId = txConsultUser.getWeixinOpenId()) == null || openId.equals("") || openId.equals("0")) continue;
            openIds.add(openId);
        }
        log.info("\u83b7\u53d6\u5b66\u5458 studentIds param:{}", studentIds);
        Map fansMap = new HashMap();
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }
        Map<Object, Object> stuAvatarMap = new HashMap();
        if (GenericsUtils.notNullAndEmpty(studentIds)) {
            List orgStudents = this.orgStudentDao.getByIds(studentIds, new String[0]);
            stuAvatarMap = this.studentApiService.batchGetStudentAvatarUrl(orgStudents);
        }
        for (TxConsultUser txConsultUser : txConsultUsers) {
            Long studentId = txConsultUser.getStudentId();
            String avatar = null;
            if (studentId != null && studentId > 0L) {
                avatar = (String)stuAvatarMap.get(studentId);
            } else {
                Fans fan;
                avatar = txConsultUser.getPortrait();
                String openId = txConsultUser.getWeixinOpenId();
                if (GenericsUtils.isNullOrEmpty((Object)avatar) && GenericsUtils.notNullAndEmpty((Object)openId) && GenericsUtils.notNullAndEmpty((Object)(fan = (Fans)fansMap.get(openId)))) {
                    avatar = fan.getHeadImgUrl();
                    if (GenericsUtils.isNullOrEmpty((Object)txConsultUser.getName())) {
                        txConsultUser.setName(fan.getNick());
                    }
                }
                if (GenericsUtils.isNullOrEmpty((Object)avatar)) {
                    avatar = AvatarUtil.getUserAvatar((long)txConsultUser.getId());
                }
            }
            txConsultUser.setPortrait(avatar);
        }
    }

    @Override
    public String getConsultAvatarUrl(Long consultUserId) {
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)consultUserId, new String[]{"id", "studentId", "weixinOpenId", "name", "portrait"});
        this.batchSetConsultAvatarUrl(Arrays.asList(user));
        return user.getPortrait();
    }
}

