
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentNotifyMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.CourseNotifyWechatMsg;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.SignWechatTemplateMsg;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class WechatTemplateMsgHelper {

    public static SendMsgRequest createSendMsgRequestToStu(Long orgId, String mobile, Long studentId,
        String weixinOpenId, String smsContent, WechateTemplateMsgType wechatType, WechatMsgTypeSuper typeMsg) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgId);
        request.setMobile(mobile);
        request.setCountSms(false);
        request.setReceiverId(studentId);
        request.setWeixinOpenId(weixinOpenId);
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgId);
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(wechatType.getValue());// WechateTemplateMsgType.COURSE_EVALUATION_TO_STU
        request.setSmsContent(smsContent);
        Map<String, Object> wechatParams = null;
        log.info("WechatMsgTypeSuper is:{} {}", typeMsg, "");
        switch (typeMsg.getType()) {
            case SIGNUP_WECHAT_TEMPLATE:
                wechatParams = createSignWechatTempateMsg((SignWechatTemplateMsg) typeMsg);
                break;
            case COURSE_NOTIFY_WECHAT_TEMPLATE:
                wechatParams = createCourseNotifyWechatMsg((CourseNotifyWechatMsg) typeMsg);
                break;
            case AFTER_COURSE_COMMENT_WECHAT_TEMPLATE:
                wechatParams = createAfterCourseCommentWechatMsg((AfterCourseCommentMsg) typeMsg);
                break;
            case AFTER_COURSE_COMMENT_NOTIFY_WECHAT_TEMPLATE:
                wechatParams = createAfterCourseNotifyWechatMsg((AfterCourseCommentNotifyMsg) typeMsg);
                break;
            default:
                wechatParams = Maps.newHashMap();
                break;
        }
        request.setWechatParams(wechatParams);
        return request;
    }

    /**
     * 签到提醒
     * 
     * @param msgRequest
     * @return
     */
    public static Map<String, Object> createSignWechatTempateMsg(SignWechatTemplateMsg msgRequest) {
        Map<String, Object> params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msgRequest.getType();
        String first = String.format(type.first, msgRequest.getStudentName(), msgRequest.getOrgName(),
            msgRequest.getSignStatusStr(), msgRequest.createTimeRangeStr());
        String remark = String.format(type.remark, msgRequest.getExtension());
        fillParams(params, type, first, remark, msgRequest.getScheduleUrl(), msgRequest.getStudentName(),
            msgRequest.getSignTimeStr(), msgRequest.getCourseName(), msgRequest.getTeacherName());
        return params;
    }

    /**
     * 上课通知提醒
     * 
     * @return
     */
    public static Map<String, Object> createCourseNotifyWechatMsg(CourseNotifyWechatMsg msg) {
        Map<String, Object> params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getStudentName(), msg.getCourseName());
        String remark = String.format(type.remark, msg.getExtension());
        fillParams(params, type, first, remark, msg.getScheduleUrl(), msg.getCourseTimeRange(), msg.getTeacherName(),
            msg.getCourseName(), msg.getRoomName());
        return params;
    }

    /**
     * 邀请课后评价 提醒
     * 
     * @return
     */
    public static Map<String, Object> createAfterCourseCommentWechatMsg(AfterCourseCommentMsg msg) {
        Map<String, Object> params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getStudentName(), msg.getCourseName());
        fillParams(params, type, first, type.remark, msg.getCommentUrl(), msg.getStudentName(), msg.getCourseName(),
            msg.getTeacherName());
        return params;
    }

    /**
     * 有人对自己进行课后评价 提醒
     * 
     * @return
     */
    public static Map<String, Object> createAfterCourseNotifyWechatMsg(AfterCourseCommentNotifyMsg msg) {
        Map<String, Object> params = Maps.newHashMap();
        TxWechatTemplateMsgType type = msg.getType();
        String first = String.format(type.first, msg.getTeacherName(), msg.getCourseTimeStr());
        fillParams(params, type, first, type.remark, msg.getCommentUrl(), msg.getStudentName(), msg.getCourseName(),
            msg.getTeacherName());
        return params;
    }

    private static void fillParams(Map<String, Object> params, TxWechatTemplateMsgType type, String first,
        String remark, String url, String...keywords) {
        if (type == null) {
            return;
        }
        params.put("first", createFirst(first, type.firstColor));
        params.put("remark", createRemark(remark, type.remarkColor));
        params.put("url", url);
        String[] typeKeywords = type.keywords;
        if (GenericsUtils.notNullAndEmpty(typeKeywords)) {
            if (GenericsUtils.isNullOrEmpty(keywords) || typeKeywords.length != keywords.length) {
                log.warn("type:{} expect keywork:{} but not match the params:{} ", type,
                    ToStringBuilder.reflectionToString(typeKeywords), ToStringBuilder.reflectionToString(keywords));
                return;
            }
            List<String> keywordList = Arrays.asList(keywords);
            for (int i = 1; i <= typeKeywords.length; i++) {
                params.put("keyword" + i, createKeyword(keywordList.get(i - 1), type.keywordColor));
            }
        }
        log.info("for type:{} and after fill info , the wechatParams is:{} ", type, params);
    }

    public static JSONObject createFirst(String value, String color) {
        return getTemplateMsgNode(value, color);
    }

    public static JSONObject createRemark(String value, String color) {
        return getTemplateMsgNode(value, color);
    }

    public static JSONObject createKeyword(String value, String color) {
        return getTemplateMsgNode(value, color);
    }

    public static JSONObject getTemplateMsgNode(String value, String color) {
        JSONObject obj = new JSONObject();
        obj.put("value", value);
        obj.put("color", color);
        return obj;
    }

}
