package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.*;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by lxp on 2017/2/22.
 */
@Service
@Slf4j
public class KexiaoApiServiceImpl implements KexiaoApiService {

    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgSignupRefundDao refundDao;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private TxTransferClassRecordDao transferClassRecordDao;
    @Autowired
    private TxTransferClassInfoDao transferClassInfoDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentcourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    private static final Date SUPPORT_TIME = DateUtil.getStrToDate("yyyy-MM-dd mm:HH:ss", "2017-06-10 00:00:00");

    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        // 1，签到；2，请假；3，旷课
        if (sign.getStatus() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        } else {
            return LessonStatus.UN_START;
        }
    }

    @Override
    public String getLeftAmountStr(KexiaoStatistics stat) {
        String remainTuition = "0.00";
        if (stat != null) {
            if (stat.getCompleteStatus() != 0) {
                remainTuition = "--";
            } else {
                remainTuition = NumberUtil.convertFenToYuan(stat.getLeftAmount());
            }
        }
        return remainTuition;
    }

    @Override
    public void setStudentLessonKexiaoStatus(Collection<OrgStudentLesson> studentLessons) {
        Set<Long> classIds = new HashSet<>();
        for (OrgStudentLesson lesson : studentLessons) {
            classIds.add(lesson.getCourseId());
        }
        Set<OrgStudentLesson> signKexiaoLessons = new HashSet<>();
        Set<OrgStudentLesson> timeKexiaoLessons = new HashSet<>();
        Map<Long, OrgCourseConsumeRule> consumeRuleMap = courseApiService.getClassRule(classIds);
        for (OrgStudentLesson lesson : studentLessons) {
            OrgCourseConsumeRule rule = consumeRuleMap.get(lesson.getCourseId());
            if (rule == null || rule.getRuleValue() == 0) {
                timeKexiaoLessons.add(lesson);
            } else {
                signKexiaoLessons.add(lesson);
            }
        }
        //// TODO: 2017/4/27
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED;
    }

    @Override
    public Map<Long, KexiaoStudentStat> queryKexiaoStatByStudents(Long orgId, Collection<Long> userIds) {
        Map<Long, KexiaoStudentStat> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        //1.总金额:报名记录
        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, SignupCourseStatus.PAY_SUCCESS);
        for (OrgSignupCourse signupCourse : signupCourseList) {
            KexiaoStudentStat stat = ret.get(signupCourse.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setCompleteStatus(1);//初始化
                ret.put(signupCourse.getUserId(), stat);
            }
            addBuyData(signupCourse, stat);
            stat.splitContractNumber(signupCourse);
            if (signupCourse.getLessonCount() > 0) {
                stat.setCompleteStatus(0);
            }
        }
        //2.课消金额
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, LessonStatus.FINISHED.getStatus());
        for (OrgSignupCourseLesson lesson : courseLessons) {
            KexiaoStudentStat stat = ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(lesson.getUserId(), stat);
            }
            addKexiaoData(lesson, stat);
            stat.splitKexiaoNumber(lesson);
        }
        //3.退款(班)金额
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIds(orgId, userIds);
        for (OrgSignupRefund refund : refundList) {
            KexiaoStudentStat stat = ret.get(refund.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(refund.getUserId(), stat);
            }
            addRefundData(refund, stat);
            stat.splitRefundNumber(refund);
        }
        //4.转班金额
        Map<Long, List<TxTransferClassRecord>> recordListMap = getTxTransferClassRecordList(userIds);

        Set<Long> keySet = recordListMap.keySet();

        for (Long userId : keySet) {
            KexiaoStudentStat stat = ret.get(userId);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(userId, stat);
            }
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list != null && list.size() > 0) {
                for (TxTransferClassRecord record : list) {
                    addTransferData(record, stat);
                    stat.splitTransferNumber(record);
                }
            }
        }

        //处理未补充数据
        List<OrgStudentLesson> lessons = studentLessonDao.listByUserIdsAndLessonType(orgId,userIds,Arrays.asList(-1),"id","userId","courseId","kexiaoStatus");
        for (OrgStudentLesson lesson:lessons){
            KexiaoStudentStat stat = ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(lesson.getUserId(), stat);
            }
            if(lesson.getKexiaoStatus()==1){
                stat.setKexiaoNormalCount(stat.getKexiaoNormalCount()+1);
            }
            stat.setArrangeNormalCount(stat.getArrangeNormalCount()+1);
        }

        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userIds, ret);
        return ret;
    }

    @Override
    public Map<String, KexiaoStatistics> queryKexiaoStatByUserIds(Long orgId, Collection<Long> userIds) {
        Map<String, KexiaoStatistics> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        //1.总金额:报名记录
        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, SignupCourseStatus.PAY_SUCCESS);
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = getKey(signupCourse.getUserId(),signupCourse.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStatistics();
                stat.setCompleteStatus(1);//初始化
                ret.put(key, stat);
            }
            addBuyData(signupCourse, stat);
            if (signupCourse.getLessonCount() > 0) {
                stat.setCompleteStatus(0);
            }
        }
        //2.课消金额
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, LessonStatus.FINISHED.getStatus());
        for (OrgSignupCourseLesson lesson : courseLessons) {
            String key = getKey(lesson.getUserId(),lesson.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            addKexiaoData(lesson, stat);
        }
        //3.退款(班)金额
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIds(orgId, userIds);
        for (OrgSignupRefund refund : refundList) {
            String key = getKey(refund.getUserId(),refund.getClassId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            addRefundData(refund, stat);
        }
        //4.转班金额
        Map<Long, List<TxTransferClassRecord>> recordListMap = getTxTransferClassRecordList(userIds);

        Set<Long> keySet = recordListMap.keySet();

        for (Long userId : keySet) {
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list != null && list.size() > 0) {
                for (TxTransferClassRecord record : list) {
                    String key = getKey(record.getTransferOutUserId(),record.getTransferOutClassId());
                    KexiaoStatistics stat = ret.get(key);
                    if (stat == null) {
                        stat = new KexiaoStudentStat();
                        ret.put(key, stat);
                    }
                    addTransferData(record, stat);
                }
            }
        }

        //处理未补充数据
        List<OrgStudentLesson> lessons = studentLessonDao.listByUserIdsAndLessonType(orgId,userIds,Arrays.asList(-1),"id","userId","courseId","kexiaoStatus");
        for (OrgStudentLesson lesson:lessons){
            String key = getKey(lesson.getUserId(),lesson.getCourseId());
            KexiaoStatistics stat = ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            if(lesson.getKexiaoStatus()==1){
                stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber()+1);
            }
            stat.setArrangeNormalNumber(stat.getArrangeNormalNumber()+1);
        }

        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userIds, ret);
        return ret;
    }

    private String getKey(long userId,long classId){
        return userId+"_"+classId;
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIds(userIds, status);
        return getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds, Long classId) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIdsAndClassId(userIds, classId, status);
        return getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getUserIdToRecordListMap(List<TxTransferClassInfo> transferClassInfos) {
        Map<Long, List<TxTransferClassRecord>> ret = new HashMap<>();
        Map<Long, TxTransferClassInfo> numberMap = CollectionHelper.toKeyMap(transferClassInfos, "transferNumber");

        List<Long> transferNumbers = ListUtil.toKeyList(transferClassInfos, "transferNumber", TxTransferClassInfo.class);
        List<TxTransferClassRecord> recordList = new ArrayList<>();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = transferClassRecordDao.listByTransferNumbers(transferNumbers);
        }
        for (TxTransferClassRecord record : recordList) {
            long number = record.getTransferNumber();
            TxTransferClassInfo classInfo = numberMap.get(number);

            List<TxTransferClassRecord> list = ret.get(classInfo.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                ret.put(classInfo.getUserId(), list);
            }
            list.add(record);
        }

        return ret;
    }

    private void addBuyData(OrgSignupCourse signupCourse, KexiaoStatistics stat) {
        if (signupCourse.getLessonCount() > 0) {//所有订单都未补充的时候才表示不显示
            stat.setCompleteOrderAmount(stat.getCompleteOrderAmount() + signupCourse.getTotalPayPrice());
            stat.setCompleteOrderNumber(stat.getCompleteOrderNumber() + KexiaoUtil.getClassNumber(signupCourse));
        }
        stat.setContractAmount(stat.getContractAmount() + signupCourse.getTotalPayPrice());
        stat.setContractNumber(stat.getContractNumber() + KexiaoUtil.getClassNumber(signupCourse));
    }

    private void addKexiaoData(OrgSignupCourseLesson lesson, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            //已课消数据
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoNormalAmount(stat.getKexiaoNormalAmount() + lesson.getAmount());
                    stat.setKexiaoNormalNumber(stat.getKexiaoNormalNumber() + getLessonNumber(lesson));
                }
                stat.setArrangeNormalAmount(stat.getArrangeNormalAmount() + lesson.getAmount());
                stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + getLessonNumber(lesson));
                }
                //已排课数据
                stat.setArrangeFreeNumber(stat.getArrangeFreeNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                stat.setCancelNormalNumber(stat.getCancelNormalNumber() + getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE_CANCEL.getCode()) {
                stat.setCancelFreeNumber(stat.getCancelFreeNumber() + getLessonNumber(lesson));
            }
        }
    }

    private int getLessonNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime(lesson.getChargeUnit())) {
            return lesson.getLessonDuration();
        } else {
            return 1;
        }
    }

    private void addRefundData(OrgSignupRefund refund, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setRefundAmount(stat.getRefundAmount() + refund.getRefundFee() + refund.getRefundPrice());
            stat.setRefundNormalNumber(stat.getRefundNormalNumber() + refund.getRefundLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassInfo info, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + info.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + info.getLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassRecord record, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + record.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + record.getRealLessonCount().intValue());
            stat.setTransferFreeNumber(stat.getTransferFreeNumber() + record.getFreeLessonCount());
        }
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIds(Long orgId, Collection<Long> classIds) {
        Map<Long, Long> classIdToCourseId = courseApiService.mapClassIdToCourseId(classIds);
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdsAndStudentIds(orgId, null, classIdToCourseId.values(), null);
        Map<Long, KexiaoSignupCourseStat> statMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);

        Map<Long, KexiaoStatistics> ret = new HashMap<>();

        Set<Long> keySet = statMap.keySet();
        for (Long id : keySet) {
            KexiaoSignupCourseStat stat = statMap.get(id);
            log.debug("[KexiaoSignupCourseStat] KexiaoSignupCourseStat={}", stat);
            KexiaoStatistics existStat = ret.get(stat.getClassId());
            if (existStat == null) {
                existStat = new KexiaoStatistics();
                BeanUtils.copyProperties(stat, existStat);
                ret.put(stat.getClassId(), existStat);
            } else {
                existStat.setContractNumber(existStat.getContractNumber() + stat.getContractNumber());
                existStat.setContractAmount(existStat.getContractAmount() + stat.getContractAmount());
                existStat.setCompleteOrderNumber(existStat.getCompleteOrderNumber() + stat.getCompleteOrderNumber());
                existStat.setCompleteOrderAmount(existStat.getCompleteOrderAmount() + stat.getCompleteOrderAmount());

                existStat.setArrangeNormalNumber(existStat.getArrangeNormalNumber() + stat.getArrangeNormalNumber());
                existStat.setArrangeNormalAmount(existStat.getArrangeNormalAmount() + stat.getArrangeNormalAmount());
                existStat.setArrangeFreeNumber(existStat.getArrangeFreeNumber() + stat.getArrangeFreeNumber());
                existStat.setCancelNormalNumber(existStat.getCancelNormalNumber() + stat.getCancelNormalNumber());
                existStat.setCancelFreeNumber(existStat.getCancelFreeNumber() + stat.getCancelFreeNumber());

                existStat.setRefundAmount(existStat.getRefundAmount() + stat.getRefundAmount());
                existStat.setRefundNormalNumber(existStat.getRefundNormalNumber() + stat.getRefundNormalNumber());
                existStat.setRefundFreeNumber(existStat.getRefundFreeNumber() + stat.getRefundFreeNumber());

                existStat.setTransferAmount(existStat.getTransferAmount() + stat.getTransferAmount());
                existStat.setTransferNormalNumber(existStat.getTransferNormalNumber() + stat.getTransferNormalNumber());
                existStat.setTransferFreeNumber(existStat.getTransferFreeNumber() + stat.getTransferFreeNumber());

                existStat.setKexiaoNormalNumber(existStat.getKexiaoNormalNumber() + stat.getKexiaoNormalNumber());
                existStat.setKexiaoNormalAmount(existStat.getKexiaoNormalAmount() + stat.getKexiaoNormalAmount());
                existStat.setKexiaoFreeNumber(existStat.getKexiaoFreeNumber() + stat.getKexiaoFreeNumber());
            }
        }
        return ret;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentCourse(long orgId, long userId, long courseId) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        OrgStudentCourse studentCourse = studentcourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
        if (studentCourse != null) {
            statistics = queryKexiaoStatByStudentClass(orgId, userId, studentCourse.getCourseId());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userId, courseId, statistics);
        return statistics;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentClass(long orgId, long userId, long classId) {
        Long courseId = classId;
        OrgCourse course = courseDao.getById(classId, "id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit");
        if (course == null) {
            throw new ParameterException("班级ID不存在!(" + classId + ")");
        }
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            courseId = course.getParentId();
        } else {
            courseId = course.getId();
        }
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, SignupCourseStatus.PAY_SUCCESS);
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listLessonsByUserIdAndClassId(orgId, userId, classId, null, null);
        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIdAndCourseId(orgId, userId, courseId);
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List<TxTransferClassInfo> transferClassInfos = transferClassInfoDao.listByUserIdAndClassId(userId, classId, status);
        List<Long> transferNumbers = ListUtil.toKeyList(transferClassInfos, "transferNumber", TxTransferClassInfo.class);
        List<TxTransferClassRecord> recordList = new ArrayList<>();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = transferClassRecordDao.listByTransferNumbers(transferNumbers);
        }

        KexiaoStatistics statistics = createKexiaoStatistics(signupCourseList, courseLessons, refundList, recordList);
        statistics.setUserId(userId);
        statistics.setClassId(classId);
        statistics.setChargeUnit(course.getChargeUnit());
        if (statistics.getCompleteStatus() != 0 || signupCourseList.size() < 1) {
            handHistoryArrangeLesson(orgId, userId, classId, statistics);
        }

        //如果用户的订单未补充,则需要重新计算总课次和赠送课
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode() || statistics.isHasHistoryRefund()) {
            List<OrgStudentLesson> studentLessons = studentLessonDao.getByUserIdAndClassId(orgId, userId, classId, null);
            int kexiaoCount = 0;
            for (OrgStudentLesson studentLesson : studentLessons) {
                if (studentLesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoCount++;
                }
            }
            statistics.setKexiaoNormalNumber(kexiaoCount);
            statistics.setArrangeNormalNumber(studentLessons.size());
        }

        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", orgId, userId, classId, statistics);
        return statistics;
    }

    /**
     * 未补充的订单计算排课
     *
     * @param orgId
     * @param userId
     * @param classId
     * @param statistics
     */
    private void handHistoryArrangeLesson(long orgId, long userId, long classId, KexiaoStatistics statistics) {
        List<OrgStudentLesson> lessons = studentLessonDao.getByUserIdAndClassId(orgId, userId, classId, null, Arrays.asList(LessonType.OTHER.getCode()));
        if (lessons != null && lessons.size() > 0) {
            for (OrgStudentLesson lesson : lessons) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    statistics.setKexiaoNormalNumber(statistics.getKexiaoNormalNumber() + 1);
                }
                statistics.setArrangeNormalNumber(statistics.getArrangeNormalNumber() + 1);
            }
        }

    }

    private KexiaoStatistics createKexiaoStatistics(List<OrgSignupCourse> signupCourseList,
                                                    List<OrgSignupCourseLesson> courseLessons,
                                                    List<OrgSignupRefund> refundList,
                                                    List<TxTransferClassRecord> recordList) {
        KexiaoStatistics statistics = new KexiaoStatistics();

        int completeStatus = 0;
        //计算合同数据
        if (signupCourseList != null && signupCourseList.size() > 0) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                addBuyData(signupCourse, statistics);
                if (signupCourse.getLessonCount() < 1) {
                    if (signupCourse.getStatus() != SignupCourseStatus.QUIT_CLASS.getCode()) {
                        completeStatus = 1;
                    } else {
                        statistics.setHasHistoryRefund(true);
                    }
                }
            }
        }
        Map<Long, OrgSignupCourse> courseMap = CollectionHelper.toKeyMap(signupCourseList, "signupPurchaseId");
        statistics.setCompleteStatus(completeStatus);

        Map<Long, List<OrgSignupCourseLesson>> lessonsMap = new HashMap<>();
        //增加课消/排课数据
        if (courseLessons != null && courseLessons.size() > 0) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                addKexiaoData(lesson, statistics);
                if (lesson.getSignupCourseId() > 0) {
                    List<OrgSignupCourseLesson> lessonList = lessonsMap.get(lesson.getSignupCourseId());
                    if (lessonList == null) {
                        lessonList = new ArrayList<>();
                        lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                    }
                    lessonList.add(lesson);
                }
            }
        }

        //计算退班数据
        if (refundList != null && refundList.size() > 0) {
            for (OrgSignupRefund refund : refundList) {
                if (refund.getCreateTime().compareTo(SUPPORT_TIME) < 0) {
                    OrgSignupCourse signupCourse = courseMap.get(refund.getSignupPurchaseId());
                    if (signupCourse != null) {
                        handleHistoryRefundData(refund, signupCourse, lessonsMap.get(signupCourse.getId()));
                    }
                }
            }
            for (OrgSignupRefund refund : refundList) {
                addRefundData(refund, statistics);
            }
        }

        //4.转班金额
        if (recordList != null && recordList.size() > 0) {
            for (TxTransferClassRecord record : recordList) {
                addTransferData(record, statistics);
            }
        }
        return statistics;

    }

    //处理历史退班数据,历史退班退班课节数=报名课节数-课消课节数
    private void handleHistoryRefundData(OrgSignupRefund refund, OrgSignupCourse signupCourse, List<OrgSignupCourseLesson> courseLessons) {
        log.info("[KexiaoStatistics] handle refund before:{}", refund);
        if (signupCourse == null && signupCourse.getLessonCount() < 1) {
            return;
        }
        long kexiaoNumber = 0;
        if (courseLessons != null) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                if (lesson != null && lesson.getKexiaoStatus() != null && lesson.getLessonType() != null && lesson.getKexiaoStatus() == 1 && lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                    if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                        kexiaoNumber += lesson.getLessonDuration();
                    } else {
                        kexiaoNumber++;
                    }
                }
            }
        }
        long buyNumber = 0;
        refund.setRefundLessonCount(KexiaoUtil.getClassNumber(signupCourse) - kexiaoNumber);

        log.info("[KexiaoStatistics] handle refund after:{},signupCourse={},kexiaoNumber={}", refund, signupCourse, kexiaoNumber);
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIdAndUserIds(long orgId, long classId, Collection<Long> userIds) {
        Map<Long, KexiaoStatistics> ret = new HashMap<>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        Long courseId = classId;
        OrgCourse course = courseDao.getById(classId, "id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit");
        if (course == null) {
            throw new ParameterException("班级ID不存在!(" + classId + ")");
        }
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            courseId = course.getParentId();
        } else {
            courseId = course.getId();
        }

        List<OrgSignupCourse> signupCourseList = signupCourseDao.searchByUserIdsAndClassId(userIds, classId, orgId, SignupCourseStatus.PAY_SUCCESS);
        Map<Long, List<OrgSignupCourse>> signupCourseMap = new HashMap<>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            List<OrgSignupCourse> list = signupCourseMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                signupCourseMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }

        Map<Long, List<OrgSignupCourseLesson>> courseLessonMap = new HashMap<>();
        List<OrgSignupCourseLesson> courseLessons = signupCourseLessonDao.listByUserIdsAndClassId(userIds, classId, null);
        for (OrgSignupCourseLesson courseLesson : courseLessons) {
            List<OrgSignupCourseLesson> list = courseLessonMap.get(courseLesson.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                courseLessonMap.put(courseLesson.getUserId(), list);
            }
            list.add(courseLesson);
        }

        List<OrgSignupRefund> refundList = refundDao.listOrderByUserIdsAndCourseId(orgId, userIds, courseId);
        Map<Long, List<OrgSignupRefund>> refundMap = new HashMap<>();
        for (OrgSignupRefund refund : refundList) {
            List<OrgSignupRefund> list = refundMap.get(refund.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                refundMap.put(refund.getUserId(), list);
            }
            list.add(refund);
        }

        Map<Long, List<TxTransferClassRecord>> recordMap = getTxTransferClassRecordList(userIds, classId);

        for (Long userId : userIds) {
            KexiaoStatistics statistics = createKexiaoStatistics(
                    signupCourseMap.get(userId),
                    courseLessonMap.get(userId), refundMap.get(userId),
                    recordMap.get(userId));
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            ret.put(userId, statistics);
        }
        return ret;
    }

    @Override
    public Map<Long, KexiaoSignupCourseStat> queryKexiaoStatBySignUpCourseIds(Collection<OrgSignupCourse> signupCourseList) {
        if (signupCourseList == null || signupCourseList.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map<Long, OrgSignupCourse> courseMap = CollectionHelper.toKeyMap(signupCourseList, "signupPurchaseId");
        //1.查询订单信息
        List<Long> signupCourseIds = ListUtil.toKeyList(signupCourseList, "id", OrgSignupCourse.class);
        List<Long> purchaseIds = ListUtil.toKeyList(signupCourseList, "signupPurchaseId", OrgSignupCourse.class);
        //2.查询已排课信息
        List<OrgSignupCourseLesson> arrangedList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds, LessonType.FREE.getCode(), null);
        Map<Long, OrgSignupCourseLesson> arrangedFreeMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : arrangedList) {
            arrangedFreeMap.put(lesson.getSignupCourseId(), lesson);
        }
        List<OrgSignupCourseLesson> normalList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds, LessonType.NORMAL.getCode(), null);
        Map<Long, OrgSignupCourseLesson> arrangedNormalMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : normalList) {
            arrangedNormalMap.put(lesson.getSignupCourseId(), lesson);
        }

        //3.查询已课消信息
        List<OrgSignupCourseLesson> freeKexiaoList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds,
                LessonType.FREE.getCode(), LessonStatus.FINISHED.getStatus());
        Map<Long, OrgSignupCourseLesson> freeKexiaoMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : freeKexiaoList) {
            freeKexiaoMap.put(lesson.getSignupCourseId(), lesson);
        }

        List<OrgSignupCourseLesson> kexiaoList = signupCourseLessonDao.listBySignupCourseIds(signupCourseIds,
                LessonType.NORMAL.getCode(), LessonStatus.FINISHED.getStatus());
        Map<Long, List<OrgSignupCourseLesson>> lessonsMap = new HashMap<>();
        Map<Long, OrgSignupCourseLesson> normalKexiaoMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson : kexiaoList) {
            normalKexiaoMap.put(lesson.getSignupCourseId(), lesson);
            if (lesson.getSignupCourseId() > 0) {
                List<OrgSignupCourseLesson> lessonList = lessonsMap.get(lesson.getSignupCourseId());
                if (lessonList == null) {
                    lessonList = new ArrayList<>();
                    lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                }
                lessonList.add(lesson);
            }
        }
        //4.查询转班信息
        List<Integer> status = Arrays.asList(TransferClassStatus.SUCCESS.getCode(), TransferClassStatus.INIT.getCode());
        Map<String, TxTransferClassRecord> purchaseTransferMap = transferClassRecordDao.groupByPurchaseIds(purchaseIds, status);
        //5.查询退款/退班信息
        List<OrgSignupRefund> refunds = refundDao.getByPurcahseIds(new HashSet<Long>(purchaseIds));
        Map<String, OrgSignupRefund> refundMap = new HashMap<>();
        for (OrgSignupRefund refund : refunds) {

            if (refund.getCreateTime().compareTo(SUPPORT_TIME) < 0) {
                OrgSignupCourse signupCourse = courseMap.get(refund.getSignupPurchaseId());
                if (signupCourse != null) {
                    handleHistoryRefundData(refund, signupCourse, lessonsMap.get(signupCourse.getId()));
                }
            }

            String key = refund.getSignupPurchaseId() + "_" + refund.getClassId();
            OrgSignupRefund tmp = refundMap.get(key);
            if (tmp == null) {
                refundMap.put(key, refund);
            } else {
                tmp.setRefundFee(tmp.getRefundFee() + tmp.getRefundPrice() + refund.getRefundFee() + refund.getRefundPrice());
                tmp.setRefundLessonCount(tmp.getRefundLessonCount() + refund.getRefundLessonCount());
            }
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);

        //5.计算剩余课次/学费
        Map<Long, KexiaoSignupCourseStat> ret = new HashMap<>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
            KexiaoSignupCourseStat stat = new KexiaoSignupCourseStat();
            KexiaoStatisticsBuilder builder = new KexiaoStatisticsBuilder(stat);
            builder.addSignupCourse(signupCourse)
                    .addArrangedNormalLesson(arrangedNormalMap.get(signupCourse.getId()))
                    .addArrangedFreeLesson(arrangedFreeMap.get(signupCourse.getId()))
                    .addKexiaoFreeLesson(freeKexiaoMap.get(signupCourse.getId()))
                    .addKexiaoNormalLesson(normalKexiaoMap.get(signupCourse.getId()))
                    .addTransferRecord(purchaseTransferMap.get(key))
                    .addRefundRecord(refundMap.get(key));
            builder.build();

            stat.setStatus(signupCourse.getStatus());
            stat.setPurchaseId(signupCourse.getSignupPurchaseId());
            ret.put(signupCourse.getId(), stat);
        }
        return ret;
    }

    @Override
    public OrgSignupCourseLesson querySignupCourseLessonInfo(Long signupCouseId, Long lessonId) {
        Map<String, OrgSignupCourseLesson> lessonMap = signupCourseLessonDao.listBySignupCourseIdAndLessonId(Arrays.asList(signupCouseId), Arrays.asList(lessonId));
        return lessonMap.get(signupCouseId + "_" + lessonId);
    }

    @Override
    public Map<Long, List<OrgSignupCourseLesson>> queryLessonSignupCourseList(Collection<Long> lessonIds, Long userId) {
        List<OrgSignupCourseLesson> lessons = signupCourseLessonDao.listByUserIdAndLessonId(Arrays.asList(userId), lessonIds, null);
        Map<Long, List<OrgSignupCourseLesson>> ret = new HashMap<>();
        for (OrgSignupCourseLesson lesson : lessons) {
            List<OrgSignupCourseLesson> list = ret.get(lesson.getId());
            if (list == null) {
                list = new ArrayList<>();
            }
            list.add(lesson);
        }
        return ret;
    }

    //测试统一课消使用
    public StudentCourseKexiaoDocument finishCountMoney1(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);
        Map<Long, OrgSignupCourse> signupCourseMap = CollectionHelper.toKeyMap(signupCourseList, "id");
        Map<Long, KexiaoSignupCourseStat> courseStatMap = new HashMap<>();
        if (signupCourseId != null && signupCourseId > 0) {
            if (signupCourseMap.keySet().contains(signupCourseId)) {
                courseStatMap = queryKexiaoStatBySignUpCourseIds(Arrays.asList(signupCourseMap.get(signupCourseId)));
            }
        } else {
            courseStatMap = queryKexiaoStatBySignUpCourseIds(signupCourseList);
        }
        StudentCourseKexiaoDocument doc = new StudentCourseKexiaoDocument();
        if (courseStatMap != null && courseStatMap.size() > 0) {
            for (KexiaoStatistics statistics : courseStatMap.values()) {
                log.debug("StudentCourseKexiaoDocument =={},{},{}", statistics, statistics.getLeftAmount(), statistics.getLeftNumber());
                if (ChargeUnit.isByTime(statistics.getChargeUnit())) {
                    doc.setFinishTime(doc.getFinishTime() + statistics.getKexiaoNumber() + statistics.getTransferNumber() + statistics.getRefundNumber());
                    doc.setNormalTime(doc.getNormalTime() + statistics.getKexiaoNormalNumber() + statistics.getTransferNormalNumber() + statistics.getRefundNormalNumber());
                } else {
                    doc.setFinishCount(doc.getFinishCount() + statistics.getKexiaoNumber() + statistics.getTransferNumber() + statistics.getRefundNumber());
                    doc.setNormalCount(doc.getNormalCount() + statistics.getKexiaoNormalNumber() + statistics.getTransferNormalNumber() + statistics.getRefundNormalNumber());
                }
                doc.setFinishMoney(statistics.getKexiaoAmount() + statistics.getTransferAmount() + statistics.getRefundAmount());
            }
        }
        return doc;
    }

    @Override
    public StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        finishCountMoney1(orgId, courseId, userId, signupCourseId, null);

        log.info("StudentCourseKexiaoDocument finishCountMoney = {},{},{},{}", orgId, courseId, userId, signupCourseId, status);
        StudentCourseKexiaoDocument kexiaoDocument = orgStudentKexiaoRecordDao.finishCountMoney(orgId, courseId, userId, signupCourseId, status);
        List<OrgSignupCourse> signupCourseList = signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);

        log.debug("StudentCourseKexiaoDocument signupCourseList = {},{}", signupCourseList, kexiaoDocument);
        List<Long> outPurchaseIds = Lists.newArrayList();
        Long classId = 0l;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            classId = signupCourse.getClassId();
            if (signupCourseId != null) {
                if (signupCourse.getId().longValue() == signupCourseId.longValue()) {
                    outPurchaseIds.add(signupCourse.getSignupPurchaseId());
                    break;
                }
            } else {
                outPurchaseIds.add(signupCourse.getSignupPurchaseId());
            }
        }

        if (CollectionUtils.isEmpty(outPurchaseIds)) {
            return kexiaoDocument;
        }

        TxTransferClassRecord txTransferClassRecord = transferClassRecordDao.sumByPurchases(outPurchaseIds, classId);
        log.debug("StudentCourseKexiaoDocument txTransferClassRecord=={}", txTransferClassRecord);
        if (txTransferClassRecord != null && txTransferClassRecord.getChargeUnit() != null) {
            if (txTransferClassRecord.getChargeUnit() != null && txTransferClassRecord.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()) {
                kexiaoDocument.setFinishCount(kexiaoDocument.getFinishCount() + txTransferClassRecord.getTransferLessonCount().longValue());
            } else {
                kexiaoDocument.setFinishTime(kexiaoDocument.getFinishTime() + txTransferClassRecord.getTransferLessonCount().longValue());
            }
            kexiaoDocument.setFinishMoney(kexiaoDocument.getFinishMoney() + txTransferClassRecord.getLessonMoney());
        }

        return kexiaoDocument;
    }

    @Override
    public void fillKexiaoData(KexiaoStatisticsSuper dto, KexiaoStatistics statistics) {
        String remainTuition = getLeftAmountStr(statistics);
        dto.setRemainTuition(remainTuition);

        //未补充,并且没有退班
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode() && !statistics.isHasHistoryRefund()) {
            dto.setTotalClassTimesForKexiaoValue(0);
            dto.setLeftClassTimesForKexiaoValue(0);
            dto.setFinishClassTimesForKexiaoValue(0);
            dto.setTotalClassTimesForKexiao("--");
            dto.setLeftClassTimesForKexiao("--");
            dto.setBuyClassTimesForKexiao("--");
        }else {
            dto.setTotalClassTimesForKexiaoValue((int) statistics.getTotalNumber());
            dto.setLeftClassTimesForKexiaoValue((int) statistics.getLeftNumber());
            dto.setFinishClassTimesForKexiaoValue((int) statistics.getKexiaoNumber());
            if (ChargeUnit.isByTime(statistics.getChargeUnit())) {
                dto.setTotalClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getLeftNumber()));
                dto.setFinishClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", dto);
            } else {
                long leftNum = statistics.getTotalNumber() - statistics.getKexiaoNumber();
                dto.setTotalClassTimesForKexiao(String.valueOf(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(String.valueOf(leftNum));
                dto.setFinishClassTimesForKexiao(String.valueOf(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(String.valueOf(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", dto);
            }
        }
    }
}