package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.util.CollectionHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 17/1/6.
 */
@Service
@Slf4j
public class CourseApiServiceImpl implements CourseApiService{

    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;

    @Override
    public Map<Long, Long> mapClassIdToCourseId(Collection<Long> classIds) {
        Map<Long, Long> retMap = new HashMap<>();
        List<OrgCourse> courses = courseDao.getByIds(classIds, "id", "parentId", "isCourse", "isClass", "courseType");
        for (OrgCourse course:courses){
            if(course.getIsClass()== CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse()==CourseTypeEnum.IS_COURSE_FALSE.getCode()){
                retMap.put(course.getId(),course.getParentId());
            }else {
                retMap.put(course.getId(), course.getId());
            }
        }
        return retMap;
    }

    @Override
    public long getCourseIdByClassId(long classId) {
        OrgCourse course = courseDao.getById(classId, "id", "parentId", "isCourse", "isClass", "courseType");
        if(CourseTypeEnum.isOneToOne(course.getCourseType())){
            return course.getParentId();
        }else {
            return course.getId();
        }
    }

    @Override
    public Map<Long, OrgCourseConsumeRule> getClassRule(Collection<Long> classIds) {
        Map<Long, OrgCourseConsumeRule> ret = new HashMap<>();
        if(classIds!=null && !classIds.isEmpty()){
            Map<Long, Long> classIdToCourseIdMap = mapClassIdToCourseId(classIds);
            if(classIdToCourseIdMap!=null && !classIdToCourseIdMap.isEmpty()){
                List<OrgCourseConsumeRule> rules = ruleDao.queryConsumRuleListByCourseIds(null, classIdToCourseIdMap.values());
                Map<Long,OrgCourseConsumeRule> ruleMap = CollectionHelper.toKeyMap(rules,"courseId");
                for (Long classId:classIds){
                    ret.put(classId,ruleMap.get(classIdToCourseIdMap.get(classId)));
                }
            }
        }
        return ret;
    }
}
