package com.baijia.tianxiao.sal.common.impl;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class BeanLocator implements ApplicationContextAware {

    private static ApplicationContext applicationContext = null;

    public static boolean isInit() {
        return applicationContext != null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        BeanLocator.applicationContext = applicationContext;
    }

    public static boolean containsBean(String beanName) {
        return applicationContext.containsBean(beanName);
    }

    public static String[] getAliases(String arg) {
        return applicationContext.getAliases(arg);
    }

    public static Object getBean(String beanName) throws BeansException {
        return applicationContext.getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> beanClass) throws BeansException {
        return applicationContext.getBean(beanName, beanClass);
    }

    public static Class<?> getType(String type) throws NoSuchBeanDefinitionException {
        return applicationContext.getType(type);
    }

    public static <T> T getBeanByRquire(Class<T> beanClass) {
        return applicationContext.getBean(beanClass);
    }

    public static boolean isSingleton(String beanName) throws NoSuchBeanDefinitionException {
        return applicationContext.isSingleton(beanName);
    }

}
