package com.baijia.tianxiao.sal.common.dto.kexiao;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import lombok.Data;

/**
 * Created by lxp on 2017/4/24.
 */
@Data
public class KexiaoStudentStat extends KexiaoStatistics {

    private long contractCount;
    private long contractTime;
    private long completeOrderCount;
    private long completeOrderTime;

    private long arrangeNormalCount;
    private long arrangeNormalTime;
    private long arrangeFreeCount;
    private long arrangeFreeTime;

    private long refundFreeCount;
    private long refundFreeTime;
    private long refundNormalCount;
    private long refundNormalTime;

    private long transferFreeCount;
    private long transferFreeTime;
    private long transferNormalCount;
    private long transferNormalTime;

    private long kexiaoNormalCount;
    private long kexiaoNormalTime;
    private long kexiaoFreeCount;
    private long kexiaoFreeTime;

    public void splitContractNumber(OrgSignupCourse signupCourse) {
        if (ChargeUnit.isByTime(getChargeUnit())) {
            this.contractTime += KexiaoUtil.getClassNumber(signupCourse);
        } else {
            this.contractCount += signupCourse.getLessonCount();
        }
        if(signupCourse.getLessonCount()>0){
            if (ChargeUnit.isByTime(getChargeUnit())) {
                this.completeOrderTime += KexiaoUtil.getClassNumber(signupCourse);
            } else {
                this.completeOrderCount += signupCourse.getLessonCount();
            }
        }
    }

    public void splitRefundNumber(OrgSignupRefund refund) {
        if (ChargeUnit.isByTime(getChargeUnit())) {
            this.refundNormalTime += refund.getRefundLessonCount();
        } else {
            this.refundNormalCount += refund.getRefundLessonCount();
        }
    }

    public void splitTransferNumber(TxTransferClassRecord record) {
        if (ChargeUnit.isByTime(getChargeUnit())) {
            transferNormalTime += record.getRealLessonCount();
            transferFreeTime += record.getFreeLessonCount();
        } else {
            transferNormalCount += record.getRealLessonCount();
            transferFreeCount += record.getFreeLessonCount();
        }
    }

    public void splitKexiaoNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime(getChargeUnit())) {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoNormalTime += lesson.getLessonDuration();
                }
                arrangeNormalTime += lesson.getLessonDuration();
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoFreeTime += lesson.getLessonDuration();
                }
                arrangeFreeTime += lesson.getLessonDuration();
            }
        } else {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoNormalCount++;
                }
                arrangeNormalCount++;
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()) {
                    kexiaoFreeCount++;
                }
                arrangeFreeCount++;
            }
        }
    }
}
