
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto;

import java.text.SimpleDateFormat;

import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
public abstract class WechatMsgTypeSuper {

    public abstract TxWechatTemplateMsgType getType();

    String timeFormatShort = "MM月dd日 HH:mm";

    /**
     * @return
     */
    public String createCourseTime(long startTime, long endTime) {
        return createCourseTime(timeFormatShort, startTime, endTime);
    }

    String timeFormatLong = "yyyy-MM-dd HH:mm";

    /**
     * @return
     */
    public String createFullCourseTime(long startTime, long endTime) {
        return createCourseTime(timeFormatLong, startTime, endTime);
    }

    private String createCourseTime(String formatStr, long startTime, long endTime) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        String time1 = format.format(startTime);
        String time2 = format.format(endTime);
        return time1 + "-" + time2.substring(time2.lastIndexOf(" ") + 1);
    }

}
