package com.baijia.tianxiao.sal.common.impl;

import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/10/26.
 */
@Slf4j
@Service
public class RedisDefaultServiceImpl extends AbstractBaseRedisDao implements RedisDefaultService {

    public String hGet(final String key, final String field) {
        return execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] byteFiled = serializer.serialize(field);
                byte[] value = connection.hGet(byteKey, byteFiled);
                if (value != null) {
                    return serializer.deserialize(value);
                } else {
                    return null;
                }
            }
        });
    }

    @Override
    public String get(final String key) {
        return execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] value = connection.get(byteKey);
                if (value != null) {
                    return serializer.deserialize(value);
                } else {
                    return null;
                }
            }
        });
    }

    @Override
    public void set(final String key, final String fieldValue) {
        execute(new RedisCallback<Void>() {
            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] byteValue = serializer.serialize(fieldValue);
                connection.set(byteKey, byteValue);
                return null;
            }
        });
    }

    @Override
    public boolean setIfExistsWithExpire(final String key, final String fieldValue, final long seconds) {
        return execute(new RedisCallback<Boolean>() {
            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                long expirTimeStep = seconds * 1000;
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);

                byte[] expirAt = serializer.serialize(String.valueOf(System.currentTimeMillis() + expirTimeStep));
                boolean isExists = true;
                if (connection.setNX(byteKey, expirAt)) {
                    log.info("key:{} not exists ", key);
                    isExists = false;
                    connection.expire(byteKey, seconds);
                } else {
                    byte[] expirTime = connection.get(byteKey);
                    String deserialize = serializer.deserialize(expirTime);
                    long oldTimeStamp = Long.parseLong(deserialize);
                    long currentTimeStamp = System.currentTimeMillis();
                    if (currentTimeStamp > oldTimeStamp) {
                        log.info("key:{} is expire", key);
                        long newExpirAtLong = currentTimeStamp + expirTimeStep;
                        log.info("oldExpiredAt:{} and newExpiredAt:{} ", oldTimeStamp, newExpirAtLong);
                        byte[] newExpirAt = serializer.serialize(String.valueOf(newExpirAtLong));
                        byte[] preTimeStamp = connection.getSet(byteKey, newExpirAt);
                        if (preTimeStamp != null) {
                            String preTimeStampSetRetStr = serializer.deserialize(preTimeStamp);
                            log.info("preTimeStampSetRetStr is:{} ", preTimeStampSetRetStr);
                            long preSetRetLong = Long.parseLong(preTimeStampSetRetStr);
                            if (preSetRetLong == oldTimeStamp) {
                                isExists = false;
                                log.info("success reset key's expir time:{}", key);
                            } else {
                                isExists = true;
                                log.info(
                                    "other client has reset key's expir time:{} , so current client can not get the lock",
                                    key);
                            }
                        } else {
                            isExists = false;
                            log.info("success reset key's expir time:{}", key);
                        }
                    } else {
                        log.info("key:{} not expired ", key);
                        isExists = true;
                    }
                }
                return isExists;
            }
        });
    }

    // public void del(final String key) {
    // execute(new RedisCallback<Void>() {
    // @Override
    // public Void doInRedis(RedisConnection connection) throws DataAccessException {
    // RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
    // byte[] byteKey = serializer.serialize(key);
    // connection.set(byteKey, byteValue);
    // return null;
    // }
    // });
    // }

    public void hSet(final String key, final String field, final String value) {
        execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] byteFiled = serializer.serialize(field);
                byte[] byteValue = serializer.serialize(value);
                connection.hSet(byteKey, byteFiled, byteValue);
                return null;
            }
        });
    }

    private <T> T execute(RedisCallback<T> callback) {
        Exception ex = null;
        for (int i = 0; i < 3; i++) {// 如果出现异常重试三次
            try {
                return redisTemplate.execute(callback);
            } catch (Exception e) {
                ex = e;
                try {
                    if (i < 2) {
                        Thread.sleep((i + 1) * 500);
                    }
                    log.warn("[Redis] try connect to redis.count={}", i + 1);
                } catch (InterruptedException e1) {
                    log.error("[Redis] InterruptedException ", e1);
                }
            }
        }
        log.error("[Redis] Query data exception.", ex);
        return null;
    }

}
