package com.baijia.tianxiao.sal.common.impl;

import java.util.concurrent.ConcurrentHashMap;

import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jan 4, 2016 12:08:42 AM
 * @desc :
 */
public class BeanCache {

    private static ConcurrentHashMap<Class<?>, Object> beanCache = new ConcurrentHashMap<>();

    @SuppressWarnings("unchecked")
    public static <T> T getBean(Class<? extends T> clazz) {
        T bean = (T) beanCache.get(clazz);
        if (bean == null) {
            if (BeanLocator.isInit()) {
                bean = BeanLocator.getBeanByRquire(clazz);
                registerBean(clazz);
            }
        }
        return bean;
    }

    public static void registerBean(Object bean) {
        beanCache.putIfAbsent(bean.getClass(), bean);
        registerBeanWithInterface(bean.getClass(), bean);
    }

    private static void registerBeanWithInterface(Class<? extends Object> clazz, Object bean) {
        if (clazz.getName().equals("java.lang.Object")) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<?> parentClass = clazz.getSuperclass();
        if (parentClass != null) {
            beanCache.putIfAbsent(parentClass, bean);
            registerBeanWithInterface(parentClass, bean);
        }
        if (GenericsUtils.notNullAndEmpty(interfaces)) {
            for (Class<?> clz : interfaces) {
                beanCache.putIfAbsent(clz, bean);
                registerBeanWithInterface(clz, bean);
            }
        }
    }


}
