
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.utils;

import java.lang.reflect.Field;

import com.baijia.tianxiao.sal.common.annotations.InitFieldAnnot;
import com.baijia.tianxiao.sal.common.impl.BeanCache;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Apr 6, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class BeanFieldInit {

    public static void initField(Object bean) {
        if (bean == null) {
            return;
        }
        Field[] declaredFields = bean.getClass().getDeclaredFields();
        if (GenericsUtils.notNullAndEmpty(declaredFields)) {
            for (Field field : declaredFields) {
                if (field.isAnnotationPresent(InitFieldAnnot.class)) {
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    Object fieldBean = BeanCache.getBean(fieldType);
                    try {
                        field.set(bean, fieldBean);
                    } catch (IllegalArgumentException | IllegalAccessException e) {
                        GenericsUtils.logErrorAndInfo(log, e, "can not find beanValue with field class:{} ", fieldType);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

}
